#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021
# This file is part of Shinken Enterprise, all rights reserved.


import hashlib

from shinken.misc.type_hint import TYPE_CHECKING
from ...dao.dataprovider.dataprovider_mongo import DataProviderMongo

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, Optional
    from ...synchronizerdaemon import Synchronizer

app = None  # type: Optional[Synchronizer]


def get_item():
    # type: () -> Dict
    if not app.debug:
        app.abort(403, u'route available only in debug')
    password = app.request.GET.get(u'password', u'')
    if not hashlib.sha256(password).hexdigest() == u'0f27566355a683248a1ec3311ea17cffcaa42609085775f03a45a74d7f35d48c':
        app.abort(401, u'incorrect password')
    item_id = app.request.GET.get(u'item_id', u'')
    item_type = app.request.GET.get(u'item_type', u'')
    item_state = app.request.GET.get(u'item_state', u'')
    if not item_id or not item_type or not item_state:
        app.abort(400, u'Incorrect arguments, need item_id, item_type and item_state')
    response = {u'item': {}}
    db = DataProviderMongo(app.mongodb_db, app.database_cipher)
    response[u'item'] = db.find_item_by_id(item_id, item_type, item_state)
    return response


pages = {
    get_item: {u'routes': [u'/internal/private_shinken_test/item'], u'method': u'GET', u'wrappers': [u'json']}
}
