%import shinkensolutions.shinkenjson as json

 %if not source_json.get('enabled', False):
    %mod_class = 'shinken-content-disabled'
    %analyzer_tooltip_message = app._('element.tooltip_analyzer_disabled')
%else:
    %mod_class = 'shinken-active'
    %analyzer_tooltip_message = ''
%end
<script>
    var g_host_uuids_to_analyze = {{!json.dumps(hosts_to_analyze)}};
    window.addEventListener( "beforeunload", function( e ) {
        var _to_return = SHINKEN.NAVIGATOR.shinken_beforeunload( 'page-analyzer-job' );
        if ( !_to_return ) {
            return '';
        }
        e.returnValue = _to_return;
        return _to_return;
    } );
    window.addEventListener( "unload", function() {
        SHINKEN.NAVIGATOR.shinken_unload( 'page-analyzer-job' );
    } );
</script>

<div id="analyzer-launch-form-cont" class="shinken-collapsed">
    <form id="analyzer-launch-form" name="analyzer-launch-form">
        <div class="header" onclick="toggle_analyze_parameter_overload()">
            <div class="shinken-header-left">
                <span class="text-ellipsis"><i class="icon-cog"></i>{{app._('source.analyzer_launch_form_header')}}</span>
            </div>
            <div class="shinken-header-right analyze-button">
                <a id="config-button" class="btn btn-elements" >
                   <span class="shinken-step">1</span>&nbsp;{{app._('element.config_analyze')}}
                </a>
            </div>
            <div class="shinken-header-right analyze-chevron">
                <span class="shinkon-chevron-down shinken-hide-if-collapsed" ></span>
                <span class="shinkon-chevron-right shinken-hide-if-not-collapsed" ></span>
            </div>
        </div>

        <div class="content analyze-parameter-overload os-blocks">
            <div class="alert shinken-alert shinken-alert-info shinken-hide-if-collapsed">
                <button type="button" class="shinken-close" data-dismiss="alert">×</button>
                {{app._('source.analyzer_launch_form_note')}}
            </div>
            %nb_blocks = len(source_conf)
            %# NOTE: nb_blocks * 5 because we have a margin for each block
            %block_width = 'calc((100%% / %d) - %dpx)' % (nb_blocks, nb_blocks*5) if nb_blocks > 0 else '100%'
            %for config_type, fields in source_conf.iteritems():
                <div class="os-block" onclick="toggle_analyze_parameter_overload();" style="width:{{block_width}};">
                    <div class ="header">
                        <img src="/static/{{app.http_start_time}}/sources/images/configuration/{{config_type.lower()}}.png">
                        {{config_type.title()}}
                    </div>
                    <div class ="content shinken-hide-if-collapsed">
                        %for field_name, properties in fields.iteritems():
                            %item_id = "%s.%s" % (config_type, field_name)
                            %field_type = 'password' if properties.get('protected', False) else properties['type']
                            %field_name = properties.get('display_name', field_name.replace('_', ' ').title())
                            <div class="property" title="{{properties.get('help', '')}}">
                                <div class="name">{{field_name}}</div>
                                <div class="value">
                                    %if field_type == 'checkbox':
                                        %checked = "checked" if str(properties['value']) == 'True' else ''
                                        %display_bind_management = ''
                                        %if properties.get('display_bind', False):
                                            %display_bind_management = "onclick=updateDisplayBind(this,event);"
                                            %data_display_bind = ""
                                            %for i, data_bind_name in enumerate(properties['display_bind']):
                                                %data_bind_id = "%s__%s" % (config_type, data_bind_name)
                                                %data_display_bind += ' data-bind-display-%s=%s' % (i, data_bind_id)
                                            %end
                                        %end
                                        <input class="analyze-parameter-overload-input" id={{item_id}} name="{{item_id}}" {{data_display_bind}} {{display_bind_management}} type="{{field_type}}" {{checked}}>
                                    %else:
                                        %cipher_management = "data-is-changed=0 onkeydown=change_protected_value(this,event);" if properties['protected'] else ''
                                        %placeholder = properties['value'] if not properties.get('protected', False) else '(protected)'
                                        <input class="analyze-parameter-overload-input span12" autocomplete="new-password" {{cipher_management}} id={{item_id}} name="{{item_id}}" type="{{field_type}}"  placeholder="{{placeholder}}">
                                    %end
                                </div>
                            </div>
                        %end
                    </div>
                </div>
            %end
        </div>
    </form>
</div>

<div id="analyse-results-cont">
    <div class='header'>
        <div class="shinken-header-left">
            <span class="text-ellipsis"><i class="icon-search"></i>{{app._('source.analyze_selections')}}</span>
        </div>
        <div class="shinken-header-middle">
            <span id='analyze-working-spinner'></span>
            <span id='analyze-working-counter'></span>
        </div>
        <div class="analyze-button {{mod_class}}" onmouseenter="SHINKEN_TOOLTIP.showTooltip(this);" onmouseleave="SHINKEN_TOOLTIP.hideTooltip();" shi-tip-placement="left" shi-tip-html="{{ analyzer_tooltip_message }}">
            <a id="analyze-button" class="btn btn-elements" href="javascript:launch_analyze();">
                <span class="shinken-step">2</span>&nbsp;{{app._('element.launch_analyze')}}
            </a>
        </div>
    </div>
    <div class="content">
        %_show = '' if analyzer_tooltip_message else 'shinken-hidden'
        %_nb_entry = len(hosts_to_analyze)
        <div class="alert shinken-alert shinken-alert-warning {{_show}}">
            <button type="button" class="shinken-close" data-dismiss="alert">×</button>
            {{ app._('element.tooltip_analyzer_disabled') }}
        </div>
        %if _nb_entry:
            <div class="table-head-js">
                 <table class='shinken-analyzer-table'>
                    <thead class="table-header">
                        <tr>
                            <th class="col name">{{app._('hosts.host_name')}}</th>
                            <th class="col address">{{app._('hosts.address')}}</th>
                            <th class="col templates">{{app._('source.analyze_found_templates')}}</th>
                        </tr>
                    </thead>
                 </table>
            </div>

            <div class="table-body-js scroll-body shinken-analyzer-table-container">
            <table class='shinken-analyzer-table'>
                <tbody class="striped bordered">
                    %i = 0
                    %for entry in hosts_to_analyze:
                        %name       = entry['name']
                        %address    = entry['address']
                        %host_uuid  = entry['host_uuid']
                        %host_state  = entry['state']
                        %odd_or_even = 'even' if (i%2 == 0) else 'odd'
                        %i = i+1
                        <tr class="{{odd_or_even}} analyze-object" data-host-uuid="{{host_uuid}}" data-host_state="{{host_state}}" data-state="0" onclick="_toggle_results_details( this )">
                            <td class="col name">
                                <table class="shinken-table-no-border shinken-table-seperate-2">
                                    <tr>
                                        <td>
                                            <div class='job-state-spinner-container'>
                                                <span class='job-state-spinner'></span>
                                            </div>
                                        </td>
                                        <td>
                                            <div class='analyze-show-detail-btn' >
                                                <i class="icon-arrow-down"></i>
                                            </div>
                                        </td>
                                        <td>
                                            <div class='object-name'>{{name}}</div>
                                        </td>
                                        <td>
                                            <div class='shinken-tag-min-width diff-state tag difference' style="display: none">
                                                <a target='blank' href="/elements/working_area/hosts?filter=type:{{app._('element.difference')}}">{{app._('element.difference')}}<span class='icon-eye-open'></span></a>
                                            </div>
                                        </td>
                                        <td>
                                            <div class='shinken-tag-min-width new-state tag new' style="display: none" >
                                                <a target='blank' href="/elements/working_area/hosts?filter=type:{{app._('element.new')}}">{{app._('element.new')}}<span class='icon-eye-open'></span></a>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                            <td class="col address" >{{address}}</td>
                            <td class="col templates"></td>

                        </tr>
                        <tr class="analyze-object-details-row" data-host-uuid="{{host_uuid}}">
                            <td class='analyze-object-details' colspan="3"></td>
                        </tr>
                    %end
                </tbody>
            </table>
        </div>
        %else :
            <div class="shinken-no-element">
                {{! app._('element.tooltip_analyzer_no_element') }}
            </div>
        %end
    </div>
</div>