%source = tagger
%include( "__shinken-lib", type="TAGGER")
%title="%s %s" % ( app._('source.%s' % source.my_type), source.get_name())

%rebase( "layout_skonf" , page_id="Taggers", title=title)

%mod = None
%mod_type = ''
%for m in source.modules:
%mod = m
%mod_type = m.properties['type']
%end

%type = 'collector' if source.my_type == 'source' else source.my_type
%sname = source.get_name()

%hosts_to_analyze=[]


%tab_active = app.request.GET.get('tab', None)
%if not tab_active:
%tab_active = 'tab-configuration'
%end

<div id="wrapper" class="source-index-view">
    <div class="shinken-content-header cover cover-purple">
        <div class="container-fluid shinken-source-header">
            <div class="row">
                %sname = tagger.get_name()
                <div class="col-sm-12">
                    <h3>
                        <a class="shinken-link" href="/main#id-shinken-table-tagger-main-page">
                            {{app._('main.tagger_maj')}}
                        </a>
                        >
                    </h3>
                    <h3>{{sname}}</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="content-main">
        <!-- Nav tabs -->
        <div class="tab-nav">
            <table class="nav nav-tabs shinken-window-group" role="tablist" data-name="tab-group" onclick="MANAGER.EventManager.clickOnWindowNavigation(event,'tab-group',true)">
                %_extra_class='shinken-active' if tab_active == 'tab-configuration' else ''
                <td id="tab-pane-configuration" class="shinken-window-element {{_extra_class}}" data-group-name="tab-group" data-name="tab-configuration">
                    <div class="shinken-tab-container">
                        <div class="shinken-tab-border"></div>
                        <div class="shinken-tab-item-link">
                            <span id="id-tab-pane-configuration" class="tab-item active">{{app._('source.configuration')}}</span>
                        </div>
                    </div>
                </td>
                %_extra_class='shinken-active' if tab_active == 'tab-rules' else ''
                <td id="tab-pane-rules" class="shinken-window-element {{_extra_class}}" data-group-name="tab-group" data-name="tab-rules">
                    <div class="shinken-tab-container">
                        <div class="shinken-tab-border"></div>
                        <div class="shinken-tab-item-link">
                            <span id="id-tab-pane-rule" class="tab-item active">{{app._('source.rules')}}</span>
                        </div>
                    </div>
                </td>
            </table>
        </div>

         <!-- Tab panes -->
        <div class="tab-content card card-shadow has-tab-attached">

            %_extra_class = 'shinken-hidden' if tab_active != 'tab-configuration' else ''
            <div id="tab-pane-configuration-target" class="property-tab-pane {{_extra_class}}" data-name="tab-configuration">
                %include( 'tab_tagger_conf', app=app, source=tagger)
            </div>

            %_extra_class = 'shinken-hidden %s'% tab_active if tab_active != 'tab-rules' else ''
            <div id="tab-pane-rules-target" class="{{_extra_class}}">
                %include( 'tab_tagger_rules', app=app, source=tagger)
            </div>
        </div>
    </div>
</div>

