<!DOCTYPE html>
%import shinkensolutions.shinkenjson as json
%#Set default values
%if not 'js' in locals():
    %js = []
%end
%if not 'title' in locals():
    %title = 'No title'
%end
%if not 'css' in locals():
    %css = []
%end
%if not 'print_menu' in locals():
    %print_menu = True
%end
%if not 'print_header' in locals():
    %print_header = True
%end
%if not 'refresh' in locals():
    %refresh = False
%end
%if not 'user' in locals():
    %user = None
%end
%if not 'app' in locals():
    %app = None
%end
%if not 'page_id' in locals():
    %page_id = ''
%end
%if not 'is_admin' in locals():
    %is_admin=False
%end

%# If not need, disable the top right banner
%if not 'top_right_banner_state' in locals():
    %top_right_banner_state = 0
%end

%# For the menu selection
%if not 'menu_part' in locals():
    %menu_part = ''
%end

%if 'configuration_stats' not in locals() and user is not None:
%    from shinken.synchronizer.business.sync_ui_common import syncuicommon
%    configuration_stats = syncuicommon.get_configuration_stats(user)
%end

%if not 'mypage' in locals():
    %mypage = None
%end

%default_state_workflow = 'save-in-working-area'
%if user is not None and is_admin:
    %default_state_workflow = 'save-direct-in-staging' if user.get('default_submit_to_staging', '1') == '1' or user.get('default_submit_to_staging', '1') == 'null'  else 'save-in-working-area'
    %# used by the list elements filters
    %if app is not None:
        %save_in_staging = app.request.GET.get('save_in_staging', '')
        %if save_in_staging:
            %if save_in_staging == '1':
                %default_state_workflow = 'save-direct-in-staging'
            %else:
                %default_state_workflow = 'save-in-working-area'
            %end
        %end
    %end
%end
%pages_with_working_area = ['my_working_area','working_area']
%attribut_list_type = ''
%if page_id == 'list' and 'mypage' in locals():
%   attribut_list_type = 'data-list-type=%s' %mypage
%   if mypage not in pages_with_working_area:
%       default_state_workflow = 'save-direct-in-staging'
%   end
%end
%controller = "SHINKEN-TODO"
%if page_id == 'list':
    %controller = "list-all"
%elif page_id == 'Sources':
    %controller = page_id
%end

%documentation_mode = app.request.GET.get('shinken_doc', False)
%test_auto_mode = app.request.GET.get('shinken_test_auto', False)


%# Add here page using the (last version) bootstrap and jquery
%pages_new = ['Sources', 'Taggers']

<script>
    // Global information.
    const PAGE = {
        id: '{{page_id}}'
    };
    %if user:
        var current_shinken_user    = {{!json.dumps(user.get_raw_item_for_front)}};
    %end
</script>

<html lang="en">
    <head>
        %if app:
            <script>
                var global_lang = '{{app.lang}}';
            </script>
        %end
        <style type="text/css">
            @font-face {
                font-family : 'FontAwesome';
                src         : url('/static/{{app.http_start_time}}/font/fontawesome-webfont.eot?v=3.0.1');
                src         : url('/static/{{app.http_start_time}}/font/fontawesome-webfont.eot?#iefix&v=3.0.1') format('embedded-opentype'),
                url('/static/{{app.http_start_time}}/font/fontawesome-webfont.woff?v=3.0.1') format('woff'),
                url('/static/{{app.http_start_time}}/font/fontawesome-webfont.ttf?v=3.0.1') format('truetype');
                font-weight : normal;
                font-style  : normal;
            }
            @font-face {
                font-family : "Lato";
                src         : url("/static/{{app.http_start_time}}/font/lato-regular.ttf") format("truetype");
                font-weight : normal;
                font-style  : normal;
            }
        </style>

        <meta name="viewport" content="width=device-width">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta charset="utf-8">
        <title>{{title or 'No title'}}</title>
        <link rel="stylesheet" type="text/css" href="/static/{{app.http_start_time}}/css/elements/header-element.css">
        <link rel="stylesheet" type="text/css" href="/static/{{app.http_start_time}}/main/css/main.css">
        <link rel="stylesheet" type="text/css" href="/static/{{app.http_start_time}}/main/css/element_panel.css">

        %if page_id not in pages_new:
            <link href="/static/{{app.http_start_time}}/css/bootstrap.css" rel="stylesheet">
        %else:
            <link href="/static/{{app.http_start_time}}/css/vendor/bootstrap.min.css" rel="stylesheet">
            <link href="/static/{{app.http_start_time}}/css/vendor/bootstrap-dropdown.css" rel="stylesheet">
        %end

        %for p in css:
            <link rel="stylesheet" type="text/css" href="/static/{{app.http_start_time}}/{{p}}">
        %end

        %if page_id not in pages_new:
            <script src="/static/{{app.http_start_time}}/js/jquery.js"></script>
            <script src="/static/{{app.http_start_time}}/js/jquery-ui-1.8.17.custom.min.js"></script>
        %else:
            <script src="/static/{{app.http_start_time}}/js/vendor/jquery-2.2.4.min.js"></script>
            <script src="/static/{{app.http_start_time}}/js/vendor/bootstrap.min.js"></script>
        %end
        <script src="/static/{{app.http_start_time}}/js/spin.min.js"></script>
        <script src="/static/{{app.http_start_time}}/js/shinkenui.js"></script>
        %if page_id not in pages_new:
            <script src="/static/{{app.http_start_time}}/js/bootstrap.js"></script>
        %end

        <!--Shinken ones-->
        <!--<script src="/static/{{app.http_start_time}}/js/shinken-saving-log.js"></script>-->
        <!--<script src="/static/{{app.http_start_time}}/js/shinken/controller/navigation-menu-controller.js"></script>-->
        <script src="/static/{{app.http_start_time}}/js/shinken-tooltip.js"></script>

        %# End of classic js import. Now call for specific ones
        %for p in js:
            <script type="text/javascript" src="/static/{{app.http_start_time}}/{{p}}"></script>
        %end

    </head>

    <body id="page-{{page_id}}" class="shinken-parent-event-listener" {{attribut_list_type}} data-is-admin="{{is_admin}}" data-state-work-flow="{{ default_state_workflow }}" data-controller="{{controller}}">
        <script>
            var http_start_time                               = {{app.http_start_time}};
            var protect_fields__substrings_matching_fields    = {{!json.dumps(app.protect_fields__substrings_matching_fields)}};
            var protect_fields__activate_interface_encryption = {{"true" if app.protect_fields__activate_interface_encryption else "false"}};
            var protect_fields__are_viewable_by_admin_si      = {{"true" if app.protect_fields__are_viewable_by_admin_si else "false"}};
        </script>

        %if print_header:
            %include( "header-top-bar/header_element_skonf" )
        %end

        <div class="shinken-content">
             {{!base}}
            %include( "footer_element")
        </div>

        <div id="id-shinken-window-modal" class="shinken-hidden">
            <div class="shinken-window-modal-content">
            </div>
            <div id="id-shinken-window-modal-close" class="shinken-modal-close-container shinken-hidden" onclick="MANAGER.EventManager.closeModal()"></div>
        </div>

    %if documentation_mode :
        %include("shinken_documentation")
    %end
        %if test_auto_mode or app.request.GET.get('shinken_debug', False):
        %include( "shinken_test_auto")
        %end
    </body>
</html>
