#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import Dict, TYPE_CHECKING, IN_TESTING

SourceConfItem = Dict[str, str]  # Type of item send to source (return by get_objects). For type hint.

try:
    from shinken.synchronizer.dao.def_items import METADATA, NAGIOS_TABLE_KEYS, ITEM_TYPE, ItemType, DEF_ITEMS, NOT_TO_LOOK, ITEM_STATE
    from shinken.synchronizer.dao.dataprovider.dataprovider_mongo import DataProviderMongo
    from shinken.synchronizer.dao.datamanagerV2 import get_type_item_from_class, get_class_from_type, get_name_from_type
    from shinken.synchronizer.dao.helpers import get_item_property
    from shinken.synchronizer.component.component_manager import component_manager, COMPONENT
    from shinken.synchronizer.component.translate_component import SourceTranslatePart
    from shinken.synchronizer.component.configuration_component import ConfigurationComponent
    from shinken.synchronizer.dao.validators.rules import RulesComponent
    from shinken.synchronizer.business.source.sourceinfoproperty import SourceInfoProperty
    from shinken.synchronizer.business.source.sourceinfo import SourceInfo
    from shinken.synchronizer.dao.helpers import escape_XSS
    from shinken.synchronizer.front_end.object.messages import Messages, MESSAGE
    from shinken.synchronizer.front_end.object.shinken_object import ShinkenObject
except ImportError as e:
    if TYPE_CHECKING or IN_TESTING:
        from synchronizer.dao.def_items import METADATA, NAGIOS_TABLE_KEYS, ITEM_TYPE, ItemType, DEF_ITEMS, NOT_TO_LOOK, ITEM_STATE
        from synchronizer.dao.dataprovider.dataprovider_mongo import DataProviderMongo
        from synchronizer.dao.datamanagerV2 import get_type_item_from_class, get_class_from_type, get_name_from_type
        from synchronizer.dao.helpers import get_item_property
        from synchronizer.component.component_manager import component_manager, COMPONENT
        from synchronizer.component.translate_component import SourceTranslatePart
        from synchronizer.component.configuration_component import ConfigurationComponent
        from synchronizer.dao.validators.rules import RulesComponent
        from synchronizer.business.source.sourceinfoproperty import SourceInfoProperty
        from synchronizer.business.source.sourceinfo import SourceInfo
        from synchronizer.dao.helpers import escape_XSS
        from synchronizer.front_end.object.messages import Messages, MESSAGE
        from synchronizer.front_end.object.shinken_object import ShinkenObject
    
    if not IN_TESTING:
        raise e
