#!/bin/bash

args_list=""
for arg in "$@"; do
    args_list="$args_list \"$arg\""
done

if [[ $EUID != 0 ]]; then
    printf "\033[31m Error: please launch this script as root\033[0m\n"
    exit 2
fi

if [[ ! -f lib/install_lib/patch.conf ]]; then
    printf "\033[31m Error: please launch the patch from its directory\033[0m\n"
    exit 2
fi

. lib/install_lib/patch.conf

. lib/common.sh
assert_dir_versions_and_patch_installations_exists

OUTPUT_FOLDER="$HOME/shinken/versions_and_patch_installations/$(date +%F-%Hh%Mm%S)-revert-patch-${PATCH_ID}"
LOG_PATH="${OUTPUT_FOLDER}/patch_installation_logs"
mkdir -p "${LOG_PATH}"
export OUTPUT_FOLDER

# The script command do not manage the -e on centos 7, so try it before run the real script call
script_arg=" -e "
script -e -c 'ls > /dev/null' -q 2>/dev/null
if [ $? != 0 ];then
   script_arg=""
   echo "Please Note that the revert-patch.sh return exit code is only available on centos 7."
fi

# Real launch
script $script_arg -c "lib/install_lib/revert-patch.sh $args_list" -q "${LOG_PATH}/shinken.enterprise.unpatch.log"
# The exit will be valid only for centos7
exit $?
lib/install_lib/