#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer import ITEM_TYPE
from shinkensolutions.api.synchronizer.source.item.source_business_impact_modulation import SourceBusinessImpactModulation
from shinkensolutions.api.synchronizer.source.item.source_cluster import SourceCluster
from shinkensolutions.api.synchronizer.source.item.source_cluster_template import SourceClusterTemplate
from shinkensolutions.api.synchronizer.source.item.source_command import SourceCommand
from shinkensolutions.api.synchronizer.source.item.source_contact import SourceContact
from shinkensolutions.api.synchronizer.source.item.source_contact_template import SourceContactTemplate
from shinkensolutions.api.synchronizer.source.item.source_contactgroup import SourceContactGroup
from shinkensolutions.api.synchronizer.source.item.source_escalation import SourceEscalation
from shinkensolutions.api.synchronizer.source.item.source_host import SourceHost
from shinkensolutions.api.synchronizer.source.item.source_host_template import SourceHostTemplate
from shinkensolutions.api.synchronizer.source.item.source_hostgroup import SourceHostGroup
from shinkensolutions.api.synchronizer.source.item.source_macro_modulation import SourceMacroModulation
from shinkensolutions.api.synchronizer.source.item.source_notificationway import SourceNotificationWay
from shinkensolutions.api.synchronizer.source.item.source_resultmodulation import SourceResultModulation
from shinkensolutions.api.synchronizer.source.item.source_service_cluster import SourceServiceCluster
from shinkensolutions.api.synchronizer.source.item.source_service_cluster_template import SourceServiceClusterTemplate
from shinkensolutions.api.synchronizer.source.item.source_service_host import SourceServiceHost
from shinkensolutions.api.synchronizer.source.item.source_service_host_template import SourceServiceHostTemplate
from shinkensolutions.api.synchronizer.source.item.source_service_template import SourceServiceTemplate
from shinkensolutions.api.synchronizer.source.item.source_timeperiod import SourceTimePeriod

ITEM_TYPE_TO_SOURCE_ITEM = {
    ITEM_TYPE.BUSINESSIMPACTMODULATIONS: SourceBusinessImpactModulation,
    ITEM_TYPE.CLUSTERS                 : SourceCluster,
    ITEM_TYPE.CLUSTERTPLS              : SourceClusterTemplate,
    ITEM_TYPE.COMMANDS                 : SourceCommand,
    ITEM_TYPE.CONTACTS                 : SourceContact,
    ITEM_TYPE.CONTACTTPLS              : SourceContactTemplate,
    ITEM_TYPE.CONTACTGROUPS            : SourceContactGroup,
    ITEM_TYPE.ESCALATIONS              : SourceEscalation,
    ITEM_TYPE.HOSTS                    : SourceHost,
    ITEM_TYPE.HOSTTPLS                 : SourceHostTemplate,
    ITEM_TYPE.HOSTGROUPS               : SourceHostGroup,
    ITEM_TYPE.MACROMODULATIONS         : SourceMacroModulation,
    ITEM_TYPE.NOTIFICATIONWAYS         : SourceNotificationWay,
    ITEM_TYPE.RESULTMODULATIONS        : SourceResultModulation,
    ITEM_TYPE.SERVICESCLUSTERS         : SourceServiceCluster,
    ITEM_TYPE.SERVICESCLUSTERTPLS      : SourceServiceClusterTemplate,
    ITEM_TYPE.SERVICESHOSTS            : SourceServiceHost,
    ITEM_TYPE.SERVICESHOSTTPLS         : SourceServiceHostTemplate,
    ITEM_TYPE.SERVICETPLS              : SourceServiceTemplate,
    ITEM_TYPE.TIMEPERIODS              : SourceTimePeriod
}
