#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2019:
#    Shinken solutions


import os

from common import get_real_path_from_source
from file import File


class ConcatenationConfig:
    def __init__(self, config):
        self.file = File(config['path'])
        self.filter_type = config['filter_type']
        self.filter = config['filter']
        self.name = config['name']
        self.extra_path = config.get('extra_path', False)
        self.files = []
    
    
    def init_content(self):
        for child_name in os.listdir(self.file.full_path):
            current = File(self.file.full_path, child_name)
            self.filter_files(current)
        self.files.sort(key=lambda x: x.priority)
        print self
    
    
    def filter_files(self, file):
        if not file.is_folder:
            if file.match_filter(self.filter_type, self.filter):
                self.files.append(file)
            return
        for child_name in os.listdir(file.full_path):
            current = File(file.full_path, child_name)
            self.filter_files(current)
    
    
    def createFile(self):
        _to_write = open(get_real_path_from_source(os.path.join("sources\\shinken-patched\\synchronizer\\htdocs\\generate-source", self.name)), "w+")
        _to_write.write(self.concat())
        _to_write.close()
    
    
    def createExtraFile(self):
        if not self.extra_path:
            return
        if isinstance(self.extra_path, list):
            for current in self.extra_path:
                _to_write = open(get_real_path_from_source(os.path.join(current, self.name)), "w+")
                _to_write.write(self.concat())
                _to_write.close()
        else:
            _to_write = open(get_real_path_from_source(os.path.join(self.extra_path, self.name)), "w+")
            _to_write.write(self.concat())
            _to_write.close()
    
    
    def concat(self):
        _to_return = ""
        if self.name.endswith('.js'):
            _to_return += "'use strict';\n"
        for file in self.files:
            _to_return += file.get_file_content()
        return _to_return
    
    
    def __repr__(self):
        return '"%s" ==> "filter=%s" \n files len [%s] \n\n\n\n %s' % (self.file, self.filter, len(self.files), self.files)
