SHINKEN.TOOLS.TEST_AUTO_MAIN_PAGE = (function ( self ) {
    self.DOM                                = {};
    self.TEST                               = {};
    self.TEST.JS                            = {};
    self.ACTION                             = {};
    self.GET                                = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getStaging                     = function () {
        return document.querySelector( '.content-staging' );
    };
    self.DOM.getSourcesAndTaggers           = function () {
        return document.querySelector( '.shinken-source-tagger-container' );
    };
    self.DOM.getSourcesContainer            = function () {
        return document.querySelector( '.shinken-sources-box' );
    };
    self.DOM.getSourcesTableALL             = function () {
        return document.querySelector( '#sortable-container-source-all' );
    };
    self.DOM.getSourceTaggerActionBar       = function () {
        return document.querySelector( '.shinken-source-tagger-action-bar' );
    };
    self.DOM.getButtonSwitchAllSources      = function () {
        return document.getElementById( "sort-list-source" );
    };
    self.DOM.getButtonSwitchSeparateSources = function () {
        return document.getElementById( "view-sources" );
    };
    self.DOM.getInputSearch                 = function () {
        return self.DOM.getSourceTaggerActionBar().querySelector( '.shinken-input-table .shinken-input[data-name="sources_searched_by_name"]' );
    };
    self.DOM.getCheckBoxHideInactiveSources = function () {
        return self.DOM.getSourceTaggerActionBar().querySelector( '.shinken-cell-checkbox-container[data-name="hide_inactive_source"]' );
    };
    self.DOM.sourceLine                     = function ( source_name ) {
        return document.querySelector( '#sortable-container-source-all .line-source[data-name="' + source_name + '"]' );
    };
    self.DOM.sourceState                    = function ( source_name, source_state ) {
        return self.DOM.sourceLine( source_name ).querySelector( 'td.column-state .' + source_state );
    };
    self.DOM.forceImportButton              = function ( source_name ) {
        return self.DOM.sourceLine( source_name ).querySelector( '.icon-play' );
    };
    //********************************************  TEST  **************************************************//
    self.TEST.isSourceExisting              = function ( timeout, source_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'isSourceExisting', source_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.sourceLine( source_name );
            SHINKEN.TOOLS.TEST_AUTO.___isExisting( _dom, "source " + source_name );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.isSourceState                 = function ( timeout, source_name, source_state ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'isSourceState', source_name + " - " + source_state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, self.DOM.sourceState( source_name, source_state ), source_name + " - " + source_state );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.hasSourceElements             = function ( timeout, source_name ) {
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'hasSourceElements', source_name );
        var _to_return = 50;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var elements_nb_list = self.DOM.sourceLine( source_name ).querySelectorAll( ".nb-elements-content .shinken-nb-elements" );
            var has_elements     = false;
            for ( var i = 0, _size = elements_nb_list.length; i < _size; i++ ) {
                if ( elements_nb_list[ i ].innerText > 0 ) {
                    has_elements = true;
                }
            }
            if ( !has_elements ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "The source " + source_name + " has no elements" );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.switchListSourceDisplay     = function ( timeout, all_source ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, all_source ? self.DOM.getButtonSwitchAllSources() : self.DOM.getButtonSwitchSeparateSources() );
        }, timeout );
        return 100;
    };
    self.ACTION.setValueSearchInput         = function ( timeout, to_set ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 0, self.DOM.getInputSearch(), to_set );
        }, timeout );
        return 400;
    };
    self.ACTION.ToggleSourcesByActivity     = function ( timeout, to_set ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getCheckBoxHideInactiveSources() );
        }, timeout );
        return 200;
    };
    self.ACTION.forceImport                 = function ( timeout, source_name ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.forceImportButton( source_name ) );
        }, timeout );
        return 5000;
    };
    self.ACTION.setSourceOrder              = function ( timeout, sorted_source_list ) {
        setTimeout( function () {
            var success = function ( _status, _data ) {
            
            };
            var error   = function ( err ) {
            
            };
            SHINKEN.COMUNICATION.requestGet( "http://" + SHINKEN.HIGHWAY.getHostName() + ":7766/api/sources/setorder?order=" + sorted_source_list.join( "," ), success, error );
        }, timeout );
        return 5000;
    };
    self.ACTION.swapTwoSourcesOrder         = function ( timeout, first_source, second_source ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'swapTwoSourcesOrder', first_source + "-" + second_source );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var sorted_source_list                    = self.GET.getSourceOrder();
            var first_source_index                    = sorted_source_list.indexOf( first_source );
            var second_source_index                   = sorted_source_list.indexOf( second_source );
            sorted_source_list[ second_source_index ] = first_source;
            sorted_source_list[ first_source_index ]  = second_source;
            self.ACTION.setSourceOrder( 0, sorted_source_list );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  GET   **************************************************//
    self.GET.getSourceOrder                 = function () {
        var source_container   = self.DOM.getSourcesContainer();
        var source_lines       = source_container.querySelectorAll( ".line-source" );
        var sorted_source_list = Array.apply( null, Array( source_lines.length - 1 ) ).map( function () {
        } );
        for ( var i = 0, _size = source_lines.length; i < _size; i++ ) {
            sorted_source_list[ source_lines[ i ].querySelector( ".shinken-line-number" ).innerText - 1 ] = source_lines[ i ].querySelector( ".shinken-title-source-name" ).innerText;
        }
        return sorted_source_list;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_MAIN_PAGE || {} );



