SHINKEN.TOOLS.TEST_AUTO_LOGGER = (function ( self ) {
    self.content = [];
    self.mapping = {};
    self.DOM     = {};
    self.TEST    = {};
    self.GET     = {};
    var __do_log__ = true;
    self.init    = function () {
        self.content = new SHINKEN_LIST.Set( document.querySelector( "#id-shinken-test-auto-log .shinken-list-container" ) );
    };
    //********************************************  DOM ELEMENT   **************************************************//
    //********************************************  GETTER SETTER **************************************************//
    self.add                 = function ( timeout, function_name, info ) {
        if ( !__do_log__ ){
            return;
        }
        if ( !__is_log_mute) {
            document.querySelector( "#id-shinken-test-auto-log" ).classList.remove( "shinken-hidden" );
        }
        if ( ! info ){
            info = "";
        }
        info             = info + "";
        info = SHINKEN.TOOLS.STRING.uncleanBeforecleanXss( info );
        var _uuid        = SHINKEN.TOOLS.STRING.buildUUID();
        var _dom_element = SHINKEN_LIST.FACTORY_HTML.Line( _uuid, ['?', timeout + "", function_name, info], self.content.headers );
        DOM.Service.addElementTo( _dom_element, self.content.dom_element.querySelector( "table tbody" ) );
        self.content.addLine( _dom_element );
        return _uuid;
    };
    self.changeElementStatus = function ( uuid, to_set, timeout ) {
        if ( !__do_log__ ){
            return;
        }
        if ( !uuid ) {
            return;
        }
        if ( !timeout ) {
            timeout = 0;
        }
        var self = this;
        setTimeout( function () {
            var _element = self.content.getLineByUUID( uuid );
            _element.changeElementValue( 'status', to_set );
        }, timeout );
    };
    self.setDoLog = function (to_set) {
        __do_log__ = to_set;
    };
    self.showInConsole       = function ( uuid, timeout, function_name, info ) {
        //console.log( "GSOU", "[TEST_AUTO_LOGGER - showInConsole]", self.content.getDataToExport() );
    };
    //********************************************  TEST          **************************************************//
    //********************************************  ACTION        **************************************************//
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_LOGGER || {} );
