SHINKEN.TOOLS.TEST_AUTO_SOURCE_LAST_RUN_TAB = (function ( self ) {
    self.DOM                          = {};
    self.TEST                         = {};
    self.ACTION                       = {};
    //********************************************  DOM   **************************************************//
    self.DOM.getTab                = function () {
        return document.querySelector( "#tab-pane-summary-old-run-target" );
    };
    self.DOM.showConfigurationButton               = function () {
        return self.DOM.getTab().querySelector( '.shinken-button[data-name="show_configuration_old_run"]' );
    };
    self.DOM.configurationTable               = function () {
        return self.DOM.getTab().querySelector( '#shinken-table-old-configuration-container' );
    };
    self.DOM.elementSentToSynchronizer               = function () {
        return self.DOM.getTab().querySelector( '.shinken-last-actions .table' );
    };
    self.DOM.TabExecutionsListContainer               = function () {
        return self.DOM.getTab().querySelector( "#run-times" );
    };
    self.DOM.allLastRun               = function () {
        return self.DOM.TabExecutionsListContainer().querySelectorAll( ".item-run-js .shinken-item-run" );
    };
    //********************************************  TEST   **************************************************//
    self.TEST.showConfigurationStatus = function ( timeout, state_expected ) {
        setTimeout( function () {
            var _table = self.DOM.configurationTable();
            switch ( state_expected ) {
                case COMPONENT.CONST.BTN_STATE.OFF:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _table, 'showConfiguration' );
                    break;
                case COMPONENT.CONST.BTN_STATE.ON:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _table, 'showConfiguration' );
                    break;
            }
        }, timeout );
        return 200;
    };
    self.TEST.elementSendToSynchronizer = function ( timeout) {
        setTimeout( function () {
            var _table = self.DOM.elementSentToSynchronizer();
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( _table, "nb_element", "", "", true );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( _table, "nb_element_warning", "", "", true );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( _table, "nb_element_error", "", "", true );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( _table, "nb_element_ok", "", "", true );
        }, timeout );
        return 200;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.toggleShowConfiguration     = function ( timeout ) {
        var _to_return = 400;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.toggleShowConfiguration' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.showConfigurationButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnLastRunByIndex     = function ( timeout, index_last_run ) {
        var _to_return = 400;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnLastRunByIndex' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            console.log("GSOU", "[ - ]", self.DOM.allLastRun() );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.allLastRun()[index_last_run] );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_SOURCE_LAST_RUN_TAB || {} );
