SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANEL_WEATHER = (function ( self ) {
    self.DOM                          = {};
    self.DOM.CHANGE                   = {};
    self.TEST                         = {};
    self.ACTION                       = {};
    self.CONST                        = {};
    var _INTERNAL                     = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getIframe                = function () {
        return SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANELS.DOM.getIframe();
    };
    self.DOM.tabsNavigation           = function () {
        return self.DOM.getIframe().querySelector( "#id-shinken-container-panels-view .shinken-view-manager-navigation" );
    };
    self.DOM.tabNavigation            = function () {
        return self.DOM.tabsNavigation().querySelector( '.shinken-window-element[data-name="weather_service"]' );
    };
    self.DOM.tabNavigationTotal       = function () {
        return self.DOM.tabNavigation().querySelector( ".shinken-counter.shinken-total-counter" );
    };
    self.DOM.getAllLineData           = function () {
        return self.DOM.getIframe().querySelectorAll( ".shinken-list-line" );
    };
    self.DOM.getButtonRemove          = function ( line_dom ) {
        return line_dom.querySelector( ".shinicon-delete" );
    };
    self.DOM.getClosePopup            = function () {
        return self.DOM.getIframe().querySelector( "#id-shinken-confirmation-popup-container" );
    };
    self.DOM.getClosePopupButtonOK    = function () {
        return self.DOM.getClosePopup().querySelector( ".shinken-action-button-confirmation-popup.shinken-validate-button" );
    };
    self.DOM.getClosePopupButtonNOK   = function () {
        return self.DOM.getClosePopup().querySelector( ".shinken-action-button-confirmation-popup.shinken-cancel-button" );
    };
    self.DOM.headers                  = function () {
        return self.DOM.getIframe().querySelectorAll( ".shinken-list-container-fix-header-filter .shinken-list-header" );
    };
    self.DOM.header                   = function ( header_name ) {
        return self.DOM.getIframe().querySelector( '.shinken-list-container-fix-header-filter .shinken-list-header[data-name="' + header_name + '"]' );
    };
    self.DOM.headerLabel              = function ( header_name ) {
        return self.DOM.header( header_name ).querySelector( ".shinken-list-header-name" );
    };
    self.DOM.headerButton             = function ( header_name ) {
        return self.DOM.header( header_name ).querySelector( ".shinken-sort-popup-button" );
    };
    self.DOM.headerButtonMenuOption   = function ( header_name, data_name ) {
        return self.DOM.header( header_name ).querySelector( '.shinken-list-header-sort-popup-option[data-name="' + data_name + '"]' );
    };
    self.DOM.headerSortingIndex       = function ( header_name ) {
        return self.DOM.header( header_name ).querySelector( ".shinken-list-header-sort-priority-number" );
    };
    self.DOM.headerSortingIcon        = function ( header_name ) {
        return self.DOM.header( header_name ).querySelector( ".shinken-list-header-sort-priority-icon-cell" );
    };
    self.DOM.filters                  = function () {
        return self.DOM.getIframe().querySelectorAll( ".shinken-list-container-fix-header-filter .shinken-list-filter" );
    };
    self.DOM.lines                    = function () {
        return self.DOM.getIframe().querySelectorAll( ".shinken-list-container-with-scroll .shinken-list-line" );
    };
    self.DOM.lineWithName             = function ( line_name ) {
        var _doms = self.DOM.lines();
        for ( var i = 0, _size_i = _doms.length; i < _size_i; i++ ) {
            if ( _INTERNAL.isLine( _doms[ i ], line_name ) ) {
                return _doms[ i ];
            }
        }
        return null;
    };
    self.DOM.linesNotFiltered         = function () {
        return self.DOM.getIframe().querySelectorAll( ".shinken-list-container-with-scroll .shinken-list-line:not(.shinken-is-filtered)" );
    };
    self.DOM.CHANGE.buttonOpen        = function ( dom_element_line ) {
        return dom_element_line.querySelector( ".shinken-button-change-view-owner" );
    };
    self.DOM.CHANGE.input             = function ( dom_element_line ) {
        return dom_element_line.querySelector( ".shinken-input" );
    };
    self.DOM.CHANGE.buttonValidChange = function ( dom_element_line ) {
        return dom_element_line.querySelector( ".shinken-change-owner-popup-button.shinken-change-owner-apply-button" );
    };
    self.DOM.cell                     = function ( dom_element_line, cell_name ) {
        return dom_element_line.querySelector( '.shinken-list-cell[data-name="' + cell_name + '"]' );
    };
    self.DOM.filter                   = function ( filter_name ) {
        return self.DOM.getIframe().querySelector( '.shinken-list-container-fix-header-filter .shinken-list-filter[data-name="' + filter_name + '"]' );
    };
    self.DOM.filterInput              = function ( filter_name ) {
        return self.DOM.filter( filter_name ).querySelector( '.shinken-input' );
    };
    
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.sorting                   = function ( timeout, header_name, index_sort, type_sort ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.headerNumber', header_name + " -> " + index_sort + " -> " + type_sort );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.headerSortingIndex( header_name ), index_sort ? index_sort : "", 'index_sort' );
            var _dom = self.DOM.headerSortingIcon( header_name );
            switch ( type_sort ) {
                case SHINKEN.OBJECT.Sorting.CONST.STATUS.INCREASING :
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom.querySelector( ".shinicon-sort-decrease" ), "shinicon-sort-decrease" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom.querySelector( ".shinicon-sort-increase" ), "shinicon-sort-increase" );
                    break;
                case SHINKEN.OBJECT.Sorting.CONST.STATUS.DECREASING :
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom.querySelector( ".shinicon-sort-decrease" ), "shinicon-sort-decrease" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom.querySelector( ".shinicon-sort-increase" ), "shinicon-sort-increase" );
                    break;
                case SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE :
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom.querySelector( ".shinicon-sort-decrease" ), "shinicon-sort-decrease" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom.querySelector( ".shinicon-sort-increase" ), "shinicon-sort-increase" );
                    break;
            }
            //_INTERNAL.testNumber( self.DOM.lines(), value_expected_total );
            //_INTERNAL.testNumber( self.DOM.linesNotFiltered(), value_expected_displayed, value_expected_displayed );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.viewsNumber               = function ( timeout, value_expected_total, value_expected_displayed ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.headerNumber', value_expected_total + " -> " + value_expected_displayed );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.tabNavigationTotal(), value_expected_total, 'value_expected_total' );
            _INTERNAL.testNumber( self.DOM.lines(), value_expected_total );
            _INTERNAL.testNumber( self.DOM.linesNotFiltered(), value_expected_displayed, value_expected_displayed );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.headersNumber             = function ( timeout, value_expected ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.headerNumber', value_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            _INTERNAL.testNumber( self.DOM.headers(), value_expected, value_expected );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.filtersNumber             = function ( timeout, value_expected ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.filtersNumber', value_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            _INTERNAL.testNumber( self.DOM.filters(), value_expected, value_expected );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.displayAtLine             = function ( timeout, line_name, number_line ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.displayAtLine', line_name + " => " + number_line );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _doms = self.DOM.lines();
            if ( !_INTERNAL.isLine( _doms[ number_line ], line_name ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "displayAtLine not at the good line", line_name + " => " + number_line );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    _INTERNAL.testNumber                = function ( doms, value_expected, value_visible ) {
        SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( doms, value_expected, '' );
        if ( value_visible ) {
            for ( var i = 0, _size_i = doms.length; i < _size_i; i++ ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, doms[ i ], "isVisible" );
            }
        }
    };
    _INTERNAL.isLine                    = function ( dom_element_line, line_name ) {
        return self.DOM.cell( dom_element_line, "name" ).innerText === line_name;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.askForRemoveByIndex     = function ( timeout, index ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.askForRemoveByIndex', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _doms = self.DOM.getAllLineData();
            if ( !_INTERNAL.removeLine( _doms[ index ] ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "FORBIDDEN TO REMOVE WEATHER WITH UUID " + SHINKEN.TOOLS.TEST_AUTO.WEATHER_DEFAULT_UUID );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.validClosePopup         = function ( timeout ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.validClosePopup', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getClosePopupButtonOK() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.cancelClosePopup        = function ( timeout ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.cancelClosePopup', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getClosePopupButtonNOK() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.resetPanelContent       = function ( timeout ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.cancelClosePopup', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _doms = self.DOM.getAllLineData();
            for ( var i = 0, _size_i = _doms.length; i < _size_i; i++ ) {
                _INTERNAL.removeLine( _doms[ i ] );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.filter                  = function ( timeout, filter_name, filter_value ) {
        var _to_return = 250;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.filter', "filter_name -> filter_value" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( 0, self.DOM.filterInput( filter_name ), filter_value );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnHeaderLabel      = function ( timeout, header_name, do_shift ) {
        var _to_return = 250;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnHeaderLabel', "header_name" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( do_shift ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.shiftClick( 0, self.DOM.headerLabel( header_name ) );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.headerLabel( header_name ) );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnHeaderMenu       = function ( timeout, header_name ) {
        var _to_return = 250;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnHeaderOption', "header_name" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.headerButton( header_name ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnHeaderMenuOption = function ( timeout, header_name, option_name ) {
        var _to_return = 250;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnHeaderMenuOption', header_name + " -> " + option_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.headerButtonMenuOption( header_name,option_name ), false, 10 );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnChangeUser       = function ( timeout, line_name ) {
        var _to_return = 2500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnChangeUser', line_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.CHANGE.buttonOpen( self.DOM.lineWithName( line_name ) ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.filterUserInChangeUser  = function ( timeout, line_name, new_owner_name ) {
        var _to_return = 2500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.filterUserInChangeUser', line_name + " -> " + new_owner_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( 0, self.DOM.CHANGE.input( self.DOM.lineWithName( line_name ) ), new_owner_name );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.validChangeUserInInput  = function ( timeout, line_name ) {
        var _to_return = 2500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.validChangeUserInInput', line_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.CHANGE.buttonValidChange( self.DOM.lineWithName( line_name ) ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    _INTERNAL.removeLine                = function ( dom ) {
        if ( dom.dataset.uuid === SHINKEN.TOOLS.TEST_AUTO.WEATHER_DEFAULT_UUID ) {
            return false;
        }
        SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getButtonRemove( dom ) );
        return true;
    };
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANEL_WEATHER || {} );
