//__lib__ lib_common
'use strict';

SHINKEN_LIST.Line           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Line.prototype = {
    init          : function ( dom_element ) {
        this.dom_element = dom_element;
        this.is_filtered = this.dom_element.classList.contains( "shinken-is-filtered" ) ? SHINKEN_LIST.CONST.FILTER.STATUS.ON : SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
        this.is_collapse = false;
        this.uuid        = this.dom_element.dataset.uuid;
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                this.host    = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeItem, this.dom_element.dataset.uuidItem ) );
                this.parent  = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeItem, this.dom_element.dataset.uuidParent ) );
                this.check   = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeCheck, this.dom_element.dataset.uuidCheck ) );
                this.dfe_key = this.dom_element.dataset.dfeKey;
                break;
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.parent_uuid           = this.dom_element.dataset.uuidParent;
                this.parent_select_element = DOM.Service.findParentElementWithClass( this.dom_element, this.dom_element.dataset.parentSelectClass, 20 );
                break;
            case SHINKEN_LIST.CONST.TYPE.DATA_PROP:
                this.uuid = this.dom_element.dataset.name;
                break;
        }
        this.initIsSelected();
        this.initCellsValue();
    },
    initIsSelected: function () {
        if ( this.dom_element.classList.contains( "shinken-selected-disabled" ) ) {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        else if ( this.dom_element.classList.contains( "shinken-selected" ) ) {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.ON;
        }
        else {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        }
        this.is_selected_counter = new SHINKEN.OBJECT.Counter();
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                if ( !this.parent_uuid ) {
                    this.is_selected_counter.setParent( CONTROLLER.MassChange.mass_change_element_selected );
                }
                this.updateSelectionCounter();
                if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
                    this.initCounters( CONTROLLER.MassChange.steps.get().button_next, true );
                }
                break;
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                this.is_selected_counter.setParent( CONTROLLER.MassChange.mass_change_checks_selected );
                break;
        }
    },
    initCellsValue: function () {
        this.cell_value = {};
        var _cells      = this.dom_element.querySelectorAll( ".shinken-list-cell" );
        var _current;
        for ( var i = 0, _size_i = _cells.length; i < _size_i; i++ ) {
            _current = _cells[ i ];
            if ( _current.dataset.filterValueArray ) {
                this.cell_value[ _current.dataset.filter ] = _current.dataset.filterValueArray.split( "," );
            }
            else if ( _current.dataset.filterValue ) {
                this.cell_value[ _current.dataset.filter ] = _current.dataset.filterValue;
            }
            else {
                if ( _current.dataset.filter ) {
                    this.cell_value[ _current.dataset.filter ] = DOM.Service.getInnerText( _current );
                }
                else {
                    this.cell_value[ i ] = DOM.Service.getInnerText( _current );
                }
            }
        }
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.DATA_PROP:
                this.cell_value[ 'data_name_array' ] = this.uuid;
                break;
        }
    },
    //********************************************  FILTERS  *****************************************************//
    applyFilter: function ( filters ) {
        var _filter = SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
        for ( var i = 0, _size_i = filters.length; i < _size_i; i++ ) {
            var _value_filter = filters[ i ].getValue();
            var _value_cell   = this.cell_value[ filters[ i ].getName() ];
            switch ( _value_cell ) {
                case SHINKEN_LIST.CONST.FILTER.HAS_CHILDREN:
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.HAS_CHILDREN;
                    continue;
            }
            var _type_filter = filters[ i ].type;
            switch ( _type_filter ) {
                case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                    if ( _value_filter === SHINKEN_LIST.CONST.FILTER.ALL ) {
                        break;
                    }
                    else if ( _value_filter === SHINKEN_LIST.CONST.FILTER.NOT_EMPTY ) {
                        if ( Array.isArray( _value_cell ) ) {
                            if ( SHINKEN.TOOLS.ARRAY.contains( _value_cell, SHINKEN_LIST.CONST.FILTER.EMPTY ) ) {
                                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                            }
                        }
                        else if ( _value_cell === SHINKEN_LIST.CONST.FILTER.EMPTY ) {
                            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                        }
                        break;
                    }
                    if ( Array.isArray( _value_cell ) ) {
                        if ( !SHINKEN.TOOLS.ARRAY.contains( _value_cell, _value_filter ) ) {
                            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                        }
                    }
                    else if ( _value_cell !== _value_filter ) {
                        _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                    }
                    break;
                case PROPERTY.CONST.TYPES.STRING_INPUT:
                    if ( !SHINKEN.TOOLS.STRING.containsIgnoreCase( _value_cell, _value_filter ) ) {
                        _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                    }
                    break;
                case SHINKEN_LIST.CONST.FILTER.TYPE.INPUT_STRING_ARRAY:
                    var _list  = _value_filter.split( "," );
                    var _found = false;
                    for ( var j = 0, _size_j = _list.length; j < _size_j; j++ ) {
                        if ( _list[ j ] === _value_cell ) {
                            _found = true;
                            break;
                        }
                    }
                    if ( !_found ) {
                        _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                    }
                    break;
            }
        }
        this.setFilter( _filter );
    },
    setFilter  : function ( to_set ) {
        this.is_filtered = to_set;
        switch ( this.is_filtered ) {
            case SHINKEN_LIST.CONST.FILTER.STATUS.ON:
                this.dom_element.classList.add( "shinken-is-filtered" );
                break;
            case SHINKEN_LIST.CONST.FILTER.STATUS.OFF:
                this.dom_element.classList.remove( "shinken-is-filtered" );
                break;
        }
    },
    isFiltered : function () {
        return this.is_filtered === SHINKEN_LIST.CONST.FILTER.STATUS.ON;
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID               : function () {
        return this.uuid;
    },
    toggleSelect          : function () {
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.OFF );
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
                break;
        }
    },
    setIsSelected         : function ( to_set ) {
        if ( this.is_filtered ) {
            return;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return;
        }
        this.is_selected = to_set;
        this.updateSelectionCounter();
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.dom_element.classList.add( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.add( "shinken-selected-parent" );
                }
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.dom_element.classList.remove( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.remove( "shinken-selected-parent" );
                }
                break;
        }
        
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                switch ( this.is_selected ) {
                    case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                        this.showCountersForParent();
                        break;
                    default:
                        this.hideCountersForParent();
                        break;
                }
        }
        
    },
    updateSelectionCounter: function () {
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.is_selected_counter.update( this.uuid, this.isSelected() ? 1 : 0 );
                break;
        }
    },
    setDataSet            : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        if ( if_key ) {
            if ( if_function === "matching_regex" ) {
                if ( !SHINKEN.TOOLS.STRING.isMatchingStarRegexTab( this.cell_value[ if_key ], if_values ) ) {
                    data_value = else_data_value;
                }
            }
            else {
                if ( !SHINKEN.TOOLS.STRING.containsAny( this.cell_value[ if_key ], if_values ) ) {
                    data_value = else_data_value;
                }
            }
        }
        DOM.Service.setDataSet( this.dom_element, datakey, data_value );
    },
    isSelected            : function () {
        return this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON;
    },
    isSelectedOrFiltered  : function () {
        if ( this.is_filtered ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        return this.is_selected;
    },
    getData               : function ( key ) {
        return this.dom_element.dataset[ key ];
    },
    getCellValue          : function ( key ) {
        return this.cell_value[ key ];
    },
    changeElementValue    : function ( key, to_set ) {
        if ( this.getCellValue( key ) !== undefined ) {
            this.dom_element.querySelector( '.shinken-list-cell[data-filter="' + key + '"]' ).innerHTML = to_set;
        }
    },
    //********************************************  COLLAPSE  *****************************************************//
    toggleCollapse        : function ( childrens ) {
        this.setIsCollapsed( !this.is_collapse );
        for ( var i = 0, _size_i = childrens.length; i < _size_i; i++ ) {
            childrens[ i ].setIsCollapsed( this.is_collapse );
        }
    },
    setIsCollapsed        : function ( to_set, childrens ) {
        this.is_collapse = to_set;
        if ( this.is_collapse ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
        if ( childrens ) {
            for ( var i = 0, _size_i = childrens.length; i < _size_i; i++ ) {
                childrens[ i ].setIsCollapsed( this.is_collapse );
            }
        }
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave  : function ( type ) {
        var _to_return;
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                switch ( type ) {
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                        _to_return       = {};
                        _to_return.value = this.isSelected() ? true : false;
                        if ( this.dom_element.dataset.originalSelected === "1" ) {
                            _to_return.value = !_to_return.value;
                        }
                        _to_return.check_link = this.check.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        break;
                    default:
                        _to_return      = [];
                        _to_return[ 0 ] = this.host.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 1 ] = this.parent.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 2 ] = this.check.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 3 ] = this.dfe_key;
                        break;
                }
            
        }
        return _to_return;
    },
    getDataToExport: function ( headers ) {
        var _to_return = [];
        var _current;
        for ( var i = 0, _size_i = headers.length; i < _size_i; i++ ) {
            _to_return.push( this.getCellValue( headers[ i ] ) || "" );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Line, SHINKEN.OBJECT.CounterInterface );

SHINKEN_LIST.FACTORY_HTML.Line = function ( uuid, line_data, headers ) {
    var _to_return = DOM.Service.createElement( "tr", { class: "shinken-list-line", "data-uuid": uuid } );
    for ( var i = 0, _size_i = line_data.length; i < _size_i; i++ ) {
        DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-list-cell", "data-filter": headers[ i ].name }, line_data[ i ] ), _to_return );
    }
    return _to_return;
};