//priority 20
//__lib__ lib_common
'use strict';

SHINKEN.OBJECT.CONST.PHASE = {
    RUNNING                 : 0,
    REFRESHING              : 1,
    INIT                    : 2,
    EDITING                 : 3,
    SAVING                  : 4,
    WAITING_FOR_START_IMPORT: 5,
    WAITING_FOR_IMPORT      : 6,
    WAITING_FOR_MERGE       : 7,
    WAITING_FOR_UPDATE      : 8,
    READY                   : 9,
    WAITING_FOR_READY       : 10,
    STOPPING                : 11,
    STARTING                : 12,
    STUCK                   : 13,
    HIDDEN                  : 14,
    ASKING_ENTER_PREVIEWING : 15,
    PREVIEWING              : 16,
    ASKING_ENTER_EDITING    : 17,
    ASK_FOR_REFRESH         : 18,
    RUNNING_OK              : 19,
    RUNNING_NOK             : 20
};
SHINKEN.OBJECT.CONST.CALLBACK_PHASE_TIMEOUT = 0;

SHINKEN.OBJECT.Phase           = function ( parent_object ) {
    this.previous_phase             = null;
    this.current_phase              = SHINKEN.OBJECT.CONST.PHASE.INIT;
    this.next_phase                 = null;
    this.parent_object              = parent_object;
    this.timeout_set_phase_callback = null;
    this.timeout_phase              = null;
};
SHINKEN.OBJECT.Phase.prototype = {
    setPhase           : function ( to_set ) {
        if ( this.timeout_phase ) {
            clearTimeout( this.timeout_phase );
        }
        this.previous_phase = this.current_phase;
        this.current_phase  = to_set;
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'currentPhase', this.current_phase );
        }
        this.next_phase = null;
        if ( this.parent_object ) {
            
            var _self = this;
            if ( _self.timeout_set_phase_callback ) {
                clearTimeout( _self.timeout_set_phase_callback );
            }
            _self.timeout_set_phase_callback = setTimeout( function () {
                _self.parent_object.callbackForPhase();
                _self.timeout_set_phase_callback = null;
            }, SHINKEN.OBJECT.CONST.CALLBACK_PHASE_TIMEOUT );
        }
    },
    setPhaseWithTimeOut: function ( to_set, timeout ) {
        if ( !timeout ) {
            timeout = 0;
        }
        var self = this;
        this.timeout_phase = setTimeout( function () {
            self.setPhase( to_set );
        }, timeout );
    },
    isPhase            : function ( to_test ) {
        return this.current_phase === to_test;
    },
    isPreviousPhase    : function ( to_test ) {
        if ( !this.previous_phase ) {
            return false;
        }
        return this.previous_phase === to_test;
    },
    setParent          : function ( parent_object ) {
        this.parent_object = parent_object;
    },
    setDomElement      : function ( to_set ) {
        this.dom_element = to_set;
    }
};

SHINKEN.OBJECT.PhaseInterface           = function () {
};
SHINKEN.OBJECT.PhaseInterface.prototype = {
    initPhase          : function ( dom_element ) {
        this.phase = new SHINKEN.OBJECT.Phase( this );
        if ( dom_element ) {
            this.phase.setDomElement( dom_element );
        }
    },
    isPhase            : function ( to_test ) {
        return this.phase.isPhase( to_test );
    },
    setPhase           : function ( to_set ) {
        this.phase.setPhase( to_set );
    },
    setPhaseParent     : function ( to_set ) {
        this.phase.setParent( to_set );
    },
    setPhaseIfNotPhase : function ( to_set, if_not ) {
        if ( this.phase.isPhase( if_not ) ) {
            return;
        }
        this.phase.setPhase( to_set );
    },
    setPhaseWithTimeOut: function ( to_set, timeout ) {
        this.phase.setPhaseWithTimeOut( to_set, timeout );
    },
    getCurrentPhase    : function () {
        return this.phase.current_phase;
    },
    hasPreviousPhase   : function ( to_test ) {
        return this.phase.isPreviousPhase( to_test );
    },
    callbackForPhase   : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.PhaseInterface, SHINKEN.OBJECT.ShinkenObject );