//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.ShinkenElement           = function () {
};
SHINKEN.OBJECT.ShinkenElement.prototype = {
    //********************************  INIT    ******************************************************************//
    init: function ( data ) {
        this.updateData( data );
    },
    //********************************  SETTER GETTER    ******************************************************************//
    getUUID             : function () {
        return this.uuid;
    },
    getName             : function () {
        return this.name;
    },
    setUUID             : function ( to_set ) {
        this.uuid = to_set;
    },
    setExists           : function ( to_set ) {
        if ( this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ] === to_set ) {
            return false;
        }
        this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ] = to_set;
        return true;
    },
    isNotAuthorized     : function ( to_set ) {
        if ( this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] === to_set ) {
            return false;
        }
        this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] = to_set;
        return true;
    },
    setName             : function ( to_set ) {
        if ( this.name === to_set ) {
            return false;
        }
        this.name = to_set;
        return true;
    },
    setVisualisationName: function ( to_set ) {
        if ( this.visualisation_name === to_set ) {
            return false;
        }
        this.visualisation_name = to_set;
        return true;
    },
    setContext          : function ( to_set ) {
        if ( this.context && this.context.isByCode( to_set ) ) {
            return false;
        }
        this.context = this.context || new SHINKEN.Status();
        this.context.setCode( to_set );
        return true;
    },
    setStatus           : function ( to_set ) {
        if ( this.status && this.status.isByCode( to_set ) ) {
            return false;
        }
        this.status = this.status || new SHINKEN.Status();
        this.status.setCode( to_set );
        return true;
    },
    setSlaValue         : function ( to_set ) {
        if ( this.sla_value === to_set ) {
            return false;
        }
        this.sla_value = to_set;
        return true;
    },
    setSlaTendency      : function ( to_set ) {
        if ( this.tendency === to_set ) {
            return false;
        }
        this.tendency = to_set;
        return true;
    },
    //********************************  UPDATE DATA    ******************************************************************//
    updateData: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case OBJECT.CONST.ELEMENT.FIELD_UI.ITEM_UUID:
                this.setUUID( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.STATUS:
                this.setStatus( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.CONTEXT:
                this.setContext( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.__KEY__:
                this.updateData( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.VALUE:
                this.setSlaValue( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.TENDENCY:
                this.setSlaTendency( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.WARNING_THRESHOLD:
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.CRITICAL_THRESHOLD:
                this[ "sla_" + key ] = value;
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.ITEM_TYPE:
            case OBJECT.CONST.ELEMENT.FIELD_UI.ITEM_NAME:
            case OBJECT.CONST.ELEMENT.FIELD_UI.NAME:
            case OBJECT.CONST.ELEMENT.FIELD_UI.VISUALISATION_NAME:
                this[ key ] = value;
                break;
            default:
                console.warn( "[IGNORED DATA]", key, value );
                this.setUnknownValue(key, value);
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenElement, SHINKEN.OBJECT.ShinkenObjectJson );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenElement, SHINKEN.OBJECT.PhaseInterface );