//priority 10
//__lib__ lib_common
SHINKEN.TOOLS.ARRAY = (function ( self ) {
    "use strict";
    
    self.concat                     = function ( array_1, array_2 ) {
        var toReturn = array_1.concat( array_2 );
        return toReturn;
    };
    self.concatUnique               = function ( array_1, array_2, key_for_unique ) {
        var toReturn = [];
        var _size    = array_1.length;
        for ( var i = 0; i < _size; i++ ) {
            toReturn[ i ] = array_1[ i ];
        }
        _size = array_2.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( !key_for_unique ) {
                self.addElement( toReturn, array_2[ i ] );
            }
            else if ( !self.containsElementWith( toReturn, array_2[ i ][ key_for_unique ], key_for_unique ) ) {
                toReturn.push( array_2[ i ] );
            }
        }
        return toReturn;
    };
    self.concatUniqueIfNotPresentIn = function ( array_1, array_2, array_3 ) {
        var toReturn = [];
        var _size    = array_1.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( !self.contains( array_3, array_1[ i ] ) ) {
                toReturn[ i ] = array_1[ i ];
            }
        }
        _size = array_2.length;
        for ( i = 0; i < _size; i++ ) {
            if ( !self.contains( array_3, array_2[ i ] ) ) {
                self.addElement( toReturn, array_2[ i ] );
            }
        }
        return toReturn;
    };
    self.sortNumber                 = function ( array ) {
        if ( !array ) {
            return array;
        }
        return array.sort( function ( a, b ) {
            return a - b;
        } );
    };
    self.sortArray                  = function ( array, comparator_value, first_index_to_sort, reverse ) {
        if ( reverse === undefined ) {
            reverse = false;
        }
        
        if ( !array ) {
            return array;
        }
        if ( !comparator_value ) {
            return array.sort();
        }
        var size      = array.length;
        var fix_array = [];
        var to_sort   = array;
        if ( first_index_to_sort ) {
            fix_array = array.slice( 0, first_index_to_sort );
            to_sort   = array.slice( first_index_to_sort, size );
        }
        to_sort.sort( function ( a, b ) {
            if ( a[ comparator_value ] < b[ comparator_value ] ) {
                return reverse ? 1 : -1;
            }
            else if ( a[ comparator_value ] > b[ comparator_value ] ) {
                return reverse ? -1 : 1;
            }
            return 0;
        } );
        return fix_array.concat( to_sort );
    };
    self.sortArrayMultiple          = function ( array, comparator_values ) {
        if ( !array ) {
            return array;
        }
        if ( !comparator_values ) {
            return array;
        }
        var size      = array.length;
        var fix_array = [];
        var to_sort   = array;
        to_sort.sort(
            function ( a, b ) {
                return self._comparator( a, b, comparator_values, 0 );
            }
        );
        return fix_array.concat( to_sort );
    };
    self.getMapValues               = function ( map ) {
        if ( !map ) {
            return null;
        }
        return Object.keys( map ).map( function ( e ) {
            return map[ e ];
        } );
    };
    self._comparator                = function ( a, b, comparators, index ) {
        if ( index >= comparators.length ) {
            return 0;
        }
        if ( a[ comparators[ index ] ] < b[ comparators[ index ] ] ) {
            return -1;
        }
        else if ( a[ comparators[ index ] ] > b[ comparators[ index ] ] ) {
            return 1;
        }
        return self._comparator( a, b, comparators, (index + 1) );
    };
    self.filterWith                 = function ( array, key, value ) {
        if ( !array ) {
            return [];
        }
        if ( !key || !value ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return [];
        }
        var toReturn = [];
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                toReturn.push( _current );
            }
        }
        return toReturn;
    };
    self.filterWithDeeply           = function ( array, keys, value ) {
        if ( !array || !keys || !value ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _to_return = [];
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( self.findValueDeeply( _current, keys ) === value ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    };
    self.findValueDeeply            = function ( dict, keys ) {
        if ( !dict || !keys ) {
            return null;
        }
        var _size = keys.length;
        if ( _size < 1 ) {
            return null;
        }
        var _to_return = dict[ keys[ 0 ] ];
        if ( _size === 1 ) {
            return _to_return;
        }
        return self.findValueDeeply( _to_return, SHINKEN.TOOLS.ARRAY.clone( keys ).splice( -1, 1 ) );
    };
    self.findFirstElementWith       = function ( array, key, value ) {
        if ( !array || !key || typeof value === 'undefined' ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                return _current;
            }
        }
        return null;
    };
    self.findFirstIndexWith         = function ( array, key, value ) {
        if ( !array || !key || typeof value === 'undefined' ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                return i;
            }
        }
        return -1;
    };
    self.getLengthWith              = function ( array, key, value ) {
        var _filtered = self.filterWith( array, key, value );
        if ( !_filtered ) {
            return 0;
        }
        return _filtered.length;
    };
    self.extractKey                 = function ( array, key, ignoreEmpty ) {
        if ( !array || !key ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( !_current && !ignoreEmpty ) {
                toReturn[ i ] = null;
            }
            else {
                if ( _current[ key ] || !ignoreEmpty ) {
                    toReturn[ i ] = _current[ key ];
                }
            }
        }
        return toReturn;
    };
    self.extractKeys                = function ( array, keys ) {
        var _keys_size = keys.length;
        if ( !array || !_keys_size ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( !_current ) {
                toReturn[ i ] = self.initEmptyArray( _keys_size );
            }
            else {
                toReturn[ i ] = [];
                for ( var j = 0; j < _keys_size; j++ ) {
                    toReturn[ i ].push( _current[ keys[ j ] ] );
                }
            }
        }
        return toReturn;
    };
    self.removeDuplicate            = function ( array ) {
        if ( !array ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( toReturn.indexOf( _current ) !== -1 ) {
                continue;
            }
            toReturn.push( _current );
        }
        return toReturn;
    };
    self.removeDuplicateArray       = function ( array ) {
        if ( !array ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        var _to_add;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            _to_add  = true;
            for ( var j = 0, _size_j = toReturn.length; j < _size_j; j++ ) {
                if ( self.areEquals( toReturn[ j ], _current ) ) {
                    _to_add = false;
                }
            }
            if ( _to_add ) {
                toReturn.push( _current );
            }
        }
        return toReturn;
    };
    self.hasSameKeyContent          = function ( array1, array2, key ) {
        if ( !key ) {
            return false;
        }
        if ( !array1 && !array2 ) {
            return true;
        }
        if ( !array1 || !array2 ) {
            return false;
        }
        
        var _extract1 = self.extractKey( array1, key );
        var _extract2 = self.extractKey( array2, key );
        if ( _extract1 === null && _extract2 === null ) {
            return true;
        }
        else if ( _extract1 === null || _extract2 === null ) {
            return false;
        }
        
        var _size1 = _extract1.length;
        var _size2 = _extract2.length;
        
        if ( _size1 !== _size2 ) {
            return false;
        }
        
        for ( var i = 0; i < _extract1; i++ ) {
            if ( _extract1[ i ] !== _extract2[ i ] ) {
                return false;
            }
        }
        return true;
    };
    self.getElementFromTo           = function ( array, indexBegin, indexEnd ) {
        return array.slice( indexBegin, indexEnd );
    };
    self.getElement                 = function ( array, key, value_to_find ) {
        var _size = self.getLength( array );
        var _current_element;
        for ( var i = 0; i < _size; i++ ) {
            _current_element = array[ i ];
            if ( _current_element[ key ] === value_to_find ) {
                return _current_element;
            }
        }
    };
    self.reverseArrayClone          = function ( array ) {
        var toReturn = Array.prototype.slice.call( array );
        toReturn.reverse();
        return toReturn;
    };
    self.initEmptyArray             = function ( length ) {
        var toReturn = [];
        for ( var i = 0; i <= length; i++ ) {
            toReturn.push( null );
        }
        return toReturn;
    };
    self.initConstantArray          = function ( to_add, length ) {
        var toReturn = [];
        for ( var i = 0; i < length; i++ ) {
            toReturn.push( to_add );
        }
        return toReturn;
    };
    self.initIntegerArray           = function ( indexBegin, indexEnd ) {
        var toReturn = [];
        for ( var i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i );
        }
        return toReturn;
    };
    self.initIntegerArrayToString   = function ( indexBegin, indexEnd ) {
        var toReturn = [];
        for ( var i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i + "" );
        }
        return toReturn;
    };
    self.indexOf                    = function ( array, key, value ) {
        var size = array.length;
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ][ key ];
            if ( _current && _current === value ) {
                return i;
            }
        }
        return -1;
    };
    self.indexOfCollection          = function ( array, to_find ) {
        var size = array.length;
        var _current;
        for ( var i = 0; i < size; i++ ) {
            if ( array[ i ] === to_find ) {
                return i;
            }
        }
        return -1;
    };
    self.search                     = function ( array, key, value ) {
        var index = self.indexOf( array, key, value );
        if ( index === -1 ) {
            return null;
        }
        return array[ index ];
    };
    self.join                       = function ( array, separator ) {
        if ( Array.isArray( array ) ) {
            return array.join( separator );
        }
        return array.toString();
    };
    self.getLength                  = function ( array ) {
        if ( array ) {
            return array.length;
        }
        return 0;
    };
    self.clone                      = function ( array ) {
        return array.slice( 0 );
    };
    self.swap                       = function ( array, index_1, index_2 ) {
        if ( !array ) {
            return;
        }
        var b            = array[ index_1 ];
        array[ index_1 ] = array[ index_2 ];
        array[ index_2 ] = b;
        return array;
    };
    self.contains                   = function ( array, toSearch ) {
        if ( !array ) {
            return false;
        }
        return array.indexOf( toSearch ) !== -1;
    };
    self.containsAtLeastOne                   = function ( array1, array2 ) {
        if ( !array1 || !array2 ) {
            return false;
        }
        for ( var i = 0, _size_i = array2.length; i < _size_i; i++ ) {
            if ( self.contains (array1, array2[i] ) ){
                return true;
            }
        }
        return false;
    };
    self.addElement                 = function ( array, toAdd ) {
        if ( self.contains( array, toAdd ) ) {
            return -1;
        }
        return array.push( toAdd );
    };
    self.removeElement              = function ( array, toRemove ) {
        var index = array.indexOf( toRemove );
        if ( index === -1 ) {
            return false;
        }
        array.splice( index, 1 );
        return true;
    };
    self.parseToArray               = function ( obj ) {
        if ( !obj ) {
            return null;
        }
        
        var _keys      = Object.keys( obj );
        var _size      = _keys.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = obj[ _keys[ i ] ];
        }
        return _to_return;
    };
    self.containsElementWith        = function ( array, toSearch, key ) {
        if ( !array ) {
            return false;
        }
        if ( !key ) {
            return false;
        }
        
        var _size = array.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( array[ i ][ key ] === toSearch ) {
                return true;
            }
        }
        return false;
    };
    self.areEquals                  = function ( array1, array2 ) {
        return JSON.stringify( array1 ) === JSON.stringify( array2 );
    };
    self.getMedianIndex             = function ( array, round_up ) {
        if ( !array ) {
            return SHINKEN.TOOLS.ARRAY.NOT_FOUND;
        }
        return round_up ? Math.ceil( array.length / 2 ) : Math.floor( array.length / 2 );
    };
    self.getFirstPartOf             = function ( array ) {
        return array.slice( 0, self.getMedianIndex( array ) + 1 );
    };
    self.getLastPartOf              = function ( array ) {
        return array.slice( self.getMedianIndex( array ), array.length );
    };
    self.minNumber                  = function ( array ) {
        if ( !array ) {
            return null;
        }
        return array.reduce( function ( a, b ) {
            return Math.min( a, b );
        }, array[ 0 ] );
    };
    self.maxNumber                  = function ( array ) {
        if ( !array ) {
            return null;
        }
        return array.reduce( function ( a, b ) {
            return Math.max( a, b );
        }, array[ 0 ] );
    };
    self.medianNumber               = function ( array ) {
        if ( !array ) {
            return null;
        }
        var sorted = array.slice().sort();
        var half   = Math.floor( array.length / 2 );
        
        if ( array.length % 2 ) {
            return sorted[ half ];
        }
        
        return (sorted[ half - 1 ] + sorted[ half ]) / 2.0;
    };
    self.take                       = function ( arr, n ) {
        return arr.filter( function ( _, i ) {
            return i < n;
        } );
    };
    self.takeLast                   = function ( arr, n ) {
        var _len = arr.length;
        return arr.filter( function ( _, i ) {
            return _len - i <= n;
        });
    };
    return self;
})( SHINKEN.TOOLS.ARRAY || {} );

SHINKEN.TOOLS.ARRAY.NOT_FOUND = -1;