//priority 20
//__lib__ lib_common
SHINKEN.COMUNICATION = (function ( self ) {
    "use strict";
    self.requestGet     = function ( url, success, error, not_found_callback, unauthorized_callback ) {
        var request = new XMLHttpRequest();
        
        request.open( 'GET', url, true );
        request.onload  = self.onRequestSuccess( success, not_found_callback, unauthorized_callback );
        request.onerror = error || self.onRequestError;
        request.send();
    };
    self.requestPost    = function ( url, data, success, error, not_found_callback, unauthorized_callback ) {
        var request            = new XMLHttpRequest();
        self._success_callback = success;
        
        request.open( 'POST', url, true );
        request.setRequestHeader( 'Content-Type', 'charset=UTF-8' );
        request.onload  = self.onRequestSuccess( success, not_found_callback, unauthorized_callback );
        request.onerror = error || self.onRequestError;
        request.send( data );
    };
    self.onRequestError = function () {
        SHINKEN.TOOLS.NOTIFICATION.addNotification( "error", SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
    };
    
    self.onRequestSuccess = function ( success, not_found_callback, unauthorized_callback ) {
        return function () {
            var _data = JSON.parse( this.response );
            switch ( _data.rc ) {
                case COMMUNICATION.CODE.UNAUTHORIZED:
                    if ( unauthorized_callback ) {
                        unauthorized_callback( this.status, _data );
                        return;
                    }
                    window.parent.location.reload();
                    return;
                case COMMUNICATION.CODE.NOT_FOUND:
                    if ( not_found_callback ) {
                        not_found_callback( this.status, _data );
                        return;
                    }
                    break;
            }
            success( this.status, _data );
        };
    };
    return self;
})( SHINKEN.COMUNICATION || {} );