%class_disable = ''
%if mod.properties['type'] == 'discovery-import' and not mod.try_database_connection():
    %class_disable = 'shinken-disabled'
%end
<html>
<head>
    <style type="text/css">
        @font-face {
            font-family : "shinkon";
            src         : url("/static/{{app.http_start_time}}/font/shinkenicons.woff") format("woff"),
            url("/static/{{app.http_start_time}}/font/shinkenicons.ttf") format("truetype"),
            url("/static/{{app.http_start_time}}/font/shinkon.svg#shinkon") format("svg");
            font-weight : normal;
            font-style  : normal;
        }
        @font-face {
            font-family : "shinicon";
            src         : url("/static/{{app.http_start_time}}/font/shinicon.woff") format("woff"),
            url("/static/{{app.http_start_time}}/font/shinicon.ttf") format("truetype"),
            url("/static/{{app.http_start_time}}/font/shinicon.svg#shinkon") format("svg");
            font-weight : normal;
            font-style  : normal;
        }
        @font-face {
            font-family : 'FontAwesome';
            src         : url('/static/{{app.http_start_time}}/font/fontawesome-webfont.eot?v=3.0.1');
            src         : url('/static/{{app.http_start_time}}/font/fontawesome-webfont.eot?#iefix&v=3.0.1') format('embedded-opentype'),
            url('/static/{{app.http_start_time}}/font/fontawesome-webfont.woff?v=3.0.1') format('woff'),
            url('/static/{{app.http_start_time}}/font/fontawesome-webfont.ttf?v=3.0.1') format('truetype');
            font-weight : normal;
            font-style  : normal;
        }
        @font-face {
            font-family : "Lato-Light";
            src         : url("/static/{{app.http_start_time}}/ui/assets/styles/fonts/lato-light.woff") format("woff"),
            url("/static/{{app.http_start_time}}/ui/assets/styles/fonts/lato-light.ttf") format("truetype");
            font-weight : normal;
            font-style  : normal;
        }
        @font-face {
            font-family : "Lato";
            src         : url("/static/{{app.http_start_time}}/font/lato-regular.ttf") format("truetype");
            font-weight : normal;
            font-style  : normal;
        }
        @font-face {
            font-family : "shinkenicons";
            src         : url("/static/{{app.http_start_time}}/font/shinkenicons.woff") format("woff"),
            url("/static/{{app.http_start_time}}/font/shinkenicons.ttf") format("truetype");
            font-weight : normal;
            font-style  : normal;
        }
    </style>

    <link rel="stylesheet" href="/static/{{app.http_start_time}}/discovery-import/css/vendor/bootstrap.min.css"/>
    <link rel="stylesheet" href="/static/{{app.http_start_time}}/sources/css/sources.css"/>
    <link rel="stylesheet" href="/static/{{app.http_start_time}}/discovery-import/css/shinken_lib/shinken_lib.css"/>
    <link rel="stylesheet" href="/static/{{app.http_start_time}}/discovery-import/css/rules_list.css"/>

    <script>
        var __shinken_lang__  = '{{mod.global_lang}}';
        var rulesWarningsNumber = parseInt('{{mod.tabs[0]['warnings']}}');
        var rulesErrorsNumber = parseInt('{{mod.tabs[0]['errors']}}');
        var toto ="greg is dead"
    </script>
    <script type="text/javascript" src="/static/{{app.http_start_time}}/discovery-import/js/traductions/en.js"></script>
    <script type="text/javascript" src="/static/{{app.http_start_time}}/discovery-import/js/traductions/fr.js"></script>
    <script type="text/javascript" src="/static/{{app.http_start_time}}/discovery-import/js/shinken_lib/jquery.js"></script>
    <script type="text/javascript" src="/static/{{app.http_start_time}}/discovery-import/js/js_specific/rules-list-controller.js"></script>

</head>
<body id="page-Sources" class="shinken-discovery-tab-container {{class_disable}}">
<div class="shinken-ajax-container" data-status="{{status}}">
    <div id="id-shinken-content-error">
        %if status > 0:
            <div class="shinken-alert">
                {{mod._(status_trad) % rules_path}}
            </div>
        %end
    </div>
    <div id="id-shinken-content-header" class="table-head-js scroll-head content responsive">
        <table class="table" role="grid">
            <thead>
            <tr class="shinken-header-row" role="row">
                <th class="shinken-col-status">{{mod._('source.status')}}</th>
                <th class="shinken-col-rule">{{mod._('source.rule_number')}}</th>
                <th class="shinken-col-name">{{mod._('source.name')}}</th>
                <th class="shinken-col-conditions">{{mod._('source.conditions')}}</th>
                <th class="shinken-col-use">{{mod._('source.use')}}</th>
                <th class="shinken-col-prefix">
                    <table class="shinken-table-header">
                        <tbody class="shinken-table-body-header">
                        <tr class="shinken-cell-header">
                            <td class="shinken-label-cell">
                                {{mod._('source.prefix')}}
                            </td>
                            <td class="shinken-icon-cell">
                                <div class="icon-undo refresh-button"
                                     title="{{mod._('rules.reload_rules')}}"
                                     onclick="DISCOVERY_CONTROLLER.clickOnForceReloadRules('{{sname}}')">
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </th>
            </tr>
            </thead>
        </table>
        <div class="shinken-loading-after-refresh">
            <div class="shinken-loading-after-refresh-container">
                <h1>{{!mod._('source.refresh_rules')}}</h1>
            </div>
        </div>
    </div>
    <div id="id-shinken-content" class="table-body-js scroll-body content responsive">
        <table class="table" role="grid">
            <tbody class="bordered">
            <div class="shinken-text-disabled">{{mod._('source.database_unavailable')}}</div>
            %if not class_disable and len(display_rules) == 0:
                <div class="shinken-col-sm-12">
                    <h1>{{mod._('source.no_objects')}}</h1>
                </div>
            %else:
            %elt_number = 0
            %for rule in display_rules:
            %elt_number = elt_number+1
            %include( "rules_list_line", rule=rule, elt_number=elt_number, app=app)
            %end

            %end
            </tbody>
        </table>
    </div>
</div>
</body>
</html>