#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019
# This file is part of Shinken Enterprise, all rights reserved.


import json

from shinken.basemodule import BaseModule, SOURCE_STATE

properties = {
    'daemons': ['synchronizer'],
    'type'   : 'json-import',
}


def build_source_return(state, output, error='', items=None):
    return {
        'state'   : state,
        'output'  : output,
        'objects' : items if items else {},
        'errors'  : [error] if error else [],
        'warnings': []
    }


# called by the plugin manager to get a module
def get_instance(source_configuration):
    # Catch errors
    path = getattr(source_configuration, 'path', None)
    return JsonImport(source_configuration, path)


# Just print some stuff
class JsonImport(BaseModule):
    def __init__(self, mod_conf, path):
        BaseModule.__init__(self, mod_conf)
        self.path = path
        self.logger.info('[JSON Import] Get a JSON import module ')
    
    
    def init(self):
        self.logger.info('[JSON Import] Initialization')
    
    
    def get_objects(self):
        if not self.path:
            return build_source_return(SOURCE_STATE.NOT_CONFIGURED, 'Please specify a path in the source configuration')
        try:
            with open(self.path, 'rb') as _file:
                items = json.load(_file)
        except Exception as exp:
            return build_source_return(SOURCE_STATE.CRITICAL, 'File %s cannot be load' % self.path, error=str(exp))
        return build_source_return(SOURCE_STATE.OK, 'File %s was load successfully' % self.path, items=items)