#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2009-2022:
# Gabes Jean, naparuba@gmail.com
# Gerhard Lausser, Gerhard.Lausser@consol.de
# Gregory Starck, g.starck@gmail.com
# Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken. If not, see <http://www.gnu.org/licenses/>.


from shinken.misc.type_hint import TYPE_CHECKING
from shinken.modules.base_module.basemodule import BaseModule
from shinkensolutions.ssh_mongodb.mongo_client import MongoClient
from shinkensolutions.ssh_mongodb.mongo_conf import MongoConf
from shinkensolutions.ssh_mongodb.sshtunnelmongomgr import mongo_by_ssh_mgr

if TYPE_CHECKING:
    from shinken.objects.module import Module as ShinkenModuleDefinition

properties = {
    u'daemons' : [u'arbiter', u'webui', u'synchronizer-ui'],
    u'type'    : u'mongodb',
    u'external': False,
    u'phases'  : [u'configuration'],
}


# called by the plugin manager to get a module instance
def get_instance(module_configuration):
    instance = MongodbConnector(module_configuration)
    return instance


class MongodbConnector(BaseModule):
    
    def __init__(self, module_configuration):
        # type: (ShinkenModuleDefinition) -> None
        
        BaseModule.__init__(self, module_configuration)
        
        self.mongo_conf = MongoConf(module_configuration, logger=self.logger, prefix_module_property=self.get_module_type())
        self.mongo_client = MongoClient(self.mongo_conf, logger=self.logger)
    
    
    def init(self):
        self.mongo_client.init(self.get_name())
    
    
    def get_state(self):
        stats = super(MongodbConnector, self).get_state()
        stats[u'mongodb_stats'] = mongo_by_ssh_mgr.check_connexion_mongodb(self.mongo_conf.uri)
        return stats
    
    
    def loop_turn(self):
        pass
    
    
    def do_loop_turn(self):
        pass
