# !/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import TYPE_CHECKING
from .component_manager import ComponentManager
from .configuration_component import ConfigurationComponent
from .logger_component import LoggerComponent
from .mongo_component import MongoComponent

if TYPE_CHECKING:
    from shinken.log import PartLogger
    from shinken.objects import Module as ShinkenModuleDefinition
    from shinkensolutions.ssh_mongodb.mongo_conf import MongoConf


class ComponentFactory(object):
    
    @staticmethod
    def build(conf, mongo_conf, logger):
        # type: (ShinkenModuleDefinition, MongoConf, PartLogger) -> None
        component_manager = ComponentManager.get_instance()  # type: ComponentManager
        
        logger_component = LoggerComponent(logger)
        configuration_component = ConfigurationComponent(conf, mongo_conf, logger_component)
        mongo_component = MongoComponent(logger_component.get_logger(), configuration_component, 'synchronizer_module_database_backup')
        
        component_manager._all_components = []
        component_manager.set_component('configuration_component', configuration_component)
        component_manager.set_component('mongo_component', mongo_component)
        component_manager.init()
