#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.


from shinken.misc.type_hint import TYPE_CHECKING

try:
    from shinken.synchronizer.component.abstract_component import AbstractComponent
except ImportError:
    from synchronizer.component.abstract_component import AbstractComponent

if TYPE_CHECKING:
    from shinken.log import PartLogger


class LoggerComponent(AbstractComponent):
    
    def __init__(self, logger):
        # type: (PartLogger) -> None
        self.logger = logger
    
    
    def init(self):
        pass
    
    
    def get_logger(self):
        # type: () -> PartLogger
        return self.logger
