#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2014-2022:
#    Gabes Jean, j.gabes@shinken-solutions.com
#
# This file is part of Shinken enterprise, all rights reserved

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Optional
    from webui.module import WebuiBroker

app = None  # type: Optional[WebuiBroker]

default_options = [{'name': 'src', 'value': 'http://www.shinken-solutions.com', 'type': 'url', 'label': 'Page to load'}]


def get_iframe_widget():
    # First we look for the user sid
    # so we bail out if it's a false one
    user = app.get_user_auth()
    
    if not user:
        return {'app': app, 'elt': None, 'valid_user': False}
    
    return {'app': app, 'user': user}


widget_display_name = 'Web Page'
widget_desc = '''Show an external page'''

pages = {
    get_iframe_widget: {
        'routes'             : ['/widget/iframe'],
        'view'               : None,
        'static'             : True,
        'widget'             : ['dashboard'],
        'widget_display_name': widget_display_name,
        'widget_desc'        : widget_desc,
        'widget_name'        : 'iframe',
        'widget_picture'     : '/static/iframe/img/widget_iframe.png',
        'widget_size'        : {'width': 12, 'height': 6},
        'widget_options'     : default_options,
        'widget_favoritable' : False,
        'resizable'          : False,
        'wrappers'           : []},
}
