Graphics.ChartJSContainer = function ( dom_element, data ) {
    this.init( dom_element, data );
};

Graphics.ChartJSContainer.prototype = {
    //********************************************  INIT  **************************************************//
    init: function ( dom_element, data ) {
        if ( data.data.labels.length < 2 ) {
            dom_element.classList.add( 'shinken-not-enough-data' );
            return;
        }
        this.chart = new Chart(
            dom_element.querySelector( 'canvas' ).getContext( '2d' ),
            data
        );
    },
    //********************************************  GETTER SETTER   *****************************************//
    //********************************************  FUNCTIONS   *********************************************//
    update    : function () {
        if ( this.chart !== undefined ) {
            this.chart.update();
        }
    },
    updateData: function ( data ) {
        // reset if need
        this.chart.data    = data.data;
        this.chart.options = data.options;
        this.chart.update( data );
    }
    //********************************************  PRIVATE   ***********************************************//
};
