var Graphics = {};

var COLOR_OK       = '#43A047';
var COLOR_SLA_LINE = '#454545';
var LINE_SIZE      = 1;

var NB_LABEL_MAX_DISPLAY_GRAPH = 10000;
var NB_DATA_MAX_GRAPH          = 31;
var CANVAS_MARGIN_TOP          = 20;
var LEGEND_CANVAS_MARGIN_LEFT  = 70;
var LEGEND_CANVAS_MARGIN_TOP   = 30;

var ADDON_VALUE = " %";

var ZOOM_Y_DIVIDER = 50;
var COLOR_DIVIDER  = "rgba(0, 0, 0, 0.03)";

// ---

var CHART_JS   = {};
CHART_JS.CONST = {
    SCALE_Y_TYPE: {
        LINEAR     : "linear",
        LOGARITHMIC: "logarithmic"
    }
};

Graphics.CONST = {
    ROUND_VALUE: {
        IN_GRAPH     : 2,
        IN_GRAPH_BASE: 100,
        TOOLTIP      : 3,
        TOOLTIP_BASE : 1000
    },
    CANVAS     : {
        OFFSET   : {
            VALUE_X: 20,
            VALUE_Y: 10
        },
        DRAW_BASE: {
            fontSize           : 10,
            fontName           : 'Lato',
            fontType           : '',
            marginRect         : 1,
            backgroundRect     : true,
            backgroundRectColor: '#FFFFFF'
        }
    },
    TOOLTIP    : {
        VERTICAL_LINE: {
            lineWidth  : 0.3,
            strokeStyle: '#000000'
        },
        LABEL        : {
            textColor    : '#444444',
            textSeparator: ' -'
        }
    },
    LEGEND     : {
        META_TYPE     : {
            LINE_DIVIDER      : 'zoom_divider',
            LEGEND_UP         : 'up_label',
            LEGEND_DOWN       : 'down_label',
            CRITICAL_THRESHOLD: 'critical_threshold',
            WARNING_THRESHOLD : 'warning_threshold'
        },
        DEFAULT_CONFIG: {
            _meta_type: '',
            label     : '',
            offsetY   : 0,
            offsetX   : 0,
            color     : '#000000'
        }
    },
    SLA        : {
        CURVE: {
            MAIN              : {
                OPTIONS: {
                    color                 : "green",
                    point_radius          : 3,
                    point_background_color: COLOR_OK,
                    nb_data_max           : NB_DATA_MAX_GRAPH
                }
            },
            THRESHOLD_WARNING : {
                TYPE   : 'threshold_warning',
                OPTIONS: {
                    color: "#FB8C00"
                }
            },
            THRESHOLD_CRITICAL: {
                TYPE   : 'threshold_critical',
                OPTIONS: {
                    color: "#D50000"
                }
            }
        }
    }
};