//priority 17
'use strict';

Graphics.Curve = {};

Graphics.Curve.Interface = function () {
    this.__class_name__ = 'Graphics.Curve.Interface';
};

Graphics.Curve.Interface.prototype = {
    initCommon : function ( data, options ) {
        this.setData( data );
        this.initOptions( options );
    },
    initOptions: function ( options ) {
        this.options = SHINKEN.TOOLS.DICT.assigns( {}, [
            Graphics.CONST.SLA.CURVE.MAIN.OPTIONS,
            options || {}
        ] );
    },
    //********************************************  GETTER SETTER   ********************************************//
    setData               : function ( data ) {
        this._original_data = data;
    },
    setNbDataMax          : function ( nb_data_max ) {
        this.options.nb_data_max = nb_data_max;
    },
    getOriginalData       : function ( index ) {
        var offset = 0;
        if ( this._original_data.length > this.options.nb_data_max ) {
            offset = this._original_data.length - this.options.nb_data_max;
        }
        return this._original_data[ index + offset ];
    },
    getOriginalDatas      : function () {
        return SHINKEN.TOOLS.ARRAY.takeLast( this._original_data, this.options.nb_data_max );
    },
    getTooltipLabel       : function ( index ) {
        var offset = 0;
        if ( this._original_data.length > this.options.nb_data_max ) {
            offset = this._original_data.length - this.options.nb_data_max;
        }
        return " " + Math.round( this._original_data[ index + offset ] * Graphics.CONST.ROUND_VALUE.TOOLTIP_BASE ) / Graphics.CONST.ROUND_VALUE.TOOLTIP_BASE + '%';
    },
    getColor              : function ( index ) {
        return this.options.color;
    },
    getColorTooltip       : function ( index ) {
        return this.getColor();
    },
    getPointsRadius       : function () {
        return SHINKEN.TOOLS.ARRAY.initConstantArray(
            this.options.point_radius,
            this.getSizeLine()
        );
    },
    getSizeLine           : function () {
        return Math.min( this._original_data.length, this.options.nb_data_max );
    },
    getPointBackground    : function () {
        return this.options.point_background_color;
    },
    getPointsBackground   : function () {
        return SHINKEN.TOOLS.ARRAY.initConstantArray( this.getPointBackground(), this.getSizeLine() );
    },
    computeFinal          : function ( graphic_object ) {
        this.computeTransformedData( graphic_object );
    },
    computeTransformedData: function ( graphic_object ) {
        this.transformedData = [];
        for ( var i = 0, _size_i = this._original_data.length; i < _size_i; i++ ) {
            this.transformedData.push( graphic_object.getTransformedValue( this._original_data[ i ] ) );
        }
    },
    //********************************************  SPECIFIC CHART JS  ********************************************//
    _takeLastMaxData  : function ( arr ) {
        return SHINKEN.TOOLS.ARRAY.takeLast( arr, this.options.nb_data_max );
    },
    chartJs_parseCurve: function () {
        var _to_return                       = {};
        _to_return[ 'data' ]                 = this.chartJs_getData();
        _to_return[ 'fill' ]                 = this.chartJs_getFill();
        _to_return[ 'label' ]                = '';
        _to_return[ 'backgroundColor' ]      = this.getColor();
        _to_return[ 'borderColor' ]          = this.getColor();
        _to_return[ 'pointRadius' ]          = this.getPointsRadius();
        _to_return[ 'pointHoverRadius' ]     = _to_return[ 'pointRadius' ];
        _to_return[ 'pointBackgroundColor' ] = this.getPointsBackground();
        _to_return[ 'pointBorderColor' ]     = _to_return[ 'pointBackgroundColor' ];
        return _to_return;
    },
    chartJs_getData   : function () {
        // console.log( "CEPA", "[Interface - chartJs_getData]", this.transformedData );
        return this._takeLastMaxData( this.transformedData );
    },
    chartJs_getFill   : function () {
        return false;
    }
};
