'use strict';


Graphics.Curve.Sla           = function ( data, options ) {
    this.__class_name__ = 'Graphics.Curve.Sla';
    this.init( data, options );
    this.initSpecific();
    this.type = 'linear';
};
Graphics.Curve.Sla.prototype = {
    init                  : function ( data, options ) {
        this.initCommon( data, options );
    },
    initSpecific          : function ( data, options ) {
        this.specific_sla_background_color = SHINKEN.TOOLS.ARRAY.initConstantArray(
            this.options.point_background_color,
            this.getSizeLine()
        );
    },
    computeFinal          : function ( graphic_object ) {
        this.computeTransformedData( graphic_object );
        this.computeBackgroundPoint( graphic_object );
    },
    computeBackgroundPoint: function ( graphic_object ) {
        var _threshold_warning  = graphic_object.getThresholdCurve( Graphics.CONST.SLA.CURVE.THRESHOLD_WARNING.TYPE );
        var _threshold_critical = graphic_object.getThresholdCurve( Graphics.CONST.SLA.CURVE.THRESHOLD_CRITICAL.TYPE );
        for ( var i = 0, _size_i = this.getSizeLine(); i < _size_i; i++ ) {
            if ( !_threshold_critical && !_threshold_warning ) {
                this.specific_sla_background_color[ i ] = this.getColor();
            }
            else if ( _threshold_critical && this.getOriginalData( i ) <= _threshold_critical.getOriginalData( i ) ) {
                this.specific_sla_background_color[ i ] = _threshold_critical.getColor();
            }
            else if ( _threshold_warning && this.getOriginalData( i ) <= _threshold_warning.getOriginalData( i ) ) {
                this.specific_sla_background_color[ i ] = _threshold_warning.getColor();
            }
            else {
                this.specific_sla_background_color[ i ] = this.getPointBackground();
            }
        }
    },
    getPointsBackground   : function () {
        return this.specific_sla_background_color;
    }
    //********************************************  SPECIFIC CHART JS  ********************************************//
};
SHINKEN.TOOLS.CLASS.addPrototype( Graphics.Curve.Sla, Graphics.Curve.Generic );
