'use strict';


Graphics.Graphic.ZoomedWithCustomLegend           = function ( data ) {
    this.__class_name__ = 'Graphics.Graphic.Interface';
    this.init();
};
Graphics.Graphic.ZoomedWithCustomLegend.prototype = {
    init: function () {
        this.percent_scale_height = ZOOM_Y_DIVIDER;
        this.initCommon();
    },
    //********************************************  TRANSFORMATION   *****************************************//
    getTransformedValue: function ( value ) {
        if ( value === null || value === undefined ) {
            return value;
        }
        if ( value < this.y_min ) {
            return value * this.percent_scale_height / this.y_min;
        }
        return this.percent_scale_height + (value - this.y_min) * ((100 - this.percent_scale_height) / (this.y_max - this.y_min));
    },
    getDrawYMin        : function () {
        return 0;
    },
    getDrawYMax        : function () {
        return this.y_max;
    },
    //********************************************  GET TRANSFORMED    ********************************************//
    getDrawYMinTransformed: function () {
        return 0;
    },
    getDrawYMaxTransformed: function () {
        return 100;
    },
    //********************************************  LEGEND           *****************************************//
    chartJs_getDatasetsToAddForLegend: function () {
        var divier            = {
            _meta_type      : Graphics.CONST.LEGEND.META_TYPE.LINE_DIVIDER,
            label           : "",
            fill            : true,
            backgroundColor : COLOR_DIVIDER,
            borderColor     : COLOR_DIVIDER,
            data            : SHINKEN.TOOLS.ARRAY.initConstantArray( this.percent_scale_height, this.legends.x.length ),
            borderWidth     : 0,
            pointRadius     : 0,
            pointHoverRadius: 0
        };
        var upLegend          = {
            _meta_type      : Graphics.CONST.LEGEND.META_TYPE.LEGEND_UP,
            label           : "",
            backgroundColor : "rgb(0, 0, 0, 0)",
            borderColor     : "rgb(0, 0, 0, 0)",
            data            : [this.getDrawYMaxTransformed()],
            borderWidth     : 0,
            pointRadius     : 0,
            pointHoverRadius: 0
        };
        var downLegend        = {
            _meta_type      : Graphics.CONST.LEGEND.META_TYPE.LEGEND_DOWN,
            label           : "",
            backgroundColor : "rgb(0, 0, 0, 0)",
            borderColor     : "rgb(0, 0, 0, 0)",
            data            : [this.getDrawYMinTransformed()],
            borderWidth     : 0,
            pointRadius     : 0,
            pointHoverRadius: 0
        };
        var criticalThreshold = {
            _meta_type      : Graphics.CONST.LEGEND.META_TYPE.CRITICAL_THRESHOLD,
            backgroundColor : "rgb(0, 0, 0, 0)",
            borderColor     : "rgb(0, 0, 0, 0)",
            data            : [this.getDrawThresholdTransformed( Graphics.CONST.SLA.CURVE.THRESHOLD_CRITICAL.TYPE )],
            borderWidth     : 0,
            pointRadius     : 0,
            pointHoverRadius: 0
        };
        var warningThreshold  = {
            _meta_type      : Graphics.CONST.LEGEND.META_TYPE.WARNING_THRESHOLD,
            backgroundColor : "rgb(0, 0, 0, 0)",
            borderColor     : "rgb(0, 0, 0, 0)",
            data            : [this.getDrawThresholdTransformed( Graphics.CONST.SLA.CURVE.THRESHOLD_WARNING.TYPE )],
            borderWidth     : 0,
            pointRadius     : 0,
            pointHoverRadius: 0
        };
        return [divier, upLegend, downLegend, criticalThreshold, warningThreshold];
    },
    chartJs_getLegendLabelsToDraw    : function () {
        var _to_return = [
            {
                _meta_type: Graphics.CONST.LEGEND.META_TYPE.LEGEND_DOWN,
                label     : this.chartJs_legendValueLabel( this.getDrawYMin() )
            },
            {
                _meta_type: Graphics.CONST.LEGEND.META_TYPE.LEGEND_UP,
                label     : this.chartJs_legendValueLabel( this.getDrawYMax() )
            },
            {
                _meta_type: Graphics.CONST.LEGEND.META_TYPE.LEGEND_UP,
                label     : "%",
                offsetY   : -20
            },
            {
                _meta_type: Graphics.CONST.LEGEND.META_TYPE.LINE_DIVIDER,
                label     : this.chartJs_legendValueLabel( this.y_min )
            }
        ];
        if ( this.yIsInGraph( this.getThresholdFirstValue( Graphics.CONST.SLA.CURVE.THRESHOLD_CRITICAL.TYPE ) ) ) {
            _to_return.push( {
                _meta_type: Graphics.CONST.LEGEND.META_TYPE.CRITICAL_THRESHOLD,
                label     : this.chartJs_legendValueLabel( this.getThresholdFirstValue( Graphics.CONST.SLA.CURVE.THRESHOLD_CRITICAL.TYPE ) ),
                color     : this.getThresholdCurve( Graphics.CONST.SLA.CURVE.THRESHOLD_CRITICAL.TYPE ).getColor()
            } );
        }
        if ( this.yIsInGraph( this.getThresholdFirstValue( Graphics.CONST.SLA.CURVE.THRESHOLD_WARNING.TYPE ) ) ) {
            _to_return.push( {
                _meta_type: Graphics.CONST.LEGEND.META_TYPE.WARNING_THRESHOLD,
                label     : this.chartJs_legendValueLabel( this.getThresholdFirstValue( Graphics.CONST.SLA.CURVE.THRESHOLD_WARNING.TYPE ) ),
                color     : this.getThresholdCurve( Graphics.CONST.SLA.CURVE.THRESHOLD_WARNING.TYPE ).getColor()
            } );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( Graphics.Graphic.ZoomedWithCustomLegend, Graphics.Graphic.WithCustomLegend );
