<table class="shinken-report-total-historic-table">
    <tr>
        <th class="shinken-table-header" colspan="{{len(ALL_STATES)}}">{{app._('reporting.total_history_title')}}</th>
    </tr>
    <tr>
        %for state in ALL_STATES:
            %icon = app.helper.get_sla_state_icon(state)
            %tooltip = 'data-toggle="tooltip" title="%s"' % app._('reporting.%s' % state)
            %state_text = app._('reporting.%s' % state)
            <td class="shinken-report-state-icon-cell col-{{state}}" {{tooltip}}>
                {{!icon}}
            </td>
        %end
    </tr>
    <tr class="shinken-hide-if-under-600">
        %for state in ALL_STATES:
            %icon = app.helper.get_sla_state_icon(state)
            %tooltip = 'data-toggle="tooltip" title="%s"' % app._('reporting.%s' % state)
            %state_text = app._('reporting.%s' % state)
            <td class="shinken-report-state-name-cell col-{{state}}" {{tooltip}}>
                <span class="shinken-report-state-name">{{!state_text}}</span>
            </td>
        %end
    </tr>
    <tr>
        %if item_result['history']:
            %for state in ALL_STATES:
                %if state in item_result['history']:
                    %_value = item_result['history'][state]
                    <td class="shinken-report-historic-value-cell">
                        <div class="shinken-report-historic-value shinken-col-{{state}}">{{total_table_sla_history_value_percent(_value)}}</div>
                    </td>
                %else:
                    <td></td>
                %end
            %end
        %else:
            <td colspan="6">
                %no_data_img = '/static/%s/sla/img/no-data.png' % app.http_start_time
                {{app._('reporting.in_past')}}&nbsp;<img src={{no_data_img}} width="30px"/>
            </td>
        %end
    </tr>
</table>