%helper = app.helper
%datamgr = app.datamgr
%import time, datetime
%title = app._('reporting.form_title')
%include mainmenu globals()
%from ..sla import GRAPHIC_SCALE
%from ..sla import GRAPHIC_Y_MAX_OPTION
%from ..sla import GRAPHIC_Y_MIN_OPTION
%from ..sla import DATA_TYPES
%from ..sla import MODE_SLA

%default_warning_threshold = '%.3f' % DEFAULT_SLA_THRESHOLDS[0]
%default_critical_threshold = '%.3f' % DEFAULT_SLA_THRESHOLDS[1]

<link href="/static/{{app.http_start_time}}/sla/css/reporting-form.css" rel="stylesheet" xmlns="http://www.w3.org/1999/html">
<div class='offset2 shinken-offset2'>

    %type_cluster = "value='%s' " % FILTER_TYPE.NORMAL_CLUSTER
    %type_hosttags = "value='%s' " % FILTER_TYPE.NORMAL_HOST_TEMPLATE
    %type_host = "value='%s' " % FILTER_TYPE.NORMAL_HOST
    %type_service_description = "value='%s' " % FILTER_TYPE.NORMAL_CHECK
    %type_hostgroups = "value='%s' " % FILTER_TYPE.NORMAL_HOSTGROUP

    %type_string = previous_search.get('type')
    %if type_string == FILTER_TYPE.NORMAL_CLUSTER:
        %type_cluster = type_cluster + "selected "
    %elif type_string == FILTER_TYPE.NORMAL_HOST_TEMPLATE:
        %type_hosttags = type_hosttags + "selected "
    %elif type_string == FILTER_TYPE.NORMAL_HOST:
        %type_host = type_host + "selected "
    %elif type_string == FILTER_TYPE.NORMAL_CHECK:
        %type_service_description = type_service_description + "selected "
    %elif type_string == FILTER_TYPE.NORMAL_HOSTGROUP:
        %type_hostgroups = type_hostgroups + "selected "
    %end

    %content_filter = previous_search.get('filter')
    %if content_filter is None:
        %content_filter = ""
    %end

    %content_dateBegin = previous_search.get('dateBegin')
    %if content_dateBegin is None:
        %content_dateBegin = ""
    %end

    %content_dateEnd = previous_search.get('dateEnd')
    %if content_dateEnd is None:
        %content_dateEnd = ""
    %end

    %content_warning_threshold = previous_search.get('warning_threshold')
    %if content_warning_threshold is None:
        %content_warning_threshold = ""
    %end

    %content_critical_threshold = previous_search.get('critical_threshold')
    %if content_critical_threshold is None:
        %content_critical_threshold = ""
    %end

    %content_display_report_threshold = previous_search.get('display_report_threshold', 'on')
    %content_display_report_threshold = 'checked' if content_display_report_threshold == 'on' else ''

    %content_display_daily_details = previous_search.get('shinken_add_daily_details', 'off')
    %content_display_daily_details = 'checked' if content_display_daily_details == 'on' else ''

    %content_display_total_sla = previous_search.get('shinken_display_total_sla', 'on')
    %content_display_total_sla = 'checked' if content_display_total_sla == 'on' else ''

    %content_display_total_historic = previous_search.get('shinken_display_total_historic', 'on')
    %content_display_total_historic = 'checked' if content_display_total_historic == 'on' or user.acl_in_tab_history == 'history' else ''

    %content_daily_sla_graph = previous_search.get('shinken_daily_sla_graph', 'on')
    %form_content_daily_sla_graph = 'true' if content_daily_sla_graph == 'on' else 'false'
    %content_daily_sla_graph = 'checked' if content_daily_sla_graph == 'on' else ''

    %content_display_element_threshold = previous_search.get('display_element_threshold', 'on')
    %content_display_element_threshold = 'checked' if content_display_element_threshold == 'on' else ''


    %select_ack_on = ""
    %select_ack_off = ""
    %select_ack_both = ""
    %content_ack = previous_search.get('ack')
    %if content_ack == "on":
        %select_ack_on = "checked"
    %elif content_ack == "off":
        %select_ack_off = "checked"
    %else:
        %select_ack_both = "checked"
    %end

    %select_downtime_on = ""
    %select_downtime_off = ""
    %select_downtime_both = ""
    %content_downtime = previous_search.get('downtime')
    %if content_downtime == "on":
        %select_downtime_on = "checked"
    %elif content_downtime == "off":
        %select_downtime_off = "checked"
    %else:
        %select_downtime_both = "checked"
    %end

    %data_types = DATA_TYPES
    %old_data_type = previous_search.get('data_type', MODE_SLA)

    %scale_auto = "value='%s' " % GRAPHIC_SCALE.AUTO
    %scale_linear = "value='%s' " % GRAPHIC_SCALE.LINEARE
    %scale_zoom = "value='%s' " % GRAPHIC_SCALE.ZOOM_TOP
    %scale_logarithmic = "value='%s' " % GRAPHIC_SCALE.LOGARITHMIC

    %shinken_graph_scale = previous_search.get('shinken_graph_scale', GRAPHIC_SCALE.AUTO)


    %ymax_auto = "value='%s' " % GRAPHIC_Y_MAX_OPTION.AUTO
    %ymax_valeur = "value='%s' " % GRAPHIC_Y_MAX_OPTION.VALEUR
    %ymax_maximum_sla = "value='%s' " % GRAPHIC_Y_MAX_OPTION.MAXIMUM_SLA
    %ymax_seuil_critic = "value='%s' " % GRAPHIC_Y_MAX_OPTION.SEUIL_CRITIC
    %ymax_seuil_warning = "value='%s' " % GRAPHIC_Y_MAX_OPTION.SEUIL_WARNING

    %shinken_graph_ymax = previous_search.get('shinken_graph_ymax', GRAPHIC_Y_MAX_OPTION.AUTO)


    %ymin_auto = "value='%s' " % GRAPHIC_Y_MIN_OPTION.AUTO
    %ymin_valeur = "value='%s' " % GRAPHIC_Y_MIN_OPTION.VALEUR
    %ymin_minimum_sla = "value='%s' " % GRAPHIC_Y_MIN_OPTION.MINIMUM_SLA
    %ymin_seuil_critic = "value='%s' " % GRAPHIC_Y_MIN_OPTION.SEUIL_CRITIC
    %ymin_seuil_critic_center = "value='%s' " % GRAPHIC_Y_MIN_OPTION.SEUIL_CRITIC_CENTER
    %ymin_seuil_warning = "value='%s' " % GRAPHIC_Y_MIN_OPTION.SEUIL_WARNING
    %ymin_seuil_warning_center = "value='%s' " % GRAPHIC_Y_MIN_OPTION.SEUIL_WARNING_CENTER

    %shinken_graph_ymin = previous_search.get('shinken_graph_ymin', GRAPHIC_Y_MAX_OPTION.AUTO)


    %shinken_graph_ymin_value = previous_search.get('shinken_graph_ymin_value', 0)
    %shinken_graph_ymax_value = previous_search.get('shinken_graph_ymax_value', 100)

    %if err:
        <div class='alert alert-critical' style='color:white;'>
            {{err}}
        </div>
    %end

    <h3 class='well'>{{app._('reporting.form_header')}}</h3>
    <form class='form-horizontal shinken-parent-event-listener shinken-form'
          action='/generate-reporting'
          method='GET'
          data-controller="ReportForm"
          data-shinken_daily_sla_graph={{form_content_daily_sla_graph}}
          data-shinken_graph_scale={{shinken_graph_scale}}
          data-shinken_graph_ymax={{shinken_graph_ymax}}
          data-shinken_graph_ymin={{shinken_graph_ymin}}
          data-shinken-user-acl_in_tab_history={{user.acl_in_tab_history}}
    >
        <div class='well'>
            <div class="shinken-part-title">{{app._('reporting.element_type_label')}}</div>

            <div class="control-group">
                <label class="control-label">{{app._('reporting.filtre_by')}}</label>
                <div class="controls">
                    <select name='type'>
                        <option {{type_host}}>{{app._('reporting.normal_host_')}}</option>
                        <option {{type_cluster}}>{{app._('reporting.normal_cluster_')}}</option>
                        <option {{type_hosttags}}>{{app._('reporting.normal_host_template_')}}</option>
                        <option {{type_service_description}}>{{app._('reporting.normal_check_')}}</option>
                        <option {{type_hostgroups}}>{{app._('reporting.normal_hostgroup_')}}</option>
                    </select>
                </div>
            </div>

            <div class="control-group">
                <label class="control-label">{{app._('reporting.filtre_value')}}</label>
                <div class="controls">
                    <input type="text" required value="{{content_filter}}" name="filter">
                </div>
            </div>

            <br/>

            <div class="shinken-part-title">{{app._('reporting.select_period')}}</div>
            <div class="control-group">
                <label class="control-label">{{app._('reporting.period_from')}}</label>
                <div class="controls">
                    <input type="date" value="{{content_dateBegin}}" name="dateBegin" required placeholder="yyyy-mm-dd">
                </div>
            </div>

            <div class="control-group">
                <label class="control-label">{{app._('reporting.period_to')}}</label>
                <div class="controls">
                    <input type="date" value="{{content_dateEnd}}" name="dateEnd" required placeholder="yyyy-mm-dd">
                </div>
            </div>

            <br/>

            <div class="shinken-part-title">{{app._('reporting.select_sla_thresholds')}}</div>

            <table class="shinken-table-setting-threshold">
                <tr>
                    <th class="shinken-column-threshold shinken-column-report-threshold">{{app._('reporting.report_threshold_label')}}</th>
                </tr>
                <tr>
                    <td class="shinken-column-report-threshold">
                        <div class="control-group">
                            <label class="control-label">{{app._('reporting.warning_threshold')}} {{app._('reporting.in_percent')}}</label>
                            <div class="controls">
                                <input type="text" value="{{content_warning_threshold}}" name="warning_threshold" placeholder="{{default_warning_threshold}}">
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="shinken-column-report-threshold">
                        <div class="control-group">
                            <label class="control-label">{{app._('reporting.critical_threshold')}} {{app._('reporting.in_percent')}}</label>
                            <div class="controls">
                                <input type="text" value="{{content_critical_threshold}}" name="critical_threshold" placeholder="{{default_critical_threshold}}">
                            </div>
                        </div>
                    </td>
                    <td rowspan="3"></td>
                </tr>
                <tr>
                    <td class="shinken-column-report-threshold">
                        <div class="shinken-help-report-treshold-container"><span class="shinkon shinkon-warning"></span> {{app._('reporting.help_report_threshold')}}</div>
                    </td>
                </tr>
            </table>

        </div>

        <div class='well'>
            <div class="shinken-part-title">{{app._('reporting.display_setting')}}</div>

            <table class="shinken-table-setting-threshold">

                %if user.acl_in_tab_history == 'history_sla' or user.acl_in_tab_history == 'sla':
                    <tr>
                        <th class="shinken-column-threshold shinken-column-report-threshold shinken-colum-first">{{app._('reporting.display_treshold')}}</th>
                        <th class="shinken-colum-second"></th>
                    </tr>
                    <tr>
                        <td class="shinken-column-report-threshold shinken-colum-first">
                            <div class="control-group">
                                <label class="control-label">{{app._('reporting.of_report')}}</label>
                                <div class="controls">
                                    <input type="checkbox" name="display_report_threshold" {{content_display_report_threshold}} id="display_report_threshold">
                                </div>
                            </div>
                        </td>
                        <td class="shinken-colum-second"></td>
                    </tr>
                    <tr>
                        <td class="shinken-column-report-threshold shinken-colum-first">
                            <div class="control-group">
                                <label class="control-label">{{app._('reporting.of_elements')}}</label>
                                <div class="controls">
                                    <input type="checkbox" name="display_element_threshold" {{content_display_element_threshold}} id="display_element_threshold">
                                </div>
                            </div>
                        </td>
                        <td class="shinken-colum-second"></td>
                    </tr>
                %end

                <tr>
                    <th class="shinken-column-threshold shinken-column-report-threshold shinken-colum-first">
                        <div class="control-group shinken-control-group-daily">
                            <label class="control-label shinken-control-label-daily">
                                    {{app._('reporting.daily_details_add')}}
                            </label>
                            <div class="controls">
                                <input type="checkbox" name="shinken_add_daily_details" {{content_display_daily_details}}>
                            </div>
                        </div>
                    </th>
                    <th class="shinken-column-threshold shinken-column-element-threshold shinken-colum-second"></th>
                </tr>

                <tr>
                    <th class="shinken-column-threshold shinken-column-report-threshold shinken-colum-first">{{app._('reporting.data_to_display')}}</th>
                    <th class="shinken-colum-second"></th>
                </tr>

                %if user.acl_in_tab_history == 'history_sla' or user.acl_in_tab_history == 'sla':
                    <tr>
                        <td class="shinken-column-report-threshold shinken-colum-first">
                            <div class="control-group">
                                <label class="control-label shinken-control-label-data-to-display">
                                    {{app._('reporting.display_total_sla')}} <span class="shinken-tiny-label"> {{app._('reporting.default')}} </span>
                                </label>
                                <div class="controls">
                                    <input type="checkbox" name="shinken_display_total_sla" {{content_display_total_sla}}>
                                </div>
                            </div>
                        </td>
                        <td class="shinken-colum-second"></td>
                    </tr>
                %end

                %if user.acl_in_tab_history == 'history_sla' or user.acl_in_tab_history == 'history':
                    <tr>
                        <td class="shinken-column-report-threshold shinken-colum-first shinken_display_total_historic-cell">
                            <div class="control-group">
                                <label class="control-label shinken-control-label-data-to-display">
                                    {{app._('reporting.display_total_historic')}}
                                </label>
                                <div class="controls">
                                    <input type="checkbox" name="shinken_display_total_historic" {{content_display_total_historic}}>
                                </div>
                            </div>
                        </td>
                        <td class="shinken-colum-second"></td>
                    </tr>
                %end

                %if user.acl_in_tab_history == 'history_sla' or user.acl_in_tab_history == 'sla':
                    <tr>
                        <td class="shinken-column-report-threshold shinken-colum-first">
                            <div class="control-group">
                                <label class="control-label shinken-control-label-data-to-display">
                                        {{app._('reporting.daily_sla_graph')}} <span class="shinken-tiny-label"> {{app._('reporting.max_31_days')}} </span>
                                </label>
                                <div class="controls">
                                    <input class="shinken-column-report-threshold-input" type="checkbox" name="shinken_daily_sla_graph" {{content_daily_sla_graph}} onchange="MANAGER.EventManager.clickOnCheckboxInput(event)">
                                </div>
                            </div>
                        </td>
                        <th class="shinken-column-threshold shinken-column-element-threshold shinken-colum-second"></th>
                    </tr>

                    <tr>
                        <td class="shinken-column-report-threshold shinken-graphics-scale-cell shinken-colum-first">
                            <div class="control-group shinken-control-group-graph">
                                <label class="control-label">{{app._('reporting.scale')}}</label>
                                <div class="controls">
                                    <select class="shinken-graphics-scale-selector shinken-graphic-select-width" name='shinken_graph_scale' onchange="MANAGER.EventManager.clickOnItemSelector(event, 'shinken_graph_scale')">
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{scale_auto}}>{{app._('reporting.scale_auto')}}</option>
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{scale_linear}}>{{app._('reporting.scale_linear')}}</option>
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{scale_zoom}}>{{app._('reporting.scale_zoom')}}</option>
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{scale_logarithmic}}>{{app._('reporting.scale_logarithmic')}}</option>
                                    </select>
                                </div>
                            </div>
                        </td>
                        <td class="shinken-column-report-threshold shinken-help-graph-options">
                            <div class="shinken-help-report-treshold-container shinken-help-graph-max-days">
                                <span class="shinkon shinkon-warning"></span>
                                {{app._('reporting.help_report_graphique_max_days')}}
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <td class="shinken-column-report-threshold shinken-help-graph-options">
                            <div class="shinken-help-report-treshold-container shinken-help-graph-y-margin">
                                <span class="shinkon shinkon-warning"></span>
                                {{app._('reporting.help_report_yim_ymax')}}
                            </div>
                        </td>
                        <td class="shinken-graph-preview shinken-colum-second td-shinken-graph-container" rowspan="5">
                            <div class="shinken-graph-container" data-item-uuid="preview_uuid">
                                <div class="shinken-not-enough-data-message">{{app._('reporting.not_enough_data_message')}}</div>
                                <canvas class="shinken-sla-historic-graph"></canvas>
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <td class="shinken-column-report-threshold shinken-column-ymax-select-cell shinken-colum-first">
                            <div class="control-group shinken-control-group-graph">
                                <label class="shinken-label-y-max control-label shinken-column-label-indent-deep-1">{{app._('reporting.y_max')}}</label>
                                <label class="shinken-label-y-max-zoom control-label shinken-column-label-indent-deep-1">{{app._('reporting.y_max_zoom')}}</label>
                                <div class="controls">
                                    <select class="shinken-column-ymax-selector shinken-graphic-select-width" name='shinken_graph_ymax' onchange="MANAGER.EventManager.clickOnItemSelector(event, 'shinken_graph_ymax')">
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{ymax_auto}}>{{app._('reporting.y_max_auto_zoom')}}</option>
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{ymax_valeur}}>{{app._('reporting.y_max_value')}}</option>
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{ymax_maximum_sla}}>{{app._('reporting.y_max_maximum')}}</option>
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{ymax_seuil_critic}}>{{app._('reporting.y_max_seuil_critic')}}</option>
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{ymax_seuil_warning}}>{{app._('reporting.y_max_seuil_warning')}}</option>
                                    </select>
                                </div>
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <td class="shinken-column-report-threshold shinken-column-ymax-value-cell shinken-colum-first">
                            <div class="control-group shinken-control-group-graph">
                                <label class="control-label shinken-column-ymax-value-cell-label shinken-column-label-indent-deep-2">{{app._('reporting.y_label_value')}}</label>
                                <div class="controls">
                                    <input
                                            class="shinken-column-ymax-value shinken-graphic-input-width"
                                            value={{shinken_graph_ymax_value}}
                                            name="shinken_graph_ymax_value"
                                            onchange="MANAGER.EventManager.onChangeOnInput(event)"
                                            type="number" step="any" min="0"
                                    >
                                </div>
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <td class="shinken-column-report-threshold shinken-column-ymin-select-cell shinken-colum-first">
                            <div class="control-group shinken-control-group-graph">
                                <label class="shinken-label-y-min control-label shinken-column-label-indent-deep-1">{{app._('reporting.y_min')}}</label>
                                <label class="shinken-label-y-min-zoom control-label shinken-column-label-indent-deep-1">{{app._('reporting.y_min_zoom')}}</label>
                                <div class="controls">
                                    <select class="shinken-column-ymin-selector shinken-graphic-select-width" name='shinken_graph_ymin' onchange="MANAGER.EventManager.clickOnItemSelector(event, 'shinken_graph_ymin')">
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{ymin_auto}}>{{app._('reporting.y_min_auto_zoom')}}</option>
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{ymin_valeur}}>{{app._('reporting.y_min_value')}}</option>
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{ymin_minimum_sla}}>{{app._('reporting.y_min_minimum')}}</option>
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{ymin_seuil_critic}}>{{app._('reporting.y_min_seuil_critic')}}</option>
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{ymin_seuil_warning}}>{{app._('reporting.y_min_seuil_warning')}}</option>
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{ymin_seuil_critic_center}}>{{app._('reporting.y_min_seuil_critic_centred')}}</option>
                                        <option onmouseenter="MANAGER.EventManager.mouseEnter(event)" {{ymin_seuil_warning_center}}>{{app._('reporting.y_min_seuil_warning_centred')}}</option>
                                    </select>
                                </div>
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <td class="shinken-column-report-threshold shinken-column-ymin-value-cell shinken-colum-first">
                            <div class="control-group shinken-control-group-graph">
                                <label class="control-label shinken-column-ymin-value-cell-label  shinken-column-label-indent-deep-2">{{app._('reporting.y_label_margin')}}</label>
                                <div class="controls">
                                    <input
                                            class="shinken-column-ymin-value shinken-graphic-input-width"
                                            value={{shinken_graph_ymin_value}}
                                            name="shinken_graph_ymin_value"
                                            onchange="MANAGER.EventManager.onChangeOnInput(event)"
                                            type="number"
                                            step="any"
                                            min="0"
                                    >
                                </div>
                            </div>
                        </td>
                    </tr>
                %end

            </table>
        </div>

        <div class='well'>
            <button class='btn' style='float:right' name="web" action='submit'>{{app._('reporting.submit')}}</button>
            <button class='btn' style='float:left' name="csv" action='submit'>{{app._('reporting.generate_csv')}}</button>
        </div>
    </form>
</div>


%rebase layout_form globals(), user=user, app=app, refresh=False
