%helper = app.helper
%datamgr = app.datamgr
%import time, datetime, calendar
%import shinkensolutions.shinkenjson as json
%from ..sla import KEY_TIME
%from ..sla import MODE_TO_GET
%from ..sla import ALL_STATES
%from ..sla import html_get_value_bar
%from ..sla import MODE_HISTORY_SLA
%from ..sla import MODE_HISTORY
%from ..sla import MODE_SLA
%from ..sla import total_table_sla_history_value_percent
%from datetime import date, timedelta

%#rebase layout globals(), title='Reporting', user=user, app=app, refresh=False

%date_string_begin = app.helper.print_date_locate(reporting_data['timestamp_begin'])
%date_string_end = app.helper.print_date_locate(reporting_data['timestamp_end'])
%s_period = app._('reporting.for_the_period') % (date_string_begin, date_string_end)
%modes = MODE_TO_GET[current_search['data_type']]
<html>
    <head>
        <style type="text/css">
            @font-face {
                font-family : "shinicon";
                src         : url("/static/{{app.http_start_time}}/font/shinicon.woff") format("woff"),
                url("/static/{{app.http_start_time}}/font/shinicon.ttf") format("truetype");
                font-weight : normal;
                font-style  : normal;
            }
            @font-face {
                font-family: "shinkenicons";
                src:
                url("/static/{{app.http_start_time}}/font/shinkenicons.woff") format("woff"),
                url("/static/{{app.http_start_time}}/font/shinkenicons.ttf")  format("truetype");
                font-weight: normal;
                font-style: normal;
            }
        </style>
        %if app:
            <script>
                // Set the default global lang, and as soon as possible
                var global_lang = '{{app.lang}}';
            </script>
        %end

        <!-- Traduction ones -->
        <script src="/static/{{app.http_start_time}}/js/traductions/en.js"></script>
        <script src="/static/{{app.http_start_time}}/js/traductions/fr.js"></script>
        <script src="/static/{{app.http_start_time}}/js/traductions/main.js"></script>

        <!-- -->
        <link href="/static/{{app.http_start_time}}/sla/css/reporting-web.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/css/bootstrap.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/css/shinicon.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/css/shinkon.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/css/shinken-tooltip.css" rel="stylesheet">

        <script src="/static/{{app.http_start_time}}/js/shinken-tooltip.js"></script>

        <script src="/static/{{app.http_start_time}}/js/jquery.js"></script>
        <script src="/static/{{app.http_start_time}}/js/bootstrap.js"></script>

        <!-- CHARTJS GRAPH -->
        <script>
            var __reporting_data_graph = {{!json.dumps(reporting_data_graph)}};
        </script>

        <script src="/static/{{app.http_start_time}}/js/chart.js"></script>
        <script src="/static/{{app.http_start_time}}/sla/js/http_lib_external/shinken_lib_external.js"></script>

        <script src="/static/{{app.http_start_time}}/sla/js/graphics/constant.js"></script>
        <script src="/static/{{app.http_start_time}}/sla/js/controller/form-constant.js"></script>

        <script src="/static/{{app.http_start_time}}/sla/js/graphics/curve/interface_curve.js"></script>
        <script src="/static/{{app.http_start_time}}/sla/js/graphics/graphic/interface_graphic.js"></script>
        <script src="/static/{{app.http_start_time}}/sla/js/graphics/graphic/with_custom_legend.js"></script>
        <script src="/static/{{app.http_start_time}}/sla/js/graphics/curve/generic.js"></script>
        <script src="/static/{{app.http_start_time}}/sla/js/graphics/curve/sla.js"></script>
        <script src="/static/{{app.http_start_time}}/sla/js/graphics/curve/threshold.js"></script>
        <script src="/static/{{app.http_start_time}}/sla/js/graphics/graphic/linear.js"></script>
        <script src="/static/{{app.http_start_time}}/sla/js/graphics/graphic/logarithmic.js"></script>
        <script src="/static/{{app.http_start_time}}/sla/js/graphics/graphic/zoomed.js"></script>
        <script src="/static/{{app.http_start_time}}/sla/js/graphics/chartjs-container.js"></script>


        <script src="/static/{{app.http_start_time}}/sla/js/controller/reporting-web-controller.js"></script>
        <script>
            $( '[data-toggle="tooltip"]' ).tooltip();
        </script>
    </head>
    <title>
        {{app._('reporting.title') % (app._('reporting.%s'%(current_search['type'].replace('/','_'))), current_search['filter'].decode('utf-8'))}}
    </title>
<body class="report">

%include _report-nav-bar locals()

<div class="report-content">


%include _report-header locals()
%include _report-total locals()

<div class='report-elements'>
    %for item in reporting_data['by_item']:
        %item_result = item['result']
        %item_name = ''
        %if item.get('sdesc', None) is None:
            %item_name = item['hname']
        %else:
            %item_name = "%s/%s"%(item['hname'],item['sdesc'])
        %end

        %if len(item['by_day']) == 0:
            <table class="report-element">
                <tr >
                    <td class="report-element-name">
                         {{item_name}} - {{app._('reporting.no_data')}}
                    </td>
                </tr>
            </table>
            %continue
        %end

        %include _report-daily-sla-table locals()

    %end
</div>

</div>
</body>
</html>
