#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2009-2022:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Optional
    from webui.module import WebuiBroker

app = None  # type: Optional[WebuiBroker]


def forge_response(callback, status, text):
    if callback:
        return "%s({'status':%s,'text':'%s'})" % (callback, status, text)
    else:
        return "{'status':%s,'text':'%s'}" % (status, text)


# We will always answer pong to a ping.
def get_ping():
    callback = app.request.query.get('callback', None)
    
    # We do not need to look at the user, should be public
    return forge_response(callback, 200, 'Pong')


# We will say if we got at least the first data, like contacts
# so the UI can refresh without breaking all.
def get_gotfirstdata():
    callback = app.request.query.get('callback', None)
    
    if len(app.datamgr.get_contacts()) > 0:
        return forge_response(callback, 200, '1')
    else:
        return forge_response(callback, 200, '0')


def is_backend_available():
    is_available = (len(app.datamgr.get_contacts()) > 0)
    return {'is_available': is_available}


pages = {
    get_ping            : {'routes': ['/ping'], 'wrappers': ['json']},
    get_gotfirstdata    : {'routes': ['/gotfirstdata'], 'wrappers': ['json']},
    is_backend_available: {'routes': ['/api/is_backend_available'], 'wrappers': ['json']},
}
