#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from .base_callback import PreSaver
from ..def_items import ITEM_STATE, HISTORY_ACTION
from ..item_saving_formatter import build_link

if TYPE_CHECKING:
    from shinken.misc.type_hint import Optional, Dict
    from synchronizer.dao.datamanagerV2 import DataManagerV2
    from synchronizer.dao.items import ContactItem


class _CallbackBuildLink(PreSaver):
    def called_before_save(self, item_id=u'', item_type=u'', item_state=u'', item=None, old_item=None, user=None, action=u'', datamanager=None):
        # type: (unicode, unicode, unicode, Optional[Dict], Optional[Dict], Optional[ContactItem], unicode, Optional[DataManagerV2]) -> None
        if item_state not in (ITEM_STATE.WORKING_AREA, ITEM_STATE.STAGGING, ITEM_STATE.PRODUCTION) or action == HISTORY_ACTION.UPDATE_WORK_AREA_INFO:
            return
        self.log(item_type, item_state, item_id, action, u'build links')
        build_link(item, item_type, item_state, datamanager)


_callback_build_link = _CallbackBuildLink()
