#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from .base_callback import PostSaver
from ..def_items import ITEM_STATE, HISTORY_ACTION

if TYPE_CHECKING:
    from synchronizer.dao.datamanagerV2 import DataManagerV2
    from shinken.misc.type_hint import Optional, Dict
    from synchronizer.dao.items import ContactItem


class _CallbackComputeDoubleLinks(PostSaver):
    def compute_double_links_callback(self, item_id=u'', item_type=u'', item_state=u'', item=None, old_item=None, user=None, action=u'', datamanager=None):
        # type: (unicode, unicode, unicode, Optional[Dict], Optional[Dict], Optional[ContactItem], unicode, Optional[DataManagerV2]) -> None
        if not datamanager.compute_double_links or item_state in (ITEM_STATE.CHANGES, ITEM_STATE.WORKING_AREA, ITEM_STATE.MERGE_SOURCES) or action == HISTORY_ACTION.UPDATE_WORK_AREA_INFO:
            return
        
        self.log(item_type, item_state, item_id, action, u'compute double links')
        datamanager._make_double_link(item, item_type, user, old_item)
    
    
    called_after_save = compute_double_links_callback


_callback_compute_double_links = _CallbackComputeDoubleLinks()
