#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from . import _callback_compute_diff_source_existing_item
from .base_callback import PostSaver
from ..def_items import ITEM_STATE, DEF_ITEMS, HISTORY_ACTION
from ..helpers import get_name_from_type, add_source_change

if TYPE_CHECKING:
    from shinken.misc.type_hint import Optional, Dict
    from synchronizer.dao.datamanagerV2 import DataManagerV2
    from synchronizer.dao.items import ContactItem


class _CallbackRecomputeReverseLinksChanges(PostSaver):
    def called_after_save(self, item_id=u'', item_type=u'', item_state=u'', item=None, old_item=None, user=None, action=u'', datamanager=None):
        # type: (unicode, unicode, unicode, Optional[Dict], Optional[Dict], Optional[ContactItem], unicode, Optional[DataManagerV2]) -> None
        if item_state not in (ITEM_STATE.WORKING_AREA, ITEM_STATE.STAGGING):
            return
        if old_item and get_name_from_type(item_type, old_item) != get_name_from_type(item_type, item):
            self.log(item_type, item_state, item_id, action, u'callback post rename')
            
            reverse_links = item.get_reverse_links()
            for reverse_link in reverse_links:
                item_link = datamanager.find_item_by_id(reverse_link.item_id, item_type=reverse_link.item_type, item_state=reverse_link.item_state)
                if item_link:
                    item_link_change = item_link.get_changes()
                    must_recompute_change = False
                    for link_property in DEF_ITEMS[item_link.get_type()][u'item_links'][item_type]:
                        if [link for link in item_link.get_links(link_property, item_type) if link.get(u'_id', None) == item_id]:
                            add_source_change(datamanager, item_link, item_link.get_type(), HISTORY_ACTION.AUTO_MODIFICATION, item_property=link_property)
                            if item_link_change and item_link_change.get(link_property, []):
                                must_recompute_change = True
                    
                    if must_recompute_change:
                        _callback_compute_diff_source_existing_item.called_before_save(item_link[u'_id'], item_link.get_type(), item_link.get_state(), item_link, None, user, HISTORY_ACTION.AUTO_MODIFICATION, datamanager)
                        datamanager.save_item(item_link, user, item_link.get_type(), item_link.get_state(), HISTORY_ACTION.AUTO_MODIFICATION)


_callback_recompute_reverse_links_changes = _CallbackRecomputeReverseLinksChanges()
