#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018
# This file is part of Shinken Enterprise, all rights reserved.

from baseitem import BaseItem
from contactitem import ContactItem
from misc_items import HostItem, ClusterItem, ServiceTemplateItem, HostGroupItem, ServiceItem, ContactTemplateItem, ContactGroupItem
from shinken.misc.type_hint import TYPE_CHECKING
from ..def_items import ITEM_TYPE, ItemType

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, Any
    from .misc_items import InstanceItem
    
    RawHostItem = Dict[unicode, Any]  # type for host item in datamanagerV2 & in mongo
    RawItem = Dict[unicode, Any]  # type for host item in datamanagerV2 & in mongo

TYPE_TO_CLASS = {
    ITEM_TYPE.CONTACTS           : ContactItem,
    ITEM_TYPE.CONTACTTPLS        : ContactTemplateItem,
    ITEM_TYPE.CONTACTGROUPS      : ContactGroupItem,
    
    ITEM_TYPE.CLUSTERS           : ClusterItem,
    ITEM_TYPE.CLUSTERTPLS        : ClusterItem,
    
    ITEM_TYPE.HOSTTPLS           : HostItem,
    ITEM_TYPE.HOSTS              : HostItem,
    ITEM_TYPE.HOSTGROUPS         : HostGroupItem,
    
    ITEM_TYPE.SERVICESHOSTS      : ServiceItem,
    ITEM_TYPE.SERVICESCLUSTERS   : ServiceItem,
    ITEM_TYPE.SERVICETPLS        : ServiceItem,
    
    ITEM_TYPE.SERVICESHOSTTPLS   : ServiceTemplateItem,
    ITEM_TYPE.SERVICESCLUSTERTPLS: ServiceTemplateItem,
    
}


def get_item_instance(item_type, raw_item=None):
    # type: (ItemType, RawItem) -> InstanceItem
    ItemClass = TYPE_TO_CLASS.get(item_type, BaseItem)
    if raw_item:
        return ItemClass(raw_item)
    return ItemClass()
