CONTROLLER.MassChange = (function ( self ) {
    "use strict";
    self.controller_name       = MANAGER.CONST.CONTROLLER.MASS_CHANGE;
    self.steps                 = new OBJECT.Steps( OBJECT.CONST.STEP._5 );
    self.show_debug            = false;
    //********************************************  INIT  **************************************************//
    self.reset                 = function () {
        self.list_check                  = null;
        self.list_summary_full           = null;
        self.lists_id                    = {};
        self.item_type                   = SHINKEN.HIGHWAY.getListType();
        self.type_modification           = CONTROLLER.CONST.MASS_CHANGE.TYPE.PROPERTIES;
        self.mass_change_checks_selected = null;
        self.steps                       = new OBJECT.Steps( OBJECT.CONST.STEP._5 );
        self.steps.setCurrent( OBJECT.CONST.STEP._0 );
        MANAGER.HelpManager.resetDomElement();
        MANAGER.__instance_property_distributor.reset();
        MANAGER.__instance_window_distributor.reset();
        MANAGER.__instance_button_distributor.reset();
        self.mass_change_uuid = SHINKEN.TOOLS.STRING.buildUUID();
        activateAlertBeforeUnload( false );
    };
    //********************************************  NAVIGATION  **************************************************//
    self.goNextStep            = function ( lists ) {
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._0:
                resetCallAjax();
                self.steps.setCurrent( OBJECT.CONST.STEP._1 );
                self.type_modification = CONTROLLER.CONST.MASS_CHANGE.TYPE.PROPERTIES;
                self.lists_id          = {};
                for ( var i = 0, _size_i = lists.length; i < _size_i; i++ ) {
                    self.lists_id[ lists[ i ][ 0 ].id ] = { name: lists[ i ][ 0 ].dataset.itemName, to_ignore: false };
                }
                callAjax();
                break;
            case OBJECT.CONST.STEP._1:
                switch ( self.type_modification ) {
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.DATAS:
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.LOCAL_DATAS:
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.DFE_DATAS:
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.PROPERTIES:
                        setStep( OBJECT.CONST.STEP._3 );
                        break;
                    default:
                        setStep( OBJECT.CONST.STEP._2 );
                        break;
                }
                break;
            case OBJECT.CONST.STEP._2:
                switch ( self.type_modification ) {
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                        if ( validateForm() ) {
                            setStep( OBJECT.CONST.STEP._4 );
                        }
                        break;
                    default:
                        setStep( OBJECT.CONST.STEP._3 );
                        break;
                }
                break;
            case OBJECT.CONST.STEP._3:
                if ( validateForm() ) {
                    setStep( OBJECT.CONST.STEP._4 );
                }
                break;
            case OBJECT.CONST.STEP._4:
                setStep( OBJECT.CONST.STEP._5 );
                break;
        }
    };
    self.goPreviousStep        = function ( event ) {
        event.stopPropagation();
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP.ERROR:
                self.steps.current = self.steps.previous;
                return self.goPreviousStep( event );
            case OBJECT.CONST.STEP._0:
            case OBJECT.CONST.STEP._1:
            case OBJECT.CONST.STEP._5:
                return;
            case OBJECT.CONST.STEP._2:
                setStep( OBJECT.CONST.STEP._1 );
                break;
            case OBJECT.CONST.STEP._3:
                switch ( self.type_modification ) {
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.DATAS:
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.LOCAL_DATAS:
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.DFE_DATAS:
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.PROPERTIES:
                        setStep( OBJECT.CONST.STEP._1 );
                        break;
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_OVERRIDE:
                        self.steps.setDomReady( false );
                        MANAGER.__instance_window_distributor.reset();
                        MANAGER.__instance_button_distributor.reset();
                        setStep( OBJECT.CONST.STEP._2 );
                        break;
                    default:
                        setStep( OBJECT.CONST.STEP._2 );
                        break;
                }
                break;
            case OBJECT.CONST.STEP._4:
                self.steps.setDomReady( false );
                switch ( self.type_modification ) {
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                        setStep( OBJECT.CONST.STEP._2 );
                        break;
                    default:
                        setStep( OBJECT.CONST.STEP._3 );
                        break;
                }
                break;
        }
    };
    self.quit                  = function () {
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._2:
            case OBJECT.CONST.STEP._3:
            case OBJECT.CONST.STEP._4:
                var _quit_confirmed = window.confirm( _( 'element.warn_unsave' ) );
                if ( _quit_confirmed ) {
                    self.reset();
                    MANAGER.EventManager.closeModal();
                }
                break;
            case OBJECT.CONST.STEP._1:
            case OBJECT.CONST.STEP.ERROR:
                self.reset();
                MANAGER.EventManager.closeModal();
                return;
            case OBJECT.CONST.STEP._5:
                SHINKEN.HIGHWAY.refreshCurrentPage();
                return;
        }
    };
    //********************************************  EVENT LISTENER  **************************************************//
    self.clickOnCheckboxInput  = function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 10 );
        var _name               = _parent_dom_element.dataset.name;
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._2:
                MANAGER.EventManager.stopPropagation();
                self.list_check.clickOnCheckboxInput( _name );
                afterAction();
                break;
            case OBJECT.CONST.STEP._3:
                CONTROLLER.ShinkenElement.clickOnCheckboxInput( event );
                break;
            case OBJECT.CONST.STEP._4:
                MANAGER.EventManager.stopPropagation();
                self.list_summary_full.clickOnCheckboxInput( _name );
                afterAction();
                break;
        }
    };
    self.clickOnRadioBtn       = function ( event ) {
        var _parent_dom_element;
        var _name;
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._1:
                resetCallAjax();
                _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 10 );
                _name               = _parent_dom_element.dataset.name;
                if ( _name === CONTROLLER.CONST.MASS_CHANGE.TYPE.DATAS ) {
                    _name = CONTROLLER.CONST.MASS_CHANGE.TYPE.LOCAL_DATAS;
                }
                if ( _name === CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS ) {
                    _name = CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_OVERRIDE;
                }
                self.type_modification = _name;
                DOM.Service.setDataSet( self.steps.dom_element, 'selectedType', _name );
                break;
            case OBJECT.CONST.STEP._3:
                _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 10 );
                _name               = _parent_dom_element.dataset.name;
                switch ( _name ) {
                    case "group-data-list":
                        this.data_groups.clickOnRadioBtn( event );
                        break;
                    default:
                        CONTROLLER.ShinkenElement.clickOnRadioBtn( event );
                        break;
                }
                break;
        }
    };
    self.clickOnCollapseButton = function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, 'shinken-collapse-listener', 10 );
        var _name               = _parent_dom_element.dataset.name;
        if ( !_name ) {
            console.log( "[clickOnCollapseButton]", "name not defined for element", _parent_dom_element );
            return;
        }
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._4:
                event.stopPropagation();
                self.list_summary_full.hidePopup();
            case OBJECT.CONST.STEP._5:
                self.list_summary_full.clickOnCollapseButton( _name );
                break;
        }
    };
    self.clickOnSelector       = function ( event, parent_name ) {
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._2:
                var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 10 );
                var _type_object        = _parent_dom_element.dataset.objectType;
                switch ( _type_object ) {
                    case "shinken-list-filter":
                        self.list_check.clickOnSelector( event );
                        break;
                    default:
                        CONTROLLER.ShinkenElement.clickOnSelector( event, parent_name );
                        break;
                }
                break;
            case OBJECT.CONST.STEP._3:
                CONTROLLER.ShinkenElement.clickOnSelector( event, parent_name );
                break;
            case OBJECT.CONST.STEP._4:
            case OBJECT.CONST.STEP._5:
                self.list_summary_full.clickOnSelector( event );
                break;
        }
        
    };
    self.clickOnItemSelector   = function ( event, parent_name, element ) {
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._2:
                var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 10 );
                var _type_object        = _parent_dom_element.dataset.objectType;
                switch ( _type_object ) {
                    case "shinken-list-filter":
                        self.filterListAction( event, parent_name, element );
                        break;
                    default:
                        CONTROLLER.ShinkenElement.clickOnItemSelector( event, parent_name, element );
                        break;
                }
                break;
            case OBJECT.CONST.STEP._3:
                CONTROLLER.ShinkenElement.clickOnItemSelector( event, parent_name, element );
                break;
            case OBJECT.CONST.STEP._4:
            case OBJECT.CONST.STEP._5:
                self.list_summary_full.clickOnItemSelector( event, parent_name, element );
                break;
        }
    };
    self.clickOnInput          = function ( event ) {
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._3:
                CONTROLLER.ShinkenElement.clickOnInput( event );
                break;
            case OBJECT.CONST.STEP._4:
                break;
        }
    };
    self.clickOnButton         = function ( event ) {
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._3:
                event.preventDefault(); //WHY???
                var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 10 );
                switch ( _parent_dom_element.dataset.name ) {
                    case "add-local-data":
                        self.addNewData();
                        break;
                }
                break;
            case OBJECT.CONST.STEP._4:
            case OBJECT.CONST.STEP._5:
                var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, "shinken-parent-event-listener", 50 );
                _parent_dom_element.classList.toggle( "shinken-button-active" );
                break;
        }
    };
    self.mouseEnter            = function ( event ) {
        if ( !MANAGER.HelpManager.dom_element ) {
            MANAGER.HelpManager.initDomElement( self.steps.get().dom_element );
        }
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._1:
                var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 50 );
                MANAGER.HelpManager.setActive( _parent_dom_element.dataset.name, _( 'mass-change.step-1.types.' + _parent_dom_element.dataset.name ), _parent_dom_element.dataset.helpLabel );
                break;
            case OBJECT.CONST.STEP._2:
            case OBJECT.CONST.STEP._3:
                CONTROLLER.ShinkenElement.mouseEnter( event );
                break;
        }
    };
    self.mouseLeave            = function ( event ) {
        if ( !MANAGER.HelpManager.dom_element ) {
            MANAGER.HelpManager.initDomElement( self.steps.get().dom_element );
        }
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._1:
                MANAGER.HelpManager.setActive( self.type_modification, _( 'mass-change.step-1.types.' + self.type_modification ), 'mass-change.step-1.help.' + self.type_modification );
                break;
            case OBJECT.CONST.STEP._2:
            case OBJECT.CONST.STEP._3:
                CONTROLLER.ShinkenElement.mouseLeave( event );
                break;
        }
    };
    self.keydown               = function ( event, key_code ) {
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._3:
                CONTROLLER.ShinkenElement.keydown( event, key_code );
                break;
        }
    };
    self.onChangeOnInput       = function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 20 );
        var _type_object;
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._2:
                _type_object = _parent_dom_element.dataset.objectType;
                switch ( _type_object ) {
                    case "shinken-list-filter":
                        self.list_check.askComputeAfterChange( _parent_dom_element );
                        break;
                    default:
                        CONTROLLER.ShinkenElement.onChangeOnInput( event );
                        break;
                }
                break;
            case OBJECT.CONST.STEP._3:
                _type_object = _parent_dom_element.dataset.objectType;
                switch ( _type_object ) {
                    case "shinken-list-filter":
                        self.list_datas.askComputeAfterChange( _parent_dom_element );
                        break;
                    default:
                        CONTROLLER.ShinkenElement.onChangeOnInput( event );
                        break;
                }
                break;
            case OBJECT.CONST.STEP._4:
            case OBJECT.CONST.STEP._5:
                self.list_summary_full.askComputeAfterChange( _parent_dom_element );
                break;
        }
    };
    self.clickOnPaste          = function ( event ) {
        CONTROLLER.ShinkenElement.clickOnPaste( event );
    };
    self.onFocusOut            = function ( event ) {
        CONTROLLER.ShinkenElement.onFocusOut( event );
    };
    self.onClick               = function ( event ) {
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._2:
                if ( self.list_check ) {
                    self.list_check.hidePopup();
                }
                var _parent_link = DOM.Service.findParentElementWithClass( event.target, 'shinken-link', 10 );
                if ( _parent_link ) {
                    return;
                }
                var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, 'shinken-parent-target-click', 20 );
                if ( _parent_dom_element && _parent_dom_element.classList.contains( "shinken-list-line" ) ) {
                    self.list_check.clickOnCheckboxInput( _parent_dom_element.dataset.uuid );
                    afterAction();
                }
                break;
            case OBJECT.CONST.STEP._4:
                var _parent_link = DOM.Service.findParentElementWithClass( event.target, 'shinken-link', 10 );
                if ( _parent_link ) {
                    return;
                }
                var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, 'shinken-parent-target-click', 20 );
                if ( !_parent_dom_element ) {
                    return;
                }
                if ( DOM.Service.findParentElementWithClass( event.target, 'shinken-toggle-button-active', 20 ) ||
                     _parent_dom_element.classList.contains( "shinken-selected-disabled" ) ) {
                    _parent_dom_element.classList.toggle( "shinken-button-active" );
                    event.stopPropagation();
                    return;
                }
                if ( _parent_dom_element.classList.contains( "shinken-list-line" ) ) {
                    self.list_summary_full.clickOnCheckboxInput( _parent_dom_element.dataset.uuid );
                    afterAction();
                }
            case OBJECT.CONST.STEP._5:
                if ( self.list_summary_full ) {
                    self.list_summary_full.hidePopup();
                }
                var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, 'shinken-parent-target-click', 20 );
                if ( !_parent_dom_element ) {
                    return;
                }
                if ( DOM.Service.findParentElementWithClass( event.target, 'shinken-toggle-button-active', 20 ) ||
                     _parent_dom_element.classList.contains( "shinken-selected-disabled" ) ) {
                    _parent_dom_element.classList.toggle( "shinken-button-active" );
                    event.stopPropagation();
                    return;
                }
                break;
        }
    };
    self.simulateClickOnFilter = function ( event, header_name, value ) {
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._4:
                DOM.Service.SimulateAction.mouseUp(self.steps.get().dom_element.querySelector( '.shinken-list-filter[data-name="' + header_name + '"] .shinken-option[data-key-name="' + value + '"]' ));
                break;
        }
    };
    //********************************************  STEP-2 SERVICE EXCLUDE    ******************************************************//
    self.setExcludeByName      = function ( value ) {
        if ( value ) {
            self.list_check.setAllLinesDataSet( "excludeByName", "1", "service_name", value.split( ',' ), "0", "matching_regex" );
        }
        else {
            self.list_check.setAllLinesDataSet( "excludeByName", "0" );
        }
    };
    self.filterListAction      = function ( event, parent_name, element ) {
        var _current;
        var _by_id;
        var _by_name;
        for ( var i = 0, _size_i = self.list_check.lines.contents.length; i < _size_i; i++ ) {
            _current = self.list_check.lines.contents[ i ];
            _by_id   = _current.is_selected;
            _by_name = _current.dom_element.dataset.excludeByName === '1';
            if ( _by_id && _by_name ) {
                _current.cell_value[ 'action' ] = [ "BY_ID", "BY_NAME", "BY_NAME_AND_ID" ];
            }
            else if ( _by_id ) {
                _current.cell_value[ 'action' ] = "BY_ID";
            }
            else if ( _by_name ) {
                _current.cell_value[ 'action' ] = "BY_NAME";
            }
            else {
                _current.cell_value[ 'action' ] = "";
            }
        }
        self.list_check.clickOnItemSelector( event, parent_name, element );
    };
    //********************************************  STEP-3 DATAS    ******************************************************//
    self.filterListData        = function ( data_group ) {
        var _values = data_group.getDataList();
        if ( data_group.getUUID() === CONTROLLER.CONST.MASS_CHANGE.GROUP_DATA.LOCAL && !_values.length ) {
            self.list_datas.doActionAfterChange( { 'type': 'shinken-hide-all-element' } );
        }
        else {
            self.list_datas.filters.contents[ 'data_name_array' ].setValue( _values );
            self.list_datas.doActionAfterChange( { 'type': 'shinken-list-filter' } );
        }
    };
    self.addNewData            = function () {
        var _name              = PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL;
        var _to_add            = new PROPERTY.Data( _name, "", self.data_groups.getElementByID( CONTROLLER.CONST.MASS_CHANGE.GROUP_DATA.ALL ) );
        _to_add.is_mass_change = true;
        _to_add.init();
        _to_add.setStatus( PROPERTY.CONST.DATA.STATUS.NEW );
        var _dom_to_add_in = document.querySelector( "#id-shinken-data-prop-table .shinken-tbody" );
        _dom_to_add_in.insertBefore( _to_add.dom_element, _dom_to_add_in.firstChild );
        MANAGER.__instance_property_distributor.setElement( _to_add.uuid, _to_add );
        _to_add.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION.SET_OR_CREATE, null, _to_add.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
        self.data_groups.addData( _to_add.uuid );
        self.list_datas.addLine( _to_add.dom_element );
    };
    self.removeData            = function ( property ) {
        self.data_groups.removeData( property.uuid );
        self.list_datas.removeLine( property.uuid );
    };
    self.updateDataUserCounter = function ( uuid, value ) {
        self.data_groups.updateDataUserCounter( uuid, value );
    };
    self.ChangeDataName        = function ( property ) {
        var _line                       = self.list_datas.getLineByUUID( property.uuid );
        _line.cell_value[ "data_name" ] = property.name;
    };
    
    //********************************************  NAVIGATOR SIZE MANAGER    ******************************************************//
    self.computeSizes     = function ( deep ) {
        if ( deep === undefined ) {
            deep = 10;
        }
        else if ( !deep ) {
            return;
        }
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._1:
                self.computeSizesHelp();
                break;
            case OBJECT.CONST.STEP._3:
                var _dom    = document.querySelector( "#id-shinken-form-element .shinken-tab-content" );
                var _top    = DOM.Service.getBoundingClientRect( _dom, DOM.CONST.STYLE.TOP );
                var _dom_2  = document.querySelector( "#id-shinken-mass-change-tunnel-step3" );
                var _bottom = DOM.Service.getBoundingClientRect( _dom_2, DOM.CONST.STYLE.BOTTOM );
                var _marge  = DOM.Service.getComputedStyle( _dom_2, 'paddingBottom' );
                DOM.Service.setStyle( _dom, DOM.CONST.STYLE.HEIGHT, _bottom - _top - _marge );
                self.computeSizesHelp();
                break;
            case OBJECT.CONST.STEP._2:
                self.computeSizesHelp();
            case OBJECT.CONST.STEP._4:
            case OBJECT.CONST.STEP._5:
                var _dom_2 = document.querySelector( "#id-shinken-mass-change-tunnel-step" + self.steps.current );
                var _dom   = _dom_2.querySelector( ".shinken-scrollable-container" );
                var _old   = DOM.Service.getBoundingClientRect( _dom, DOM.CONST.STYLE.HEIGHT );
                var _top   = DOM.Service.getBoundingClientRect( _dom, DOM.CONST.STYLE.TOP );
                
                var _bottom = DOM.Service.getBoundingClientRect( _dom_2, DOM.CONST.STYLE.BOTTOM );
                var _marge  = DOM.Service.getComputedStyle( _dom_2, 'paddingBottom' );
                var _new    = _bottom - _top - _marge;
                DOM.Service.setStyle( _dom, DOM.CONST.STYLE.HEIGHT, _new );
                if ( _old > 0 && _new > 0 && _old !== _new && Math.abs( _old - _new ) > 2 ) {
                    self.computeSizes( --deep );
                }
                break;
        }
    };
    self.computeSizesHelp = function ( retry_counter ) {
        var _container        = self.steps.dom_element;
        var _bottom_container = DOM.Service.getBoundingClientRect( _container, DOM.CONST.STYLE.BOTTOM );
        var _marge_container  = DOM.Service.getComputedStyle( document.getElementById( "id-shinken-mass-change-tunnel-step" + self.steps.current ), 'paddingBottom' );
        if ( !_marge_container && retry_counter ) {
            setTimeout( function () {
                self.computeSizesHelp( retry_counter-- );
            }, 10 );
            return;
        }
        var _dom = document.querySelector( "#id-shinken-mass-change-tunnel-step" + self.steps.current + " #id-shinken-help-container" );
        if ( !_dom ) {
            return;
        }
        var _top         = DOM.Service.getBoundingClientRect( _dom, DOM.CONST.STYLE.TOP );
        var _dom_2       = _dom.querySelector( ".shinken-help-content-container" );
        _marge_container = Math.max( _marge_container, 25 );
        DOM.Service.setStyle( _dom, DOM.CONST.STYLE.HEIGHT, _bottom_container - _top - _marge_container );
        DOM.Service.setStyle( _dom_2, DOM.CONST.STYLE.HEIGHT, _bottom_container - DOM.Service.getBoundingClientRect( _dom_2, DOM.CONST.STYLE.TOP ) - _marge_container );
    };
    
    //********************************************  GETTER SETTER ****************************************************//
    self.setStep_debug = function ( new_step ) {
        setStep( new_step );
    };
    
    function setStep ( new_step ) {
        
        self.steps.setCurrent( new_step );
        MANAGER.HelpManager.resetDomElement();
        self.computeSizesHelp();
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP.ERROR:
                return;
            case OBJECT.CONST.STEP._1:
                return; //ALWAYS REVERT HERE
            case OBJECT.CONST.STEP._2:
                if ( self.steps.isDomReady() ) {
                    return;
                }
                MANAGER.__instance_property_distributor.reset();
                callAjax();
                break;
            case OBJECT.CONST.STEP._3:
                if ( self.steps.isDomReady() ) {
                    return;
                }
                MANAGER.__instance_property_distributor.reset();
                callAjax();
                break;
            case OBJECT.CONST.STEP._4:
            case OBJECT.CONST.STEP._5:
                MANAGER.__instance_button_distributor.reset();
                callAjax();
                break;
        }
    }
    
    //********************************************  INTERNAL    ******************************************************//
    function afterAction () {
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._2:
            case OBJECT.CONST.STEP._4:
                var _button = self.steps.getNextButton();
                if ( _button.user_set.counter_final && !_button.errors.counter_final ) {
                    _button.dom_element.classList.remove( "shinken-disabled" );
                }
                else {
                    _button.dom_element.classList.add( "shinken-disabled" );
                }
                break;
        }
    }
    
    function resetCallAjax () {
        self.steps.get( OBJECT.CONST.STEP._1 ).setDomReady( true );
        self.steps.get( OBJECT.CONST.STEP._2 ).setDomReady( false );
        self.steps.get( OBJECT.CONST.STEP._3 ).setDomReady( false );
        self.steps.get( OBJECT.CONST.STEP._4 ).setDomReady( false );
        self.steps.get( OBJECT.CONST.STEP._5 ).setDomReady( false );
        
        MANAGER.__instance_property_distributor.reset();
        MANAGER.__instance_window_distributor.reset();
        MANAGER.__instance_button_distributor.reset();
    }
    
    function callAjax () {
        var _path = COMMUNICATION.QUERY.GET.MASS_CHANGE.BASE + self.item_type;
        var _data = buildDatas();
        //if ( self.steps.current === OBJECT.CONST.STEP._4 ){
        //    setStep( OBJECT.CONST.STEP._3 , true);
        //    return;
        //}
        if ( self.show_debug ) {
            console.log( "GREG", "[buildDatas - buildDatas]", _path, _data );
        }
        
        $.ajax( {
            url     : _path,
            type    : 'POST',
            dataType: "text",
            data    : JSON.stringify( _data ),
            success : function ( data ) {
                updateHtmlAfterCallAjax( data );
                doActionAfterCallAjax();
            },
            error   : function ( rc, state, error ) {
                console.error( "[callAjax]", rc.responseText, state, error );
                setStep( OBJECT.CONST.STEP.ERROR );
            }
        } );
    }
    
    function buildDatas () {
        var _to_return               = {};
        _to_return.uuid              = self.mass_change_uuid;
        _to_return.items             = self.lists_id;
        _to_return.step              = self.steps.current;
        _to_return.type_modification = self.type_modification;
        var _checks                  = getListChecks();
        if ( _checks ) {
            _to_return.checks = _checks;
        }
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._2:
                _to_return.update = getCurrentObjectFromProperty();
                break;
            case OBJECT.CONST.STEP._1:
            case OBJECT.CONST.STEP._3:
                break;
            case OBJECT.CONST.STEP._5:
                _to_return.bypass_work_area = MANAGER.WorkFlowManager.getState() === MANAGER.CONST.STATE.WORK_FLOW.STAGING;
                var _not_selected_lines     = self.list_summary_full.getNotSelectedLines();
                var _current;
                for ( var i = 0, _size_i = _not_selected_lines.length; i < _size_i; i++ ) {
                    _current = _to_return.items[ _not_selected_lines[ i ].uuid ];
                    if ( _current ) {
                        _to_return.items[ _not_selected_lines[ i ].uuid ].to_ignore = true;
                    }
                }
            case OBJECT.CONST.STEP._4:
                _to_return.update = getCurrentObjectFromPropertyMassChange( self.type_modification );
                delete _to_return.update._id;
                if ( self.type_modification === CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE && _to_return.checks ) {
                    if ( Object.keys( _to_return.checks ).length ) {
                        _to_return.update[ OBJECT.CONST.ELEMENT.FIELD.SERVICE_EXCLUDES_BY_ID ] = _to_return.checks;
                    }
                    delete _to_return.checks;
                }
                break;
        }
        return _to_return;
    }
    
    function getListChecks () {
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._1:
                return;
        }
        switch ( self.type_modification ) {
            case CONTROLLER.CONST.MASS_CHANGE.TYPE.PROPERTIES:
            case CONTROLLER.CONST.MASS_CHANGE.TYPE.DATAS:
                return;
        }
        if ( !self.list_check ) {
            return;
        }
        return self.list_check.getDataToSave( self.type_modification );
    }
    
    function updateHtmlAfterCallAjax ( data ) {
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._1:
                MANAGER.__instance_window_modal_manager.setContent( data );
                self.steps.initDomElements( "id-shinken-mass-change-tunnel" );
                break;
            default:
                var _target;
                var _to_add = DOM.Service.generateDomElementFromString( data );
                for ( var i = _to_add.length - 1; i >= 0; i-- ) {
                    _target = document.getElementById( _to_add[ i ].id );
                    DOM.Service.replaceChild( _target, _to_add[ i ] );
                }
                break;
        }
        self.computeSizes();
    }
    
    function initChecksDataFromDom () {
        var _all_items = document.getElementById( "id-shinken-all-items" );
        _all_items     = JSON.parse( DOM.Service.getInnerText( _all_items ) );
        
        var _keys = Object.keys( _all_items );
        var _current_key;
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _current     = new OBJECT.ShinkenElement();
            _current.updateData( _all_items[ _current_key ] );
            MANAGER.__instance_element_distributor.addElement( _current );
        }
    }
    
    function initUserDataFromDom () {
        var _all_items = document.getElementById( "id-shinken-user-list" );
        if ( !_all_items ) {
            return;
        }
        _all_items = JSON.parse( DOM.Service.getInnerText( _all_items ) );
        var _current;
        for ( var i = 0, _size_i = _all_items.length; i < _size_i; i++ ) {
            _current = new OBJECT.ShinkenElement();
            _current.setType( _all_items[ i ][ OBJECT.CONST.ELEMENT.FIELD.ITEM_TYPE ] );
            _current.updateData( _all_items[ i ] );
            MANAGER.__instance_element_distributor.addElement( _current );
        }
    }
    
    function doActionAfterCallAjax () {
        self.steps.setDomReady( true );
        switch ( self.steps.current ) {
            case OBJECT.CONST.STEP._0:
                break;
            case OBJECT.CONST.STEP._1:
                var _shinken_element = new OBJECT.ShinkenElement();
                _shinken_element.setUUID( "mass-change" );
                _shinken_element.setType( document.getElementById( "id-shinken-mass-change-tunnel" ).dataset.itemType );
                MANAGER.__instance_element_distributor.setCurrentElement( _shinken_element );
                _shinken_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.VIEWING );
                self.computeSizesHelp( 10 );
                activateAlertBeforeUnload( true );
                break;
            case OBJECT.CONST.STEP._2:
                initChecksDataFromDom();
                self.mass_change_checks_selected              = MANAGER.__instance_counter_distributor.findCounter( "mass-change-checks-selected", true );
                self.mass_change_checks_selected.show_if_null = true;
                self.list_check                               = new SHINKEN_LIST.Set( document.getElementById( "id-shinken-mass-change-list" ), SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST );
                setTimeout( function () {
                    self.mass_change_checks_selected.has_animation = true;
                }, 500 );
                var _button = self.steps.getNextButton();
                self.mass_change_checks_selected.setParent( _button.user_set );
                switch ( self.type_modification ) {
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                        initAllShinkenProperty();
                        break;
                }
                break;
            case OBJECT.CONST.STEP._3:
                initAllShinkenProperty();
                initUserDataFromDom();
                switch ( self.type_modification ) {
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_OVERRIDE:
                        document.querySelector( "#id-shinken-mass-change-tunnel-step3 .shinken-id-nb-checks-affected" ).innerHTML = SHINKEN.TOOLS.STRING.format( _( "mass-change.nb-element-affected" ), self.list_check.lines.getNbSelected(), _( 'element.checks' ) );
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.LOCAL_DATAS:
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.DFE_DATAS:
                        self.data_groups = new WINDOW.DataGroups( document.getElementById( "id-shinken-data-groups-list" ), CONTROLLER.CONST.MASS_CHANGE.NAME );
                        self.list_datas  = new SHINKEN_LIST.Set( document.getElementById( "id-shinken-data-prop-table" ), SHINKEN_LIST.CONST.TYPE.DATA_PROP );
                        break;
                }
                break;
            case OBJECT.CONST.STEP._4:
                var _warning_counter_btn = CONTROLLER.MassChange.steps.get().button_next.getCounterWarning();
                _warning_counter_btn.setDiscreet( true );
                _warning_counter_btn.setParent( MANAGER.__instance_counter_distributor.findCounter( "mass-change-warning-final", true ) );
                self.mass_change_element_selected              = MANAGER.__instance_counter_distributor.findCounter( "mass-change-element-selected", true );
                self.mass_change_element_selected.show_if_null = true;
                setTimeout( function () {
                    self.mass_change_element_selected.has_animation = true;
                }, 500 );
                self.list_summary_full = new SHINKEN_LIST.Set( document.querySelector( "#id-shinken-mass-change-tunnel-step4 .shinken-mass-change-summary-full" ), SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL );
                var _button            = self.steps.getNextButton();
                self.mass_change_element_selected.setParent( _button.user_set );
                _button.user_set.is_discreet = true;
                if ( self.type_modification === CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_OVERRIDE ) {
                    document.querySelector( "#id-shinken-mass-change-tunnel-step4 .shinken-id-nb-checks-affected" ).innerHTML = SHINKEN.TOOLS.STRING.format( _( "mass-change.nb-element-affected" ), self.list_check.lines.getNbSelected(), _( 'element.checks' ) );
                }
                break;
            case OBJECT.CONST.STEP._5:
                var _dom_element_list = document.querySelector( "#id-shinken-mass-change-tunnel-step5 .shinken-mass-change-summary-full" );
                if ( _dom_element_list ) {
                    self.list_summary_full = new SHINKEN_LIST.Set( _dom_element_list, SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL );
                }
                window.onbeforeunload = null;
                break;
        }
    }
    
    function initAllWindowElement () {
        MANAGER.__instance_window_distributor.findParentWindow( MANAGER.__instance_element_distributor.current_element.uuid ).setParentCounter( self.steps.getNextButton() );
        var _datas = MANAGER.__instance_window_distributor.findWindow( WINDOW.CONST.ELEMENT.DATAS, false, MANAGER.__instance_element_distributor.current_element.uuid );
        if ( _datas ) {
            _datas.getCounterTotal().show_if_null = true;
            _datas.getCounterTotal()._askUpdateHTML();
        }
        var _checks = MANAGER.__instance_window_distributor.findWindow( WINDOW.CONST.ELEMENT.CHECKS, false, MANAGER.__instance_element_distributor.current_element.uuid );
        if ( _checks ) {
            _checks.getCounterTotal().show_if_null = true;
            _checks.getCounterTotal()._askUpdateHTML();
        }
    }
    
    function initAllShinkenProperty () {
        initAllWindowElement();
        MANAGER.__instance_property_distributor.reset();
        var _dom_elements = document.querySelectorAll( '#id-shinken-window-modal .' + PROPERTY.CONST.CLASS.SKINKEN_LINE );
        var _current;
        var _current_element;
        for ( var i = 0, _size = _dom_elements.length; i < _size; i++ ) {
            _current         = _dom_elements[ i ];
            _current_element = MANAGER.__instance_property_distributor.findElement( _current.dataset.name );
            _current_element.updateWithTemplate();
            switch ( self.type_modification ) {
                case CONTROLLER.CONST.MASS_CHANGE.TYPE.DFE_DATAS:
                    _current_element.setGroupData( { type: PROPERTY.CONST.DATA.GROUP.DFE } );
                    break;
                case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_OVERRIDE:
                    MANAGER.HelpManager.setTitle( _current_element.name, _( 'help-services.' + _current_element.name + "-title" ) + ' (override)' );
                    if ( _current_element.name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
                        MANAGER.HelpManager.setContent( _current_element.name, 'help-services.check_command-content-override' );
                    }
                    else if ( _current_element.type === PROPERTY.CONST.TYPES.DATA ) {
                        MANAGER.HelpManager.setTitle( _current_element.name, _current_element.name + ' (override)' );
                        MANAGER.HelpManager.setContent( _current_element.name, 'element.help_text_data' );
                    }
                    else {
                        MANAGER.HelpManager.setContent( _current_element.name, 'help-services.' + _current_element.name + "-content" );
                    }
                    _current_element.is_override_mass_change = true;
                    break;
            }
        }
        MANAGER.__instance_property_distributor.finalyzeModel();
    }
    
    function validateForm () {
        var _elements  = MANAGER.__instance_property_distributor.getAllElements();
        var _current;
        var _to_return = true;
        for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
            _current = _elements[ i ];
            _current.checkErrorWarning( true );
            if ( _current.getCounterError().counter_final ) {
                _to_return = false;
            }
        }
        if ( !_to_return ) {
            var _button = self.steps.getNextButton();
            _button.dom_element.classList.add( "shinken-disabled" );
        }
        return _to_return;
    }
    
    function activateAlertBeforeUnload ( to_set ) {
        if ( to_set ) {
            window.onbeforeunload = function () {
                return _( 'element.warn_unsave' );
            };
        }
        else {
            window.onbeforeunload = null;
        }
    }
    
    //********************************************  PROGRESS BAR    ******************************************************//
    function callProgressBar () {
        var _path = COMMUNICATION.QUERY.GET.MASS_CHANGE.PROGRESS_BAR + self.mass_change_uuid;
        
        $.ajax( {
            url     : _path,
            type    : 'GET',
            dataType: "text",
            success : function ( data ) {
                console.log( "GREG", "[success - success]", "[data]" );
            },
            error   : function ( rc, state, error ) {
                console.error( "[callAjax]", rc.responseText, state, error );
            }
        } );
    }
    
    return self;
})
( CONTROLLER.MassChange || {} );