var doActionWhenDomReady = function ( e ) {
    // Only available if we have to analyse something :)
    MANAGER.__instance_loading.setIsReady( true );
    CONTROLLER.Source.initCurrentSource();
    CONTROLLER.Source.createPopupIfNeeded();
    
    document.addEventListener( 'keydown', function ( event ) {
        MANAGER.EventManager.keydown( event );
    } );
    
    if ( typeof g_host_uuids_to_analyze === 'undefined' ) {
        return;
    }
    __instance_analyzer_manager = new analyzerManager();
    setInterval( function () {
        __instance_analyzer_manager.tick();
    }, 1000 );
    
    var dom = document.getElementById( "analyze-button" );
    if ( dom ) {
        dom.classList.remove( "shinken-button-disabled" );
    }
};

CONTROLLER.Source = {
    __conf_id           : null,
    __source_name       : null,
    __number_active_conf: null,
    source_name_current : null,
    //********************************************  EVENT LISTENER  **************************************************//
    keydown             : function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.F1:
            case SHINKEN.CONST.KEY_CODE.ESCAPE:
                if ( MANAGER.__instance_window_distributor.findParentWindow( 'tab-group' ).getActiveWindow().name === "tab-mapping_origin_to_source" ) {
                    var _iframe = document.querySelector( "#tab-pane-mapping_origin_to_source-target iframe" ).contentWindow;
                    _iframe.MANAGER.EventManager.keydown( event );
                }
                else if ( MANAGER.__instance_window_distributor.findParentWindow( 'tab-group' ).getActiveWindow().name === "tab-host_template_binding_rules" ) {
                    var _iframe = document.querySelector( "#tab-pane-host_template_binding_rules-target iframe" ).contentWindow;
                    _iframe.MANAGER.EventManager.keydown( event );
                }
                break;
        }
    },
    //********************************************  INIT  **************************************************//
    initCurrentSource   : function () {
        this.source_name_current = document.getElementById( "wrapper" ).dataset.sourceName;
        if ( !this.source_name_current ) { //CAS DES TAGGERS
            return;
        }
        var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
        var self     = this;
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.REFRESH_UNIQUE.URL
                     + self.source_name_current
                     + COMMUNICATION.QUERY.GET.SOURCE.CLEAN_IMPORT.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                data.is_single_display = true;
                _sources.init( [ data ] );
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
    },
    //********************************************  TO SORT  **************************************************//
    createPopupIfNeeded : function () {
        this.__conf_id     = window.parent.window.SHINKEN.HIGHWAY.getParams( 'conf-id' );
        this.__source_name = window.parent.window.SHINKEN.HIGHWAY.getParams( 'source-name' );
        
        if ( this.__conf_id && this.__source_name ) {
            var _url = this.__conf_id === 'new' ? '/sources/' + this.__source_name + '/discovery/add/?no_menu_if_unknown=1' : '/sources/' + this.__source_name + '/discovery/' + this.__conf_id + "?no_menu_if_unknown=1";
            window.parent.window.MANAGER.EventManager.openIframeModal( _url );
        }
    },
    configurePlageIp    : function ( source_name, conf_id ) {
        //var _current_source = parent.window.MANAGER.__instance_source_distributor.findSource(source_name);
        //_current_source.askUpdateBeforeAnyAction();
        //var self = this;
        //setTimeout( function () {
        //    self.ask_for_configure_interval = setInterval( function () {
        //        if ( _current_source.phase.current_phase === OBJECT.CONST.PHASE.READY ){
        var _current_params              = SHINKEN.HIGHWAY.getParams();
        _current_params[ 'source-name' ] = source_name;
        _current_params[ 'conf-id' ]     = conf_id;
        window.parent.location.href      = SHINKEN.HIGHWAY.getPath() + SHINKEN.HIGHWAY.buildParamsToUrl( _current_params );
        //        }
        //    }, 300 );
        //}, 100 );
    }
};

window.onpopstate = function ( event ) {
    var _tab_name = SHINKEN.HIGHWAY.getParams( 'tab' );
    if ( _tab_name ) {
        var _parent_window = MANAGER.__instance_window_distributor.findParentWindow( "tab-group" );
        _parent_window.clickOnWindow( _tab_name );
    }
};