'use strict';

COMPONENT.BtnInheritance           = function ( parent_name, dom_element_parent, type_property, is_order_kept ) {
    // parent_name
    // name_template
    // from_template
    // state
    // has_arborescence
    // list_arborescence
    // list_template_property
    // dom_element
    // dom_element_parent
    // dom_container
    // timer_ask_html
    this.init( parent_name, dom_element_parent, type_property );
};
COMPONENT.BtnInheritance.prototype = {
    init: function ( parent_name, dom_element_parent, type_property ) {
        this.parent_name         = parent_name;
        this.state               = COMPONENT.CONST.BTN_STATE.DISABLED;
        this.name_template       = null;
        this.from_template       = null;
        this.dom_element_parent  = dom_element_parent;
        this.dom_container       = null;
        this.dom_container_tbody = null;
        this.has_arborescence    = false;
        this.type_property       = type_property;
    },
    
    buildHTML            : function () {
        this.dom_container = this.dom_element_parent.querySelector( '.from-template' );
        if ( !this.dom_container ) {
            return;
        }
        this.dom_container.innerHTML = '';
        this.dom_element             = DOM.Service.createElement( 'div', {
            class  : 'switch-button-wrapper',
            onclick: 'MANAGER.EventManager.clickOnBtnInheritance("' + this.parent_name + '")'
        } );
        var _btn                     = DOM.Service.createElement( 'div', { class: 'switch-button' } );
        var _on_label                = DOM.Service.createElement( 'span', { class: 'switch-button-label on' }, _( 'element.inheritance_on' ) );
        var _off_label               = DOM.Service.createElement( 'span', { class: 'switch-button-label off' }, _( 'element.inheritance_off' ) );
        
        var _attr_table       = { class: 'table-inheritance' };
        var _attr_col_content = { class: 'col-content' };
        if ( this.has_arborescence ) {
            _attr_table       = { class: 'table-inheritance-with-arborescence' };
            _attr_col_content = { class: 'col-content', colspan: '2', rowspan: '2' };
        }
        
        var table = DOM.Service.createElement( 'table', _attr_table );
        var thead = DOM.Service.createElement( 'thead', {} );
        var tbody = DOM.Service.createElement( 'tbody', { class: 'switch-button-value' } );
        
        var _line_1      = DOM.Service.createElement( 'tr', {} );
        var _col_btn     = DOM.Service.createElement( 'td', { class: 'col-btn', colspan: '2' } );
        var _col_content = DOM.Service.createElement( 'td', _attr_col_content );
        
        DOM.Service.addElementTo( _col_btn, _line_1 );
        DOM.Service.addElementTo( _col_content, _line_1 );
        DOM.Service.addElementTo( _line_1, thead );
        
        if ( this.has_arborescence ) {
            var _line_2       = DOM.Service.createElement( 'tr', { class: 'switch-button-wrapper-line' } );
            var _col_arbo_2_1 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-1 ' } );
            var _col_arbo_2_2 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-2 ' } );
            DOM.Service.addElementTo( _col_arbo_2_1, _line_2 );
            DOM.Service.addElementTo( _col_arbo_2_2, _line_2 );
            DOM.Service.addElementTo( _line_2, thead );
        }
        
        DOM.Service.addElementTo( _btn, this.dom_element );
        DOM.Service.addElementTo( _on_label, _col_content );
        DOM.Service.addElementTo( _off_label, _col_content );
        DOM.Service.addElementTo( this.dom_element, _col_btn );
        
        DOM.Service.addElementTo( thead, table );
        DOM.Service.addElementTo( tbody, table );
        DOM.Service.addElementTo( table, this.dom_container );
        
        this.dom_container_tbody = tbody;
    },
    buildFromTemplateLine: function () {
        this.dom_container_tbody.innerHTML = '';
        
        var _line        = DOM.Service.createElement( 'tr' );
        var _col_content = DOM.Service.createElement( 'td', { class: 'col-content', colspan: '4' } );
        
        
        var _label_text;
        var _label;
        var _id_tpl   = this.list_template_property.template_id;
        var _name_tpl = this.list_template_property.template_name;
        var _selected_prop;
        var _selected;
        var _shinken_element;
        switch ( this.type_property ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                var _tags = this.list_template_property[ 0 ].getTags();
                for ( var i = 0; i < this.list_template_property[ 0 ].size_tags; i++ ) {
                    DOM.Service.addElementTo( _tags[ i ].getDomElement(), _col_content );
                }
                var _clear = DOM.Service.createElement( 'div', { class: 'clear' } );
                DOM.Service.addElementTo( _clear, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                _selected_prop   = MANAGER.__instance_property_distributor.getElement( this.list_template_property[ 0 ].name );
                var _split       = this.list_template_property[ 0 ].value.split( "!" );
                _shinken_element = MANAGER.__instance_element_distributor.getElementByName( _split[ 0 ] );
                _selected        = _selected_prop.getSelector().list_element.getElement( _split[ 0 ] );
                
                _label_text = this.list_template_property[ 0 ].label;
                _label_text = SHINKEN.TOOLS.STRING.uncleanBeforecleanXss(_label_text)
                if ( _shinken_element ) {
                    _label_text = SHINKEN.TOOLS.buildLinkShinkenElement( _shinken_element ).outerHTML;
                    for ( var i = 1, _size_i = _split.length; i < _size_i; i++ ) {
                        _label_text += "!" + SHINKEN.TOOLS.STRING.uncleanBeforecleanXss(_split[ i ]);
                    }
                }
                _label           = DOM.Service.createElement( 'span' );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                _selected_prop = MANAGER.__instance_property_distributor.getElement( this.list_template_property[ 0 ].name );
                _selected      = _selected_prop.getSelector().list_element.getElement( this.list_template_property[ 0 ].value );
                _label_text    = _selected ? _selected.label : SHINKEN.TOOLS.STRING.cleanXss(this.list_template_property[ 0 ].label);
                if ( _selected && _selected.shinken_element ) {
                    _label_text = SHINKEN.TOOLS.buildLinkShinkenElement( _selected.shinken_element ).outerHTML;
                }
                _label           = DOM.Service.createElement( 'span' );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
            case PROPERTY.CONST.TYPES.BOOLEAN:
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
            case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
            case PROPERTY.CONST.TYPES.CHECKBOX_MULTI:
                _label_text      = this.list_template_property[ 0 ].label;
                if ( this.list_template_property[ 0 ].value === PROPERTY.CONST.CUSTOM_SELECT.NONE ){
                    _label_text = _( 'element.forced_default' ) + '(' + _label_text + ')'
                }
                _label           = DOM.Service.createElement( 'span' );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                _label_text = SHINKEN.TOOLS.STRING.uncleanBeforecleanXss(this.list_template_property[ 0 ].value);
                if ( _label_text === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                    _label_text = _( 'element.forced_default' );
                    var _prop   = MANAGER.__instance_property_distributor.getElement( this.list_template_property[ 0 ].name );
                    if ( _prop && _prop.default_value ) {
                        _label_text += " " + _prop.default_value;
                    }
                }
                _label           = DOM.Service.createElement( 'div', { class: "shinken-heritance-value" } );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.DATA:
                if ( this.list_template_property.is_protected ){
                    _label_text = SHINKEN.TOOLS.ENCRYPTION.getDefaultSpanLabel();
                }
                else {
                    _label_text = SHINKEN.TOOLS.STRING.uncleanBeforecleanXss(this.list_template_property.label);
                }
                if ( _label_text === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                    _label_text = _( 'element.forced_default' );
                }
                _label           = DOM.Service.createElement( 'div', { class: "shinken-heritance-value" }, _label_text );
                DOM.Service.addElementTo( _label, _col_content );
                break;
            
        }
        var _template_link = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( shinken_link_tpl, _id_tpl, _name_tpl ).outerHTML;
        var _info          = DOM.Service.createElement( 'span', { class: "shinken-inheritance-template-name" }, '&nbsp;<span class="shinken-between-bracket">' + _( 'source.tag' ) + '&nbsp;' + _template_link + '</span>' );
        DOM.Service.addElementTo( _info, _col_content );
        
        DOM.Service.addElementTo( _col_content, _line );
        DOM.Service.addElementTo( _line, this.dom_container_tbody );
    },
    askUpdateHTML        : function () {
        var self = this;
        if ( this.timer_ask_html ) {
            clearTimeout( this.timer_ask_html );
        }
        this.timer_ask_html = setTimeout( function () {
            self.timer_ask_html = null;
            
            self.updateHTML();
        }, COMPONENT.CONST.BTN_INHERITANCE.TIMER_DELAY_BUILD_HTML );
    },
    updateHTML           : function () {
        if ( !this.isSet() ) {
            if ( this.dom_container ) {
                this.dom_container.innerHTML = '';
                this.dom_container           = null;
            }
            return;
        }
        this.buildHTML();
        
        if ( this.has_arborescence ) {
            this.list_arborescence.buildFromTemplateArbo( this.list_template_property, this.dom_container_tbody );
        }
        else {
            this.buildFromTemplateLine();
        }
    },
    
    setHasArborescence: function ( _to_set ) {
        this.has_arborescence = _to_set;
        if ( _to_set ) {
            this.list_arborescence = new COMPONENT.InheritanceArborescence( this.parent_name, this.dom_element_parent );
        }
    },
    
    getDomElement: function () {
        return this.dom_element;
    },
    
    isSet        : function () {
        return this.state !== COMPONENT.CONST.BTN_STATE.DISABLED;
    },
    getTags      : function () {
        var _to_return = [];
        if ( this.has_arborescence ) {
            var _current;
            var _size = this.list_template_property.length;
            for ( var i = 0; i < _size; i++ ) {
                _current = this.list_template_property[ i ];
                if ( !_current.is_stopped ) {
                    _to_return = _to_return.concat( _current.getTags() );
                }
            }
        }
        else {
            var _template = this.list_template_property[ 0 ];
            _to_return    = _template.getTags();
        }
        return _to_return;
    },
    getState     : function () {
        return this.state;
    },
    setState     : function ( state ) {
        if ( !this.isSet() ) {
            return;
        }
        this.state = state;
        fire_element_is_modifie();
    },
    getValueFinal: function () {
        if ( !this.isSet() ) {
            return "";
        }
        if ( !this.list_template_property || !this.list_template_property[ 0 ] ) {
            return "";
        }
        return this.list_template_property[ 0 ].value;
    },
    
    toggleState: function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                break;
        }
        return this.state;
    },
    
    setTemplateProperty: function ( to_set ) {
        this.list_template_property = to_set;
        
        if ( !this.list_template_property ) {
            this.state = COMPONENT.CONST.BTN_STATE.DISABLED;
            return false;
        }
        
        if ( !this.isSet() ) {
            this.state = COMPONENT.CONST.BTN_STATE.INIT;
        }
        return true;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.BtnInheritance, SHINKEN.OBJECT.ShinkenObject );