//__lib__ lib_external
'use strict';
'use strict';

COMPONENT.ListSelect           = function ( dom_element, parent_name, allow_multiple_select ) {
    // dom_element
    // dom_element_input_research
    // dom_element_counter_research
    // dom_element_research
    // state
    // list
    // list_mapping
    // size_list
    // nbr_in_list_after_filter
    // current_index_auto_select_element;
    // last_auto_select_element;
    // current_filter;
    this.init( dom_element, parent_name, allow_multiple_select );
};
COMPONENT.ListSelect.prototype = {
    init                     : function ( dom_element, parent_name, allow_multiple_select ) {
        allow_multiple_select = !!allow_multiple_select;
        this.dom_element      = dom_element;
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element_counter_research      = dom_element.querySelector( '.shinken-counter-current' );
        this.dom_element_counter_total         = dom_element.querySelector( '.shinken-counter-total' );
        this.dom_element_input_research        = dom_element.querySelector( '.shinken-input-search' );
        this.dom_element_display_research      = dom_element.querySelector( '.shinken-display-search .shinken-value' );
        this.dom_element_select_content        = dom_element.querySelector( '.list-select-content' );
        this.current_index_auto_select_element = COMPONENT.CONST.NOT_FOUND;
        this.state                             = COMPONENT.CONST.BTN_STATE.OFF;
        this.parent_name                       = parent_name;
        this.allow_multiple_select             = allow_multiple_select;
        this.initListElement();
    },
    initListElement          : function () {
        this.list                     = [];
        this.list_mapping             = {};
        this.list_mapping_lower_case  = {};
        this.nbr_in_list_after_filter = 0;
        var _list_element             = this.dom_element.querySelectorAll( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION );
        this.size_list                = _list_element.length;
        for ( var i = 0; i < this.size_list; i++ ) {
            this.list[ i ]                                = new COMPONENT.ListSelectElement( _list_element[ i ] );
            this.list_mapping[ this.list[ i ].getName() ] = i;
            this.list_mapping_lower_case[ this.list[ i ].getName().toLowerCase() ] = i;
        }
    },
    toggleStateSelectedInList: function ( key_name, class_to_add ) {
        var _list_select_element = this.list[ this._getIndexElementInMapping(key_name) ];
        _list_select_element.setSelected( !_list_select_element.is_selected, class_to_add );
        return _list_select_element.getElement();
    },
    unselectAllElement       : function ( extra_class ) {
        var _current;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current = this.list[ i ];
            _current.setSelected( false, extra_class );
        }
    },
    doChangeFilterSelect     : function () {
    
    },
    addNewElementUnknown     : function ( key_name, prop_name ) {
        var _to_add    = DOM.Service.createElement( 'div', {
                class               : COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION,
                "data-state"        : "unknown",
                "data-key-name"     : key_name,
                "data-key-label"    : key_name,
                "data-type"         : "user",
                "data-is-disabled"  : "false",
                "data-force-to-null": "false",
                "data-uuid"         : "",
                onmouseup           : "MANAGER.EventManager.clickOnItemSelector('event','" + prop_name + "', this)"
            },
            "<span class='shinken-space'>" + key_name + " ( " + _( 'element.unknown' ) + " )" + "</span>"
        );
        var _to_return = new COMPONENT.ListSelectElement( _to_add );
        this.addNewElement( key_name, _to_return );
        return _to_return;
    },
    addNewElement            : function ( key_name, list_select_element ) {
        this.list[ this.size_list ]              = list_select_element;
        this.list_mapping[ key_name ]            = this.size_list;
        this.list_mapping_lower_case[ key_name.toLowerCase() ]            = this.size_list;
        this.dom_element_counter_total.innerHTML = parseInt( this.dom_element_counter_total.innerHTML ) + 1;
        this.size_list++;
        this.dom_element_select_content.appendChild( list_select_element.dom_element );
    },
    //***********************************************   GETTER SETTER   ****************************************************//
    _getIndexElementInMapping             : function ( key_name ) {
        if ( !key_name ){
            return;
        }
        var _index = this.list_mapping[ key_name ];
        if ( _index === undefined ) {
            _index = this.list_mapping_lower_case[ key_name.toLowerCase() ];
        }
        return _index;
    },
    getElement                          : function ( key_name ) {
        var _index = this._getIndexElementInMapping(key_name);
        if ( _index === undefined ) {
            return null;
        }
        return this.list[ _index ].getElement();
    },
    getListSelectElement   : function ( key_name ) {
        var _index = this._getIndexElementInMapping(key_name);
        return this.list[ _index ];
    },
    getSelectedElements    : function () {
        var _to_return = [];
        var _current_element;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current_element = this.list[ i ];
            if ( _current_element.is_selected ) {
                _to_return.push( _current_element );
            }
        }
        return _to_return;
    },
    getFirstSelectedElement: function ( exclude_hidden ) {
        var _current_element;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current_element = this.list[ i ];
            if ( _current_element.is_selected ) {
                if ( exclude_hidden && _current_element.dom_element.classList.contains( "shinken-hidden" ) ) {
                    continue;
                }
                return _current_element;
            }
        }
        return null;
    },
    setState               : function ( state ) {
        this.state = state;
        this.setLastAutoSelectElement( false );
        return this.state;
    },
    //***********************************************   TO DEFINE  ****************************************************//
    focusOnResearchInput: function () {
        if ( this.dom_element_input_research ) {
            this.dom_element_input_research.focus();
            if ( this.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.doFilter( this.current_filter );
            }
        }
    },
    setResearchDisplay  : function ( value ) {
        if ( this.dom_element_display_research ) {
            this.dom_element_display_research.innerHTML = value;
        }
    },
    toggleState         : function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                break;
            default:
                console.error( "Error::toggleState is outside its perimeter" );
        }
        return this.state;
    },
    //********************************************  FILTER   *********************************************************//
    doFilter         : function ( filter ) {
        if ( this.current_filter && filter === this.current_filter ) {
            return;
        }
        this.current_filter           = filter;
        this.nbr_in_list_after_filter = 0;
        var _current;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current = this.list[ i ];
            if ( _current.doFilter( filter ) ) {
                this.nbr_in_list_after_filter++;
            }
        }
        if ( filter ) {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT.CLASS.FILTERING_ON );
        }
        else {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT.CLASS.FILTERING_ON );
        }
        if ( this.nbr_in_list_after_filter ) {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT.CLASS.NO_RESULT );
        }
        else {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT.CLASS.NO_RESULT );
        }
        if ( this.dom_element_counter_research ) {
            this.dom_element_counter_research.innerHTML = this.nbr_in_list_after_filter;
        }
        this.setLastAutoSelectElement( false );
        
        //var _first = SHINKEN.TOOLS.ARRAY.findFirstElementWith( this.list, "is_filtered", false );
        //if ( _first ) {
        //    _first.dom_element.scrollIntoView( { behaviour: 'auto' } );
        //}
    },
    cleanFilter      : function () {
        this.dom_element_input_research.value = "";
        this.doFilter( '' );
    },
    addNewElementList: function ( value ) {
        var _to_add = new COMPONENT.ListSelectElement( _list_element[ i ] );
    },
    //********************************************  AUTO SELECT  *****************************************************//
    hasAutoSelect                       : function () {
        return this.current_index_auto_select_element !== COMPONENT.CONST.NOT_FOUND;
    },
    setLastAutoSelectElement            : function ( to_set, action_type, avoid ) {
        if ( to_set ) {
            DOM.ScrollService.bindWith( this.dom_element_select_content, this.list[ this.current_index_auto_select_element ].dom_element, this.previous_position_vertical, action_type );
            this.list[ this.current_index_auto_select_element ].dom_element.classList.add( 'shinken-select-focused' );
        }
        else {
            if ( !avoid ) {
                this.previous_position_vertical = 0;
            }
            if ( this.current_index_auto_select_element !== COMPONENT.CONST.NOT_FOUND ) {
                if ( !avoid ) {
                    this.previous_position_vertical = DOM.Service.getBoundingClientRect( this.list[ this.current_index_auto_select_element ].dom_element, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                }
                this.list[ this.current_index_auto_select_element ].dom_element.classList.remove( 'shinken-select-focused' );
            }
            this.current_index_auto_select_element = COMPONENT.CONST.NOT_FOUND;
        }
    },
    selectSelectedOrFirstFilteredElement: function () {
        if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
            this.updateLastAutoSelectIndex( SHINKEN.TOOLS.ARRAY.findFirstIndexWith( this.list, "is_filtered", false ), COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.KEY_INPUT );
        }
    },
    validAutoSelect                     : function () {
        if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
            return false;
        }
        DOM.Service.SimulateAction.mouseUp( this.list[ this.current_index_auto_select_element ].dom_element );
        this.setLastAutoSelectElement( false );
        return true;
    },
    moveAutoSelectCursor                : function ( move_down ) {
        if ( this.state !== COMPONENT.CONST.BTN_STATE.ON ) {
            return;
        }
        if ( !this.size_list ) {
            return;
        }
        var action_type = move_down ? COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_DOWN : COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_UP;
        var _dom_target = this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ? null : this.list[ this.current_index_auto_select_element ].dom_element;
        
        if ( !DOM.ScrollService.isVisible( this.dom_element_select_content, _dom_target, 0, action_type ) ) {
            var _dom_element;
            if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
                _dom_element = DOM.ScrollService.getFirstVisibleDom( this.dom_element_select_content, ".shinken-option:not(.shinken-hidden):not(.shinken-selected)", move_down );
            }
            else {
                _dom_element = DOM.ScrollService.getCloserVisibleDomFromMiddle( this.dom_element_select_content, ".shinken-option:not(.shinken-hidden):not(.shinken-selected)", move_down );
            }
            if ( _dom_element ) {
                this.previous_position_vertical = DOM.Service.getBoundingClientRect( this.dom_element_select_content, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                this.updateLastAutoSelectIndex( this._getIndexElementInMapping( _dom_element.dataset.keyName ), action_type, true );
            }
            return;
        }
        var _current_counter = this.current_index_auto_select_element;
        var _current;
        var _found           = false;
        
        while ( move_down ? _current_counter < this.size_list : _current_counter >= COMPONENT.CONST.NOT_FOUND ) {
            move_down ? _current_counter++ : _current_counter--;
            _current = this.list[ _current_counter ];
            if ( !_current ) {
                this.updateLastAutoSelectIndex( this.current_index_auto_select_element, action_type );
                continue;
            }
            var _display = DOM.Service.getComputedStyle( _current.dom_element, DOM.CONST.STYLE.DISPLAY );
            if ( _display === DOM.CONST.VALUE.NONE ) {
                continue;
            }
            if ( _current.isSelected() && !this.allow_multiple_select ) {
                continue;
            }
            _found = true;
            break;
        }
        if ( _found ) {
            this.updateLastAutoSelectIndex( _current_counter, action_type );
        }
    },
    updateLastAutoSelectIndex           : function ( index, action_type, avoid ) {
        var _type = "";
        switch ( action_type ) {
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOUSE:
                if ( this.prevent_mouse_enter ) {
                    return;
                }
                break;
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_DOWN:
                _type                    = DOM.CONST.ATTRIBUTE.SCROLL_DOWN;
                this.prevent_mouse_enter = true;
                break;
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_UP:
                this.prevent_mouse_enter = true;
                _type                    = DOM.CONST.ATTRIBUTE.SCROLL_TOP;
                break;
        }
        if ( this.prevent_mouse_enter ) {
            var _self = this;
            if ( this.timeout_mouse_down ) {
                clearTimeout( this.timeout_mouse_down );
            }
            this.timeout_mouse_down = setTimeout( function () {
                _self.prevent_mouse_enter = false;
                _self.timeout_mouse_down  = null;
            }, 200 );
        }
        this.setLastAutoSelectElement( false, _type, avoid );
        this.current_index_auto_select_element = index;
        this.setLastAutoSelectElement( true, _type );
    }
};
