'use strict';

MANAGER.OverrideUnvalidManager           = function () {
    //overrides;
    //size
    //dom_element
};
MANAGER.OverrideUnvalidManager.prototype = {
    init                  : function () {
        if ( this.dom_element ) {
            DOM.Service.removeElement( this.dom_element );
        }
        this.overrides         = {};
        this.size              = 0;
        var _unvalid_overrides = this.findAllUnvalidOverride();
        var _to_add;
        for ( var i = 0, _size_i = _unvalid_overrides.length; i < _size_i; i++ ) {
            _to_add = new OBJECT.ServiceOverrideUnvalid( i, _unvalid_overrides[ i ] );
            this.addOverride( _to_add );
        }
        this.computeSize();
    },
    addOverride           : function ( override_unvalid ) {
        switch ( override_unvalid.type ) {
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.UNLINK:
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.UNLINK_FINAL:
                var _check_name = override_unvalid.getCheckName();
                var _check_name_without_backslash = SHINKEN.TOOLS.STRING.escapeBackslash(_check_name);
                if ( !this.overrides[ _check_name_without_backslash ] ) {
                    this.overrides[ _check_name_without_backslash ] = new OBJECT.ServiceOverrideUnvalids( _check_name );
                    this.overrides[ _check_name_without_backslash ].setType( override_unvalid.type );
                }
                this.overrides[ _check_name_without_backslash ].addUnvalidOverride( override_unvalid );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_CHECK_INACTIVE:
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_TEMPLATE_INACTIVE:
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_TEMPLATE_NOT_USED:
                var _check_uuid = override_unvalid.getCheckUuid();
                if ( !this.overrides[ _check_uuid ] ) {
                    this.overrides[ _check_uuid ] = new OBJECT.ServiceOverrideUnvalids( _check_uuid );
                    this.overrides[ _check_uuid ].setType( override_unvalid.type );
                    this.overrides[ _check_uuid ].setCheck( MANAGER.__instance_element_distributor.getElement( 'core-service-' + _check_uuid ) );
                    this.overrides[ _check_uuid ].setHost( MANAGER.__instance_element_distributor.getElement( 'core-host-' + override_unvalid.getHostUuid() ) );
                }
                this.overrides[ _check_uuid ].addUnvalidOverride( override_unvalid );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_DFE_NOT_PRESENT:
                var _check_uuid = override_unvalid.getCheckUuid();
                var _dfe_key    = override_unvalid.getDfeKey();
                var _key        = _check_uuid + "-" + _dfe_key;
                var _key_without_backslash        = SHINKEN.TOOLS.STRING.escapeBackslash(_key)
                if ( !this.overrides[ _key_without_backslash ] ) {
                    this.overrides[ _key_without_backslash ] = new OBJECT.ServiceOverrideUnvalids( _check_uuid );
                    this.overrides[ _key_without_backslash ].setType( override_unvalid.type );
                    this.overrides[ _key_without_backslash ].setCheck( MANAGER.__instance_element_distributor.getElement( 'core-service-' + _check_uuid ) );
                    this.overrides[ _key_without_backslash ].setHost( MANAGER.__instance_element_distributor.getElement( 'core-host-' + override_unvalid.getHostUuid() ) );
                    this.overrides[ _key_without_backslash ].setDfeKey( _dfe_key );
                }
                this.overrides[ _key_without_backslash ].addUnvalidOverride( override_unvalid );
                break;
        }
    },
    buildHtml             : function () {
        var _to_return = DOM.Service.createElement( "div", { class: "shinken-override-disabled-container" } );
        DOM.Service.addElementTo( this.buildHtmlSeparator(), _to_return );
        var _tobuild = SHINKEN.TOOLS.ARRAY.sortArrayMultiple( SHINKEN.TOOLS.ARRAY.getMapValues( this.overrides ), [ "type", "name" ] );
        for ( var i = 0, _size_i = _tobuild.length; i < _size_i; i++ ) {
            DOM.Service.addElementTo( _tobuild[ i ].buildHtml(), _to_return );
        }
        this.dom_element = _to_return;
        return _to_return;
    },
    buildHtmlSeparator    : function () {
        var _to_return = DOM.Service.createElement( "div", { class: "shinken-separator-override-disabled" } );
        var _text      = _( 'element.override_disabled' );
        var _to_add    = DOM.Service.createElement( "div", { class: "shinken-host-in-page-host-title" }, _text );
        var _hr        = DOM.Service.createElement( "hr", { class: 'shinken-hr-sample' } );
        _to_return.appendChild( _to_add );
        _to_return.appendChild( _hr );
        return _to_return;
    },
    deleteOverride        : function ( type, name ) {
        this.overrides[ name ].delete();
        delete this.overrides[ name ];
        this.computeSize();
        if ( !this.size ) {
            DOM.Service.removeElement( this.dom_element );
        }
        fire_element_is_modifie();
    },
    computeSize           : function ( type, name ) {
        this.size = Object.keys( this.overrides ).length;
        MANAGER.__instance_window_distributor.findWindow( WINDOW.CONST.ELEMENT.CHECKS, false, MANAGER.__instance_element_distributor.current_element.uuid ).setWarning( "unvalid-override-manager", MANAGER.__instance_override_unvalid.size );
        var any_check_message = document.querySelector( '.shinken-any-check-message' );
        if ( any_check_message ) {
            if ( this.size ) {
                any_check_message.classList.remove( 'text-middle' );
            }
            else {
                any_check_message.classList.add( 'text-middle' );
            }
        }
    },
    findAllUnvalidOverride: function () {
        var _to_return = [];
        var _overrides = MANAGER.__instance_element_distributor.current_element.override;
        if ( _overrides ) {
            var _list_host_in_page_host = App.Elements.ChecksTab.getListHostInPageHost();
            var _current;
            var _size_host              = _list_host_in_page_host.length;
            for ( var i = 0, _size = _overrides.overrides.length; i < _size; i++ ) {
                _current               = _overrides.overrides[ i ];
                _current.is_not_linked = true;
                for ( var j = 0; j < _size_host; j++ ) {
                    if ( _list_host_in_page_host[ j ].isOverrideLinkTo( _current ) ) {
                        _current.is_not_linked = false;
                        break;
                    }
                }
                if ( _current.is_not_linked ) {
                    if ( !_current.check_name ) {
                        var _check = MANAGER.__instance_element_distributor.getElement( "core-service-" + _current.check_uuid );
                        if ( _check ) {
                            _current.check_name = _check.getName();
                        }
                        _current.computeCompleteDefinition();
                    }
                    _to_return.push( _current );
                }
            }
        }
        
        var _prop_override = MANAGER.__instance_property_distributor.getAllOverrideProp();
        _prop_override     = SHINKEN.TOOLS.ARRAY.sortArray( _prop_override, "name" );
        for ( var i = 0, _size_override = _prop_override.length; i < _size_override; i++ ) {
            _current = _prop_override[ i ];
            if ( _current.is_not_linked ) {
                _current.complete_definition = 'service_overrides ' + _current.override_check_name + ',' + _current.override_prop_name + ' ' + _current.getDataToSaveFinal();
                _current.check_name          = _current.override_check_name;
                _current.property            = _current.override_prop_name;
                _current.label               = _current.getDataToSaveFinal();
                _to_return.push( _current );
            }
        }
        return _to_return;
    }
};
MANAGER.__instance_override_unvalid      = new MANAGER.OverrideUnvalidManager();