'use strict';

OBJECT.ServiceOverrides           = function ( datas ) {
    //size
    //overrides
    this.datas      = datas;
    this.has_errors = false;
    this.raw_value  = '';
    this.overrides  = [];
    this.size       = 0;
    this.init();
};
OBJECT.ServiceOverrides.prototype = {
    init                        : function () {
        if ( this.datas ) {
            this.error      = this.datas.error;
            this.has_error  = this.datas.has_error;
            this.has_errors = this.datas.has_errors;
            this.raw_value  = this.datas.raw_value;
            this.initOverrideElement();
        }
    },
    initOverrideElement         : function () {
        var _size = this.datas.links.length;
        for ( var i = 0; i < _size; i++ ) {
            this.addOverride( this.datas.links[ i ], this );
        }
    },
    addOverrideByProperty       : function ( property, check_in_page_host, host_in_page_host ) {
        var _override_value = property.getDataToSave();
        if ( !_override_value ) {
            return;
        }
        var _to_add               = new OBJECT.ServiceOverride();
        _to_add.is_check_existing = false;
        _to_add.dfe_key           = check_in_page_host.key_dfe;
        _to_add.check_name        = check_in_page_host.name;
        _to_add.check_uuid        = check_in_page_host.uuid;
        _to_add.check_type        = check_in_page_host.element.getType();
        _to_add.property          = property.override_prop_name;
        if ( _to_add.key === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
            _to_add.key = PROPERTY.CONST.NAME.CHECK_COMMAND_ARGS;
        }
        _to_add.setValue( _override_value );
        _to_add.has_already_been_linked = true;
        _to_add.host_uuid               = host_in_page_host.uuid;
        _to_add.host_type               = MANAGER.__instance_element_distributor.getElement( "core-host-" + host_in_page_host.uuid ).getType();
        _to_add.is_host_existing        = false;
        _to_add.computeCompleteDefinition();
        
        this.overrides.push( _to_add );
        this.size = this.overrides.length;
    },
    addOverride                 : function ( to_add ) {
        var _to_return = new OBJECT.ServiceOverride( to_add );
        this.overrides.push( _to_return );
        this.size = this.overrides.length;
        return _to_return;
    },
    validate                    : function () {
        for ( var i = 0; i < this.size; i++ ) {
            this.overrides[ i ].validate();
        }
    },
    unSetOverrideCheckInPageHost: function ( check_in_page_host ) {
        for ( var i = 0; i < this.size; i++ ) {
            if ( check_in_page_host ) {
                if ( this.overrides[ i ].check_in_page_host && this.overrides[ i ].check_in_page_host.getDomUUID() === check_in_page_host.getDomUUID() ) {
                    this.overrides[ i ].setCheckInPageHost( null );
                }
            }
            else {
                this.overrides[ i ].setCheckInPageHost( null );
            }
        }
    },
    hasOverride                 : function ( check_in_host ) {
        for ( var i = 0; i < this.size; i++ ) {
            if ( this.overrides[ i ].is( check_in_host ) ) {
                return true;
            }
        }
        return false;
    },
    setCheckInPageHostOnOverride: function ( check_in_host ) {
        for ( var i = 0; i < this.size; i++ ) {
            this.overrides[ i ].is( check_in_host );
        }
        return false;
    },
    getOverrideValue            : function ( prop_name, check_in_host ) {
        if ( prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
            prop_name = PROPERTY.CONST.NAME.CHECK_COMMAND_ARGS;
        }
        for ( var i = 0; i < this.size; i++ ) {
            if ( this.overrides[ i ].property === prop_name && this.overrides[ i ].is( check_in_host ) ) {
                return this.overrides[ i ].value;
            }
        }
        return null;
    },
    removeParentCounter         : function ( check_in_host ) {
        for ( var i = 0; i < this.size; i++ ) {
            if ( this.overrides[ i ].is( check_in_host ) ) {
                return this.overrides[ i ].resetCounters();
            }
        }
    },
    hasOverrideModulation       : function ( check_host, property_name ) {
        for ( var i = 0; i < this.size; i++ ) {
            if ( !this.overrides[ i ].is( check_host ) ) {
                continue;
            }
            if ( this.overrides[ i ].property !== property_name ) {
                continue;
            }
            switch ( this.overrides[ i ].value ) {
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                    return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE_FORCED;
                case PROPERTY.CONST.STATE_VALUE_PLUS:
                    return OBJECT.CONST.ELEMENT.MODULATION.TYPE.PLUS;
                default:
                    return OBJECT.CONST.ELEMENT.MODULATION.TYPE.EXISTING;
            }
        }
        return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE;
    },
    cleanOverrideFor            : function ( _check_in_host ) {
        for ( var i = this.size - 1; i >= 0; i-- ) {
            if ( this.overrides[ i ].is( _check_in_host ) ) {
                this.overrides[ i ].resetCounters();
                this.overrides.splice( i, 1 );
            }
        }
        this.size = this.overrides.length;
        return this.size;
    },
    cleanOverride               : function ( override ) {
        for ( var i = this.size - 1; i >= 0; i-- ) {
            if ( this.overrides[ i ] === override ) {
                this.overrides.splice( i, 1 );
                break;
            }
        }
        this.size = this.overrides.length;
    },
    getDataToSave               : function ( override_values ) {
        var _size_override = override_values.length;
        var _current_element;
        var _to_add;
        var _host_element;
        var _current;
        var _to_return     = {};
        
        _to_return.has_errors = this.has_errors;
        _to_return.has_error  = this.has_error;
        _to_return.error      = this.error;
        _to_return.raw_value  = this.raw_value;
        _to_return.links      = [];
        
        for ( var i = 0; i < this.size; i++ ) {
            _current = this.overrides[ i ].getDataToSave();
            if ( _current && _current.check_link && !_current.check_link.exists && !_current.check_link.name ) {
                continue;
            }
            _to_return.links.push( _current );
        }
        
        for ( var i = 0; i < _size_override; i++ ) {
            _current         = override_values[ i ];
            _current_element = MANAGER.__instance_element_distributor.getElement( "core-service-" + _current.override_check_uuid );
            _host_element    = MANAGER.__instance_element_distributor.getElement( "core-host-" + _current_element.host_uuid );
            _to_add          = {};
            _to_add.key      = _current.override_prop_name;
            if ( _current.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
                _to_add.key = PROPERTY.CONST.NAME.CHECK_COMMAND_ARGS;
            }
            _to_add.value                   = _current.getDataToSave();
            _to_add.host_link               = {};
            _to_add.check_link              = {};
            _to_add.host_link.exists        = true;
            _to_add.check_link.exists       = true;
            _to_add.check_link.item_type    = _current_element.type;
            _to_add.check_link._id          = _current_element.getUUID();
            _to_add.check_link.name         = _current.override_check_name;
            _to_add.host_link._id           = _host_element.getUUID();
            _to_add.host_link.item_type     = _host_element.getType();
            _to_add.host_link.name          = _host_element.getName();
            _to_add.has_already_been_linked = true;
            
            if ( _current_element.is_dfe ) {
                _to_add.dfe_key = _current.override_dfe_name;
            }
            
            _to_return.links.push( _to_add );
        }
        if ( !_to_return.links.length ) {
            _to_return = null;
        }
        return _to_return;
    }
};

OBJECT.ServiceOverride           = function ( data ) {
    //check_in_page_host
    //check_type
    //check_uuid
    //check_name
    //host_type
    //host_uuid
    //property
    //value
    //label
    //has_already_been_linked
    this.__class             = "ServiceOverride";
    this.is_check_existing   = false;
    this.is_host_existing    = false;
    this.is_not_linked       = false;
    this.complete_definition = "";
    this.initCounters();
    if ( data ) {
        this.init( data );
    }
};
OBJECT.ServiceOverride.prototype = {
    init                     : function ( data ) {
        this.property = data.key;
        this.setValue( data.value );
        this.setValueWithLink( data.value_with_link );
        this.check_name              = data.check_link.name;
        this.is_check_existing       = data.check_link.exists;
        this.check_uuid              = data.check_link._id;
        this.dfe_key                 = data.dfe_key;
        this.check_type              = data.check_link.item_type;
        this.has_already_been_linked = data.has_already_been_linked || false;
        if ( this.check_uuid ) {
            this.has_already_been_linked = true;
        }
        if ( data.host_link ) {
            this.host_uuid        = data.host_link._id;
            this.host_type        = data.host_link.item_type;
            this.is_host_existing = data.host_link.exists;
        }
        this.computeCompleteDefinition();
    },
    setValue                 : function ( to_set ) {
        this.value          = to_set;
        this.label          = this.value;
        this.label_complete = SHINKEN.TOOLS.STRING.uncleanBeforecleanXss( this.value );
        if ( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( this.property ) ) {
            this.label          = SHINKEN.TOOLS.ENCRYPTION.getDefaultLabel();
            this.label_complete = SHINKEN.TOOLS.ENCRYPTION.getDefaultSpanLabel();
        }
    },
    setValueWithLink         : function ( to_set ) {
        this.value_with_link = to_set;
    },
    getCheckName             : function () {
        if ( !this.check_name && this.check_uuid ) {
            var _element = MANAGER.__instance_element_distributor.getElement( 'core-service-' + this.check_uuid );
            if ( !_element ) {
                return;
            }
            this.check_name = _element.getName();
        }
        if ( this.dfe_key ) {
            return this.check_name.replace( '$KEY$', this.dfe_key );
        }
        return this.check_name;
    },
    setCheckInPageHost       : function ( to_set ) {
        if ( this.check_in_page_host ) {
            this.resetCounters();
            this.old_check_in_page_host = this.check_in_page_host;
        }
        this.check_in_page_host = to_set;
    },
    isOnSame                 : function ( override ) {
        if ( this.check_uuid === override.check_uuid && this.property === override.property ) {
            return true;
        }
        if ( (!this.check_uuid || !override.check_uuid) && this.check_name === override.check_name && this.property === override.property ) {
            return true;
        }
        return false;
    },
    is                       : function ( check_in_host ) {
        var _to_return = false;
        if ( this.check_in_page_host ) {
            return check_in_host.getDomUUID() === this.check_in_page_host.getDomUUID();
        }
        else if ( check_in_host.is_dfe && this.check_name === check_in_host.name && !this.has_already_been_linked ) {
            _to_return = true;
        }
        else if ( this.check_uuid === check_in_host.uuid ) {
            if ( check_in_host.is_dfe ) {
                _to_return = this.dfe_key === check_in_host.key_dfe;
            }
            else {
                _to_return = true;
            }
        }
        else if ( this.check_name && this.check_name === check_in_host.name && !this.has_already_been_linked ) {
            _to_return = true;
        }
        
        this.setCheckInPageHost( _to_return ? check_in_host : null );
        return _to_return;
    },
    findCheck                : function () {
        var _to_return = null;
        if ( this.check_uuid ) {
            _to_return = MANAGER.__instance_element_distributor.getElement( "core-service-" + this.check_uuid );
        }
        else if ( this.host_uuid ) { //DFE CASE, WE MAKE THE BEST WE CAN, BECAUSE WE ARE NOT ABLE TO KNOW WHICH CHECK WE ARE TALKING ABOUT
            var _checks = MANAGER.__instance_element_distributor.getCheckForElement( this.host_uuid );
            for ( var i = 0, _size_i = _checks.length; i < _size_i; i++ ) {
                if ( _checks[ i ].is_dfe ) {
                    _to_return = _checks[ i ];
                    break;
                }
            }
        }
        else if ( this.check_name ) {//CASE OF UNLINK OVERRIDE
            if ( this.check_in_page_host && this.check_in_page_host.name === this.check_name ) {
                _to_return = this.check_in_page_host.element;
            }
            else {
                var _checks = MANAGER.__instance_element_distributor.getAllElementsOfTypeCheck();
                for ( var i = 0, _size_i = _checks.length; i < _size_i; i++ ) {
                    if ( _checks[ i ].getName() === this.check_name ) {
                        _to_return = _checks[ i ];
                        break;
                    }
                }
            }
        }
        return _to_return;
    },
    getDataToSave            : function () {
        var _to_return = {};
        _to_return.key = this.property;
        switch ( this.value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                _to_return.value = this.value;
                break;
            default:
                _to_return.value = this.value_with_link ? this.value_with_link : this.value;
                break;
        }
        
        _to_return.check_link  = {};
        _to_return.host_link   = {};
        this.is_check_existing = !!this.is_check_existing;
        if ( !this.is_check_existing && this.check_in_page_host ) {
            this.is_check_existing = true;
            this.check_uuid        = this.check_in_page_host.element.getUUID();
        }
        _to_return.check_link.exists = this.is_check_existing;
        if ( this.is_check_existing && MANAGER.__instance_element_distributor.getElement( "core-service-" + this.check_uuid ) ) {
            var _check                      = MANAGER.__instance_element_distributor.getElement( "core-service-" + this.check_uuid );
            _to_return.check_link._id       = this.check_uuid;
            _to_return.check_link.item_type = _check.getType();
            _to_return.check_link.name      = _check.getName();
            _to_return.host_link._id        = _check.host_uuid || this.host_uuid;
            _to_return.host_link.item_type  = _check.host_type || this.host_type;
            _to_return.host_link.name       = _check.host_name;
            _to_return.host_link.exists     = true;
            if ( _check.is_dfe ) {
                _to_return.dfe_key         = this.dfe_key;
                _to_return.check_link.name = this.getCheckName();
                if ( this.check_in_page_host ) {
                    _to_return.dfe_key         = this.check_in_page_host.key_dfe;
                    _to_return.check_link.name = this.check_in_page_host.name;
                    if ( this.check_in_page_host.is_obsolete ) {
                        _to_return.check_link.exists = false;
                    }
                }
                else if ( this.old_check_in_page_host ) {
                    _to_return.dfe_key         = this.old_check_in_page_host.key_dfe;
                    _to_return.check_link.name = this.old_check_in_page_host.name;
                }
            }
        }
        else {
            _to_return.check_link.name = this.check_name;
        }
        
        _to_return.has_already_been_linked = this.has_already_been_linked;
        return _to_return;
        
    },
    computeCompleteDefinition: function () {
        this.complete_definition = OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES + SHINKEN.TOOLS.STRING.CONST.NON_BREAK_SPACE +
                                   SHINKEN.TOOLS.STRING.CONST.NON_BREAK_SPACE + this.getCheckName() +
                                   SHINKEN.TOOLS.STRING.CONST.COMMA + SHINKEN.TOOLS.STRING.CONST.WHITE_SPACE +
                                   this.property + SHINKEN.TOOLS.STRING.CONST.WHITE_SPACE + this.label_complete;
    },
    validate                 : function () {
        if ( !this.check_in_page_host ) {
            return;
        }
        if ( !this.check_in_page_host.element.isEnabled() ) {
            return;
        }
        this.getCounterError().setParent( this.check_in_page_host.button_override.getCounterError() );
        this.getCounterWarning().setParent( this.check_in_page_host.button_override.getCounterWarning() );
        switch ( this.value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                return;
        }
        
        var _validator;
        var _current_select;
        var _current_type = PROPERTY.getTypeByName( this.property, this.check_in_page_host.element.getType() );
        switch ( _current_type ) {
            case PROPERTY.CONST.TYPES.DATA:
                var _check = this.findCheck();
                if ( _check && !_check[ this.property ] ) {
                    _validator = new OBJECT.Messages();
                    _validator.addMessage( COMPONENT.CONST.STATUS.WARNING, 'unknown' );
                }
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT :
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN :
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init( { override_prop_name: this.property, is_override: true }, this.value );
                break;
            case PROPERTY.CONST.TYPES.RANGE :
                var _check = this.findCheck();
                if ( _check ) {
                    if ( this.property === PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD ) {
                        var _value_low        = parseInt( this.value );
                        var _value_high_check = MANAGER.__instance_element_distributor.current_element.getOverrideValue( PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD, this.check_in_page_host );
                        if ( !_value_high_check ) {
                            _value_high_check = parseInt( _check[ PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD ] );
                            if ( isNaN( _value_high_check ) ) {
                                return;
                            }
                        }
                        else {
                            _value_high_check = parseInt( _value_high_check );
                        }
                        if ( _value_low > _value_high_check ) {
                            _validator = new OBJECT.Messages();
                            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'bad_flap' );
                        }
                    }
                    else if ( this.property === PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD ) {
                        var _value_high      = parseInt( this.value );
                        var _value_low_check = MANAGER.__instance_element_distributor.current_element.getOverrideValue( PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD, this.check_in_page_host );
                        if ( !_value_low_check ) {
                            _value_low_check = parseInt( _check[ PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD ] );
                            if ( isNaN( _value_low_check ) ) {
                                return;
                            }
                        }
                        else {
                            _value_low_check = parseInt( _value_low_check );
                        }
                        if ( _value_low_check > _value_high ) {
                            _validator = new OBJECT.Messages();
                            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'bad_flap' );
                        }
                    }
                }
                break;
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT :
                var _check = this.findCheck();
                if ( _check ) {
                    if ( this.property === PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD ) {
                        var _value_low        = parseFloat( this.value );
                        var _value_high_check = MANAGER.__instance_element_distributor.current_element.getOverrideValue( PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD, this.check_in_page_host );
                        if ( !_value_high_check ) {
                            _value_high_check = parseFloat( _check[ PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD ] );
                            if ( isNaN( _value_high_check ) ) {
                                return;
                            }
                        }
                        else {
                            _value_high_check = parseFloat( _value_high_check );
                            if ( _value_high_check < 0 ) {
                                _value_high_check = 0;
                            }
                            else if ( _value_high_check > 100 ) {
                                _value_high_check = 100;
                            }
                        }
                        if ( _value_low > _value_high_check ) {
                            _validator = new OBJECT.Messages();
                            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'bad_sla' );
                        }
                    }
                    else if ( this.property === PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD ) {
                        var _value_high      = parseFloat( this.value );
                        var _value_low_check = MANAGER.__instance_element_distributor.current_element.getOverrideValue( PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD, this.check_in_page_host );
                        if ( !_value_low_check ) {
                            _value_low_check = parseFloat( _check[ PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD ] );
                            if ( isNaN( _value_low_check ) ) {
                                return;
                            }
                        }
                        else {
                            _value_low_check = parseFloat( _value_low_check );
                            if ( _value_low_check < 0 ) {
                                _value_low_check = 0;
                            }
                            else if ( _value_low_check > 100 ) {
                                _value_low_check = 100;
                            }
                        }
                        if ( _value_low_check > _value_high ) {
                            _validator = new OBJECT.Messages();
                            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'bad_sla' );
                        }
                    }
                }
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT :
                switch ( this.property ) {
                    case PROPERTY.CONST.NAME.CHECK_PERIOD:
                    case PROPERTY.CONST.NAME.MAINTENANCE_PERIOD:
                    case PROPERTY.CONST.NAME.NOTIFICATION_PERIOD:
                        _current_select = MANAGER.__instance_element_distributor.getElementByName( this.value );
                        _validator      = new OBJECT.Messages();
                        if ( _current_select ) {
                            if ( !_current_select.isEnabled() || _current_select.is_new ) {
                                _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'disabled' );
                            }
                        }
                        else {
                            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'unknown' );
                        }
                }
                break;
            case PROPERTY.CONST.TYPES.MULTI_SELECT :
                var _name_table = "";
                switch ( this.property ) {
                    case PROPERTY.CONST.NAME.CONTACT_GROUPS:
                        _name_table = 'contactgroups';
                        break;
                    case PROPERTY.CONST.NAME.BUSINESS_IMPACT_MODULATIONS:
                        _name_table = 'businessimpactmodulations';
                        break;
                    default:
                        _name_table = this.property;
                }
                _validator  = new OBJECT.Messages();
                var _values = this.value;
                if ( SHINKEN.TOOLS.STRING.startsWith( this.value, PROPERTY.CONST.STATE_VALUE_PLUS.ON ) ) {
                    _values = _values.substr( 1 );
                }
                _values = _values.split( ',' );
                for ( var i = 0, _size_i = _values.length; i < _size_i; i++ ) {
                    _current_select = MANAGER.__instance_element_distributor.getElementByName( _values[ i ] );
                    if ( _current_select ) {
                        if ( !_current_select.isEnabled() || _current_select.is_new ) {
                            _validator.addMessage( COMPONENT.CONST.STATUS.WARNING, 'disabled' );
                        }
                    }
                    else {
                        _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'unknown' );
                    }
                }
                break;
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                switch ( this.property ) {
                    case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                        _validator = this._validateMultiUrl();
                        break;
                }
                break;
        }
        if ( _validator ) {
            if ( _validator.hasError() ) {
                switch ( _current_type ) {
                    case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                    case PROPERTY.CONST.TYPES.MULTI_SELECT:
                        this.setError( this.property, _validator.messages_error.length );
                        break;
                    default:
                        this.setError( this.property, 1 );
                        break;
                }
            }
            else if ( _validator.hasWarning() ) {
                switch ( _current_type ) {
                    case PROPERTY.CONST.TYPES.MULTI_SELECT:
                        this.setWarning( this.property, _validator.messages_warning.length );
                        break;
                    default:
                        this.setWarning( this.property, 1 );
                        break;
                }
            }
        }
        if ( this.is_not_linked ) {
            this.setCheckInPageHost( null );
        }
    },
    _validateMultiUrl        : function () {
        var _lines     = this.value.split( PROPERTY.CONST.NOTES_URL.SEPERATOR.ENTRY );
        var _current;
        var _datas;
        var _validator = new OBJECT.Messages();
        for ( var i = 0, _size = _lines.length; i < _size; i++ ) {
            _current = _lines[ i ];
            _datas   = _current.split( PROPERTY.CONST.NOTES_URL.SEPERATOR.KEY_VALUE );
            SHINKEN.TOOLS.SHINKEN_VALIDATOR._compute_validation( [ PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK ], _datas[ 0 ], _validator );
            SHINKEN.TOOLS.SHINKEN_VALIDATOR._compute_validation( [ PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK_URL, PROPERTY.CONST.VALIDATOR.TYPE.URL ], _datas[ 1 ], _validator );
        }
        return _validator;
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( OBJECT.ServiceOverride, SHINKEN.OBJECT.CounterInterface );
