'use strict';

PROPERTY.MultiSelect           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // default_value
    // type
    // component_btn_inheritance
    // state
    // state_plus
    // state_inheritance
    // inherited_value
    // default_value
    // default_label
    // none_label
    // limit_rest
    // is_limit_reached
    // last_list_element_selected
    // has_everybody_default
    // tab_parent_id
    this.init( dom_element );
};
PROPERTY.MultiSelect.prototype = {
    init: function ( element ) {
        this.initDomElement( element );
        this.initMainSelector();
        if ( this.getName() === PROPERTY.CONST.NAME.USE ){
            this.getSelector().component_input_search.addValidationRule(PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT, COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS);
        }
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, element, this.type );
        this.limit_rest                = 0;
        this.is_limit_reached          = false;
        if ( !this.is_mass_change ) {
            this.component_btn_inheritance.setHasArborescence( this.has_plus );
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnBtnPlus              : function ( event ) {
        if ( this.is_disabled ) {
            return false;
        }
        if ( this.is_mass_change ) {
            this.hidePopup();
            this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].clickOnSelector();
            event.stopPropagation();
            return true;
        }
        var _to_set;
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                _to_set = COMPONENT.CONST.BTN_STATE.OFF;
                break;
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                _to_set = COMPONENT.CONST.BTN_STATE.DISCREET;
                break;
            default:
                this.clickOnItemSelector( PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE, null, this.getSelector() );
                return;
        }
        this.setStatePlus( _to_set );
        this.updateView();
    },
    clickOnAllItemsSelector     : function ( limit ) {
        var _keys = Object.keys( this.getSelector().list_element.list_mapping );
        var _size = _keys.length;
        if ( limit && _size > limit ) {
            _size = limit;
        }
        var _current_key;
        for ( var i = 0; i < _size; i++ ) {
            _current_key = _keys[ i ];
            switch ( _current_key ) {
                case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE:
                case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_OVERRIDE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                    break;
                default:
                    this.clickOnItemSelector( _current_key, null, this.getSelector() );
            }
        }
    },
    cleanAllSelectedElement     : function () {
        var _values = this.getSplitValueUser();
        this.getSelector().cleanAllTags();
        this.getSelector().cleanAllItemsSelected();
        if ( this.is_mass_change && this.synchronized_elements ) {
            for ( var i = 0, _size_i = _values.length; i < _size_i; i++ ) {
                MANAGER.ListenerEventManager.updateSynchronizedTags( this, _values[ i ] );
            }
        }
    },
    ___clickOnItemSelector      : function ( _target_component, key_name ) {
        if ( _target_component !== this.getSelector() ) {
            return;
        }
        this.synchronize_linked_elements = false;
        this.setLastItemSelected( key_name );
        switch ( key_name ) {
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                this.cleanAllSelectedElement();
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                this.cleanAllSelectedElement();
                this.state_plus = COMPONENT.CONST.BTN_STATE.DISCREET;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE:
                this.state_plus = COMPONENT.CONST.BTN_STATE.ON;
                if ( this.is_mass_change ) {
                    this.clickOnItemSelector( "ON", null, this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ] );
                }
                else {
                    this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_OVERRIDE:
                this.state_plus = COMPONENT.CONST.BTN_STATE.ON;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                this.state_plus = COMPONENT.CONST.BTN_STATE.OFF;
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                this.cleanAllSelectedElement();
                this.state_plus = this.is_override ? COMPONENT.CONST.BTN_STATE.DISCREET : COMPONENT.CONST.BTN_STATE.OFF;
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                this.cleanAllSelectedElement();
                this.state_plus = this.is_override ? COMPONENT.CONST.BTN_STATE.DISCREET : COMPONENT.CONST.BTN_STATE.OFF;
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            default:
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        this.cleanAllSelectedElement();
                        this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
                        break;
                }
                if ( PROPERTY.UserRightsBehaviour.hasEverybodyDefault() ) {
                    this.synchronize_linked_elements = true;
                }
                
                this.getSelector().clickOnItemSelector( this.name, key_name, 'shinken-select-no-events' );
                break;
        }
        this.updateView();
        return true;
    },
    clickOnDeleteItemSelector   : function ( key_name, synchronise ) {
        if ( this.is_disabled ) {
            return false;
        }
        this.getSelector().clickOnDeleteItemSelector( key_name );
        var _first_tag_remaining = this.getSelector().getActiveListForUser().getTagByIndex( 0 );
        if ( _first_tag_remaining ) {
            this.setLastItemSelected( _first_tag_remaining.element.name );
        }
        else if ( this.is_mass_change ) {
            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE );
        }
        else if ( this.is_override ) {
            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE );
            this.setStatePlus( COMPONENT.CONST.BTN_STATE.DISCREET );
        }
        else {
            this.setLastItemSelected( this.state_plus === COMPONENT.CONST.BTN_STATE.ON ? PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT );
        }
        if ( this.is_mass_change ) {
            MANAGER.ListenerEventManager.clickOnDeleteItemSelectorMassChange( this, key_name );
        }
        this.updateView();
    },
    specificTreatment           : function () {
        this.is_all_selection_disabled = false;
        var _tag_information_status    = COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE;
        var _name                      = this.is_override ? this.override_prop_name : this.name;
        switch ( _name ) {
            case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
            case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
            case PROPERTY.CONST.NAME.BUSINESS_IMPACT_MODULATIONS:
            case PROPERTY.CONST.NAME.ESCALATIONS:
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
                if ( this.hasInvalidElementForProduction() ) {
                    _tag_information_status = COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER;
                }
                break;
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                var _is_all_disabled = this.isAllElementsSelectedDisabled();
                if ( PROPERTY.UserRightsBehaviour.hasEverybodyDefault() ) {
                    if ( this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ||
                         this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.NONE ||
                         this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED ||
                         _is_all_disabled ) {
                        if ( _is_all_disabled ) {
                            this.is_all_selection_disabled = true;
                        }
                        var _property_group = MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS );
                        if ( _property_group.getValueAndValueInherited() && _property_group.getValueAndValueInherited() !== PROPERTY.CONST.STATE_VALUE_PLUS.ON ) {
                            this.tag_information.setStatus( COMPONENT.CONST.TAG_INFORMATION.STATUS.USER_GROUP_COHERENCY );
                            return;
                        }
                        else if ( _is_all_disabled ) {
                            this.tag_information.setStatus( COMPONENT.CONST.TAG_INFORMATION.STATUS.ALL_DISABLED );
                            return;
                        }
                    }
                }
                break;
            case PROPERTY.CONST.NAME.PARENTS:
                var _tags_inherited = this.getSelector().list_elements_inherited.tags;
                var _size           = _tags_inherited.length;
                var _current;
                var _current_name;
                if ( this.state_inheritance ) {
                    for ( var i = 0; i < _size; i++ ) {
                        _current      = _tags_inherited[ i ];
                        _current_name = _current.getName();
                        if ( _current_name === MANAGER.__instance_element_distributor.current_element.getName() ) {
                            _current.addClass( 'tag-error' );
                            _current.setMessageTooltip( _( 'element.tooltip_infinity_loop' ) );
                            _current.setState( COMPONENT.CONST.TAG.STATE.UNKNOWN );
                        }
                    }
                }
                if ( this.hasInvalidElementForProduction() ) {
                    _tag_information_status = COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER;
                }
                break;
        }
        this.tag_information.setStatus( _tag_information_status );
    },
    updateAllTemplatesCustomTags: function ( templates_properties ) {
        if ( !templates_properties ) {
            return;
        }
        var _size = templates_properties.length;
        var _current;
        var _current_tag;
        var _size_tags;
        for ( var i = 0; i < _size; i++ ) {
            _current   = templates_properties[ i ];
            _size_tags = _current.tags.length;
            for ( var j = 0; j < _size_tags; j++ ) {
                _current_tag = _current.tags[ j ];
                if ( _current_tag.isDefaultTag() ) {
                    _current_tag.updateTagWithNoneTags( this.default_label );
                }
                else if ( _current_tag.isNullTag() ) {
                    _current_tag.updateTagWithNoneTags( this.none_label );
                }
            }
        }
        
    },
    updateWithTemplateSpecific  : function () {
        if ( this.component_btn_inheritance.isSet() ) {
            this.getSelector().updateWithTemplateSpecific( this.component_btn_inheritance.getTags() );
        }
        this.updateView();
    },
    clickOnBtnInheritance       : function () {
        if ( !this.component_btn_inheritance.isSet() ) {
            return;
        }
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                this.setStateInheritance( false );
                break;
            default:
                this.setStateInheritance( true );
                break;
        }
        if ( this.state_inheritance ) {
            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE );
        }
        else {
            if ( this.getSelector().list_element_selected.hasUserTag() ) {
                var _last_element_selected = this.getSelector().list_element.getFirstSelectedElement();
                this.setLastItemSelected( _last_element_selected.element.name );
            }
            else {
                this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
            }
        }
        this.updateView();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    //********************************************  SETTER GETTER   **************************************************//
    setStatePlus                   : function ( to_set ) {
        this.state_plus = to_set;
    },
    getValueInherited              : function () {
        return this.getSelector().list_elements_inherited.getValue();
    },
    getValueAndValueInherited      : function () {
        var _to_return;
        var _value     = "";
        var _inherited = "";
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                _value     = this.getValue();
                _inherited = this.getValueInherited();
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                _inherited = this.getValueInherited();
                break;
            default :
                _value = this.getValue();
                break;
        }
        _to_return = _value;
        if ( _value && _inherited ) {
            _to_return += ',';
        }
        _to_return += _inherited;
        return _to_return;
    },
    isSetOrIsSetFromTemplate       : function () {
        if ( this.getSelector().isSet() ) {
            return true;
        }
        if ( this.component_btn_inheritance.state !== COMPONENT.CONST.BTN_STATE.ON ) {
            return false;
        }
        return this.getSelector().list_elements_inherited.hasUserTag();
    },
    setValueFromUser               : function ( value ) {
        this.clickOnItemSelector( PROPERTY.CONST.CUSTOM_SELECT.NONE, null, this.getSelector() );
        if ( !value ) {
            if ( this.is_mass_change ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
            }
            else if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            }
        }
        
        if ( SHINKEN.TOOLS.STRING.startsWith( value, PROPERTY.CONST.STATE_VALUE_PLUS.ON ) ) {
            value = value.substr( 1 );
            this.clickOnBtnPlus();
        }
        var _values = value.split( ',' );
        for ( var i = 0, _size = _values.length; i < _size; i++ ) {
            this.clickOnItemSelector( _values[ i ], null, this.getSelector() );
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    isAllElementsSelectedDisabled  : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                return this.getSelector().isAllElementsSelectedDisabled();
        }
        return false;
    },
    hasInvalidElementForProduction : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                return this.getSelector().hasInvalidElementForProduction();
        }
        return false;
    },
    ___updateView                  : function () {
        this._computeState();
        this.specificTreatment();
        this._computeLimitReached();
        this._computeLabelSelect();
        this.checkErrorWarning();
    },
    finalActionAfterOverrideLoading: function () {
        if ( !this.is_override ) {
            return;
        }
        var _check          = MANAGER.__instance_element_distributor.getElement( "core-service-" + this.override_check_uuid );
        var _value_on_check = _check.getValuesSplitted( this.override_prop_name );
        var _tag;
        var _current;
        for ( var i = 0, _size_i = _value_on_check.length; i < _size_i; i++ ) {
            _current = _value_on_check[ i ];
            _current = this.getSelector().list_element.getElement( _current );
            switch ( _current.name ) {
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                    this.dom_element.querySelector( '.shinken-value-from-check' ).appendChild( DOM.Service.createElement( 'span', {}, _current.getLabel() ) );
                    break;
                default:
                    _tag = new COMPONENT.Tag();
                    _tag.setElement( _current );
                    _tag.buildHTML();
                    this.dom_element.querySelector( '.shinken-value-from-check' ).appendChild( DOM.Service.createElement( 'div', { class: 'droppable' }, _tag.dom_element.outerHTML ) );
            }
        }
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance: function () {
        if ( this.state ) {
            return;
        }
        if ( this.is_not_heritable ) {
            return;
        }
        if ( this.state_plus === COMPONENT.CONST.BTN_STATE.ON ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
            return;
        }
        var _is_set = this.getSelector().isSet();
        if ( _is_set ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        else {
            switch ( this.custom_selected ) {
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                    this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
                    break;
                default:
                    this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
    },
    _computeState         : function () {
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        var _to_set            = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE : PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                _to_set = this.is_mass_change ? PROPERTY.CONST.STATE_PROPERTY.USER_SET : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                if ( this.is_override ) {
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                _to_set = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE:
                if ( !this.state_plus && !this.getSelector().isSet() ) {
                    _to_set                         = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    this.last_list_element_selected = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                _to_set     = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
                switch ( _action ) {
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                        if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue() !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ||
                             this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValue() !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                            _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                            if ( this.has_plus ) {
                                if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue() !== PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE ) {
                                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER;
                                }
                            }
                        }
                        else if ( this.has_plus ) {
                            if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue() !== PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE ) {
                                _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET_MASS_CHANGE_PLUS_ONLY;
                            }
                        }
                        break;
                    default:
                        if ( this.has_plus ) {
                            if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue() !== PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE ) {
                                _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET_MASS_CHANGE_PLUS_ONLY;
                            }
                        }
                }
                break;
        }
        if ( this.state_plus === COMPONENT.CONST.BTN_STATE.ON ) {
            _to_set = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER;
        }
        this.setState( _to_set );
    },
    _computeLabelSelect   : function () {
        //if ( this.is_disabled ) {
        //    return;
        //}
        //if ( this.is_override ) {
        //    return;
        //}
        var _title_to_set = _( 'element.selected_values' );
        var _element_list;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                if ( this.component_btn_inheritance.isSet() ) {
                    var _inherited_tag = this.component_btn_inheritance.getTags()[ 0 ];
                    switch ( _inherited_tag.getName() ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            _element_list = this.getSelector().list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.NONE );
                            _title_to_set = this._computeInheritedLabelHtml( this.component_btn_inheritance.list_template_property[ 0 ].template_name, _element_list.getLabel() );
                            break;
                        default:
                            _element_list = this.getSelector().list_element.getElement( this.last_list_element_selected );
                            _title_to_set = _element_list.getLabel();
                            break;
                    }
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                _element_list = this.getSelector().list_element.getElement( this.last_list_element_selected );
                _title_to_set = _element_list.getLabel();
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                if ( this.component_btn_inheritance.isSet() ) {
                    this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE );
                }
                _element_list = this.getSelector().list_element.getElement( this.last_list_element_selected );
                _title_to_set = _element_list.getLabel();
                break;
        }
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER ) {
            _element_list = this.getSelector().list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE );
            _title_to_set = _element_list.getLabel();
        }
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS ) {
            _element_list = this.getSelector().list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_OVERRIDE );
            _title_to_set = _element_list.getLabel();
        }
        if ( this.is_all_selection_disabled ) {
            if ( this.is_override ) {
                _title_to_set = "<span>" + _( 'element.in_check' ) + "</span>&nbsp;&nbsp;" + "<span class='shinken-only-disabled-tags'>" + _( 'element.selected_values_disabled' ) + "</span>";
            }
            else {
                _title_to_set = "<span>" + _( 'element.default' ) + "<span class='shinken-between-bracket shinken-default-label'>" + this.none_label + "</span></span>&nbsp;&nbsp;" + "<span class='shinken-only-disabled-tags'>" + _( 'element.selected_values_disabled' ) + "</span>";
            }
        }
        _title_to_set = '<span class="shinken-multiselect-title">' + _title_to_set + '</span>';
        if ( this.is_limit_reached ) {
            var _title_option = ' ( ' + _( 'element.maximum_of' ) + ' ' + this.getSelector().getMaximumSelected() + ' ' + _( 'element.reached' ) + ' )';
            _title_to_set += DOM.Service.createElement( 'span', {}, _title_option ).outerHTML;
            this.dom_element.classList.add( 'behavior-limit' );
        }
        else {
            this.dom_element.classList.remove( 'behavior-limit' );
        }
        this.getSelector().setTitle( _title_to_set );
    },
    _computeLimitReached  : function () {
        if ( !this.getSelector().getMaximumSelected() ) {
            return;
        }
        var limit = -1;
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                limit = this.getSelector().isLimitReached();
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                limit = this.getSelector().isLimitReachedForSelected();
                break;
        }
        
        this.limit_rest       = limit;
        this.is_limit_reached = limit >= 0;
        this.getSelector().disabledTagsOutOfLimit( this.limit_rest );
    },
    //************************************************  INHERITANCE **************************************************//
    setStateInheritanceSpecific: function () {
        if ( this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.OFF ) {
            this.setStatePlus( COMPONENT.CONST.BTN_STATE.OFF );
            if ( this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE && this.component_btn_inheritance.isSet() ) {
                this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
            }
        }
    },
    cleanBeforeUpdate          : function () {
        this.getSelector().list_elements_inherited.emptyList();
    },
    //********************************************  SYNCHRONIZATION **************************************************//
    updateSynchronizedList: function ( property_synchro ) {
        if ( this.synchronized_elements[ property_synchro.getName() ] ) {
            MANAGER.ListenerEventManager._synchronizeMassChangesSelectorAfterSynchro( this, property_synchro, this.synchronized_elements[ property_synchro.getName() ], true );
        }
        this.synchronized_elements[ property_synchro.getName() ] = SHINKEN.TOOLS.ARRAY.clone( property_synchro.getSelector().getActiveListForUser().getTags() );
        MANAGER.ListenerEventManager._synchronizeMassChangesSelectorAfterSynchro( this, property_synchro, this.synchronized_elements[ property_synchro.getName() ], false );
    },
    synchronizeAtMinimum          : function ( property ) {
        if ( this.is_mass_change ) {
            return;
        }
        switch ( property.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE:
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_OVERRIDE:
                this.clickOnItemSelector( property.last_list_element_selected, null, this.getSelector() );
                return;
        }
        if ( property.state_plus === COMPONENT.CONST.BTN_STATE.ON && this.state_plus === COMPONENT.CONST.BTN_STATE.OFF ) {
            this.clickOnBtnPlus();
        }
        if ( property.state_inheritance && property.component_btn_inheritance.isSet() && !this.state_inheritance ) {
            if ( this.getSelector().isSet() ) {
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                        break;
                    default:
                        if ( this.component_btn_inheritance.isSet() ) {
                            this.clickOnBtnPlus();
                        }
                        break;
                }
            }
            else {
                this.clickOnBtnInheritance();
            }
        }
        PROPERTY.UserRightsBehaviour.addMissing( this, property );
    },
    synchronizeAtMaximum: function ( property ) {
        if ( this.is_mass_change ) {
        }
        switch ( property.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                this.clickOnItemSelector( property.last_list_element_selected, null, this.getSelector() );
                return;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                this.clickOnItemSelector( this.component_btn_inheritance.isSet() ? property.last_list_element_selected : PROPERTY.CONST.CUSTOM_SELECT.NONE, null, this.getSelector() );
            return;
        }

        var _missing       = SHINKEN.TOOLS.STRING.splitMultiselectValueWithNoPlus( this.getFlatValue() );
        var _value_present = SHINKEN.TOOLS.STRING.splitMultiselectValueWithNoPlus( property.getFlatValue() );
        _missing           = SHINKEN.TOOLS.ARRAY.concatUniqueIfNotPresentIn( [], _missing, _value_present );
        for ( var i = 0, _size_i = _missing.length; i < _size_i; i++ ) {
            PROPERTY.UserRightsBehaviour.addValueTo( property, _missing[ i ] );
        }
        switch ( property.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                if ( this.state_plus === COMPONENT.CONST.BTN_STATE.ON ) {
                    this.clickOnBtnPlus();
                }
                break;
        }
        
    },
    //********************************************  DRAGGING *********************************************************//
    resetDragging   : function () {
        fire_element_is_modifie();
        this.dom_element.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.DRAGGING );
        this.getSelector().resetDragging();
        if ( this.name === PROPERTY.CONST.NAME.USE ) {
            MANAGER.ListenerEventManager.afterActionGlobal( this );
        }
    },
    dragStartShinken: function ( type_element, key_name ) {
        this.dom_element.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.DRAGGING );
        switch ( type_element ) {
            case PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM:
                return this.getSelector().dragStartShinken( type_element, key_name );
        }
    },
    //********************************************  SPECIFIC   ******************************************************//
    addTagWithFilterName: function () {
        var _name = SHINKEN.TOOLS.STRING.removeXss( this.getSelector().list_element.current_filter );
        _name     = SHINKEN.TOOLS.STRING.trim( _name );
        if ( !_name ) {
            return;
        }
        var _element = this.getSelector().validOrCreateTag( _name, this.name );
        if ( _element.is_selected ) {
            console.warn( "[already selected]", _element );
        }
        else {
            this.clickOnItemSelector( _element.getName(), null, this.getSelector() );
            MANAGER.ListenerEventManager.askAfterActionProperty( this );
        }
        this.getSelector().pulsateTag( _element.getName() );
        this.getSelector().list_element.current_filter = "";
        this.hidePopup();
        this.getSelector().cleanFilter();
    },
    //********************************************  SAVE     *********************************************************//
    getSplitValueUser : function () {
        return this.getValue().split( ',' );
    },
    getDataToSaveFinal: function () {
        var _to_return = {};
        if ( this.is_mass_change && this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
            return PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
        }
        _to_return.links = this.getSelector().getValueToSave();
        if ( !this.is_mass_change ) {
            _to_return.has_plus = (this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER || this.state === PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS);
        }
        return _to_return;
    },
    getDataToSave     : function () {
        if ( this.is_mass_change ) {
            return this.getDataToSaveMassChange();
        }
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return "";
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return PROPERTY.CONST.DEFAULT_TO_LINK;
        }
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                return PROPERTY.CONST.NONE_TO_LINK;
        }
        return this.getDataToSaveFinal();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.MultiSelect, PROPERTY.InterfaceSelect );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.MultiSelect, PROPERTY.Interface );