'use strict';

PROPERTY.SingleSelect           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // inherited_value
    // custom_selected
    // type
    // component_select
    // component_btn_default
    // component_btn_inheritance
    // state
    // state_inheritance
    // tab_parent_id
    this.init( dom_element );
};
PROPERTY.SingleSelect.prototype = {
    init                  : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.initMainSelector();
        this.component_btn_inheritance                 = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.getSelector().buildLinkOpenNewTab( this.item_type, this.link_id );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    computeErrorsSpecifics: function ( force_mass_change ) {
    },
    setErrorsSpecific     : function () {
        var _selected_element;
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                break;
            default:
                _selected_element = this.getSelector().getLastSelectedElement();
                break;
        }
        if ( _selected_element ) {
            this.counter_temp_error = _selected_element.element.getError();
        }
    
        if ( this.getSelector().getLastSelectedElement() && this.getSelector().getLastSelectedElement().getElement().is_lock ) {
            this.tag_information.setParams(this.getSelector().getLastSelectedElement().getElement().error_message)
            this.tag_information.setStatus( COMPONENT.CONST.TAG_INFORMATION.STATUS.LOCKED );
        }
        else {
            this.tag_information.setStatus( this.counter_temp_error ? COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER : COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE );
        }
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance: function () {
        var _value        = this.getSelector().getValue();
        var _is_inherited = (this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE && !_value);
        
        if ( _is_inherited ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
        else {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
    },
    _computeState         : function () {
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        var _to_set            = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE : PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                _to_set = this.is_mass_change? PROPERTY.CONST.STATE_PROPERTY.USER_SET: PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                if ( this.is_override ){
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                _to_set = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                break;
        }
        this.setState( _to_set );
        this._computeLabelSelect();
    },
    //********************************************  GET / SET    **********************************************************//
    setValueFromUser      : function ( value ) {
        if ( !value ) {
            if ( this.is_mass_change ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
            }
            else if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            }
        }
        this.clickOnItemSelector( value, null, this.getSelector() );
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    getValueInherited     : function () {
        return this.component_btn_inheritance.getValueFinal();
    },
    //getSelectViaDomElement: function ( dom_element ) {
    //    var _dom_target = DOM.Service.findParentElementWithClass( dom_element, "shinken-select-container", 20 );
    //    if ( !_dom_target || _dom_target.dataset.name === "main-selector" ) {
    //        return this.component_select;
    //    } else if ( _dom_target.dataset.name === "mass_change_action" ) {
    //        return this.component_select_action_mass_change;
    //    } else {
    //        console.warn("GREG", "[]", "[TO DEV]" );
    //    }
    //},
    
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal: function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : "";
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
        }
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                return this.last_list_element_selected;
        }
        if ( !this.link_id ) {
            return this.getSelector().getValue();
        }
        var _to_return      = {};
        _to_return.links    = [ this.getSelector().getValueToSave() ];
        _to_return.has_plus = false;
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelect, PROPERTY.InterfaceSelect );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelect, PROPERTY.Interface );