//priority 25
App.Elements.DataTab = (function ( self ) {
    "use strict";
    var _dom_element_navigation;
    var _dom_element_content_parent;
    var _dom_element_content;
    var __modified_property_data;
    var _current_group_uuid;
    
    var __group_datas = [];
    
    
    
    self.init = function () {
        if ( !MANAGER.__instance_element_distributor.current_element.has_data ) {
            return;
        }
        _initInstance();
        _createLocalData();
        _createTemplatesData();
        _createDFEData();
        
        var _all_datas = MANAGER.__instance_property_distributor.getAllDatasSorted();
        _all_datas     = SHINKEN.TOOLS.ARRAY.sortArrayMultiple( _all_datas, ['group_data_uuid', 'name'] );
        _computeNavigationHTML( _all_datas );
        self.computeDatasHTML( _all_datas );
        self.clickOnDataNavigation( __group_datas[ 0 ].uuid );
    };
    
    self.reset                      = function () {
        __modified_property_data = [];
        var _datas               = MANAGER.__instance_property_distributor.getAllDatasSorted();
        var _current;
        if ( _datas ) {
            for ( var i = 0, _size_data = _datas.length; i < _size_data; i++ ) {
                _current = _datas[ i ];
                if ( _current.component_input.hasBeenChanged() ) {
                    __modified_property_data[ _current.name ] = _current;
                }
                _current.delete();
            }
        }
        var _size_group_data = __group_datas.length;
        for ( var i = 0; i < _size_group_data; i++ ) {
            _current = __group_datas[ i ];
            DOM.Service.removeElement( _current.dom_element );
        }
        __group_datas = [];
    };
    self.clickOnDataNavigation      = function ( group_uuid ) {
        _current_group_uuid = group_uuid;
        self.filterDataDisplayed();
        self.setActiveGroup();
    };
    self.setActiveGroup             = function () {
        var _current;
        var _size = __group_datas.length;
        for ( var i = 0; i < _size; i++ ) {
            _current = __group_datas[ i ];
            if ( _current.uuid === _current_group_uuid ) {
                _current.dom_element.classList.add( "shinken-active" );
                if ( _current.type === PROPERTY.CONST.DATA.GROUP.DFE ) {
                    _dom_element_content_parent.classList.add( 'shinken-data-is-dfe-view' );
                    _dom_element_content_parent.classList.add( 'shinken-collapse' );
                    _dom_element_content_parent.classList.remove( 'shinken-not-collapse' );
                    self.changeAllDataCollapsing( true );
                }
                else {
                    _dom_element_content_parent.classList.remove( 'shinken-data-is-dfe-view' );
                }
            }
            else {
                _current.dom_element.classList.remove( "shinken-active" );
            }
        }
    };
    self.getGroupWithName           = function ( group_name ) {
        var _current;
        var _size = __group_datas.length;
        for ( var i = 0; i < _size; i++ ) {
            _current = __group_datas[ i ];
            if ( _current[ 'group_name' ] === group_name ) {
                return _current;
            }
        }
        return null;
    };
    self.toggleCollapseButtonGlobal = function () {
        var _is_collapse = _dom_element_content_parent.classList.contains( 'shinken-collapse' );
        if ( _is_collapse ) {
            _dom_element_content_parent.classList.add( 'shinken-not-collapse' );
            _dom_element_content_parent.classList.remove( 'shinken-collapse' );
        }
        else {
            _dom_element_content_parent.classList.add( 'shinken-collapse' );
            _dom_element_content_parent.classList.remove( 'shinken-not-collapse' );
        }
        self.changeAllDataCollapsing( !_is_collapse );
    };
    self.changeAllDataCollapsing    = function ( _is_collapse ) {
        var _datas = MANAGER.__instance_property_distributor.getAllDatasSorted();
        var _size  = _datas.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( _datas[ i ].group_data && _datas[ i ].group_data.uuid === _current_group_uuid ) {
                _datas[ i ].setCollapseCheck( _is_collapse );
            }
        }
    };
    self.toggleCollapseButton       = function ( dom_element ) {
        var _is_collapse = dom_element.classList.contains( 'shinken-collapse' );
        if ( _is_collapse ) {
            dom_element.classList.add( 'shinken-not-collapse' );
            dom_element.classList.remove( 'shinken-collapse' );
        }
        else {
            dom_element.classList.add( 'shinken-collapse' );
            dom_element.classList.remove( 'shinken-not-collapse' );
        }
    };
    self.filterDataDisplayed        = function () {
        var _current;
        var _datas          = MANAGER.__instance_property_distributor.getAllDatasSorted();
        var _size_displayed = 0;
        for ( var i = 0, _size = _datas.length; i < _size; i++ ) {
            _current = _datas[ i ];
            if ( _current.is_override ) {
                continue;
            }
            if ( _current.group_data.uuid === _current_group_uuid ) {
                _current.dom_element.classList.remove( 'shinken-hidden' );
                _current.updateView();
                _size_displayed++;
            }
            else {
                _current.dom_element.classList.add( 'shinken-hidden' );
            }
        }
        if ( !_size_displayed ) {
            _dom_element_content_parent.classList.add( 'shinken-no-data-found' );
        }
        else {
            _dom_element_content_parent.classList.remove( 'shinken-no-data-found' );
        }
    };
    
    var _initInstance = function () {
        _dom_element_navigation     = document.getElementById( 'shinken-data-tab-nav' );
        _dom_element_content        = document.getElementById( 'shinken-data-tab-content' );
        _dom_element_content_parent = document.getElementById( 'data-tab-content' );
    };
    
    var _createDFEData         = function () {
        var _current;
        var _current_check;
        var _current_dfe_name;
        var _current_label;
        var _element_use = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE );
        if ( !_element_use ) { //??
            return;
        }
        var _all_template_used = MANAGER.__instance_element_distributor.list_templates.list_template_computed;
        for ( var i = 0, _size_i = _all_template_used.length + 1; i < _size_i; i++ ) {
            if ( !i ) {
                _current       = MANAGER.__instance_element_distributor.current_element;
                _current_label = "";
            }
            else {
                _current       = _all_template_used[ i - 1 ];
                _current_label = _current.getName();
            }
            if ( !_current.size_dfe_check ) {
                continue;
            }
            
            var _group_data = new WINDOW.DataGroup( PROPERTY.CONST.DATA.GROUP.DFE, _current_label );
            __group_datas.push( _group_data );
            
            for ( var j = 0, _size_j = _current.checks.length; j < _size_j; j++ ) {
                _current_check = _current.checks[ j ];
                if ( _current_check.is_enabled === false || _current_check.is_enabled === "0" ) {
                    continue;
                }
                if ( !_current_check.is_dfe ) {
                    continue;
                }
                _current_dfe_name = _current_check[ PROPERTY.CONST.NAME.DUPLICATE_FOREACH_NAME ];
                var _to_add       = new PROPERTY.Data( _current_dfe_name, MANAGER.__instance_element_distributor.current_element[ _current_dfe_name ], _group_data );
                if ( !_to_add.is_valid ) {
                    continue;
                }
                var _existing = MANAGER.__instance_property_distributor.getDataWithName( _current_dfe_name );
                if ( _existing ) {
                    _existing.setGroupData( _group_data );
                    _to_add.setInheritedData( _existing.inherited_data );
                    if ( _existing.modified_value_before_prop_use_modification ) {
                        _to_add.modified_value_before_prop_use_modification = _existing.modified_value_before_prop_use_modification;
                    }
                }
                else {
                    MANAGER.__instance_property_distributor.setElement( _to_add.uuid, _to_add );
                }
            }
        }
    };
    var _createLocalData       = function () {
        var _group_data = new WINDOW.DataGroup( PROPERTY.CONST.DATA.GROUP.LOCALE );
        __group_datas.push( _group_data );
        var _datas = MANAGER.__instance_element_distributor.current_element.getAllData();
        var _keys  = Object.keys( _datas );
        var _to_add;
        var _current_key;
        var _size  = _keys.length;
        for ( var i = 0; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _to_add      = new PROPERTY.Data( _current_key, _datas[ _current_key ], _group_data );
            if ( !_to_add.is_valid ) {
                continue;
            }
            MANAGER.__instance_property_distributor.setElement( _to_add.uuid, _to_add );
            if ( __modified_property_data[ _current_key ] ) {
                _to_add.modified_value_before_prop_use_modification = __modified_property_data[ _current_key ].component_input.current_value;
                delete __modified_property_data[ _current_key ];
            }
        }
        var _keys = Object.keys( __modified_property_data );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( __modified_property_data[ _keys[ i ] ].status === PROPERTY.CONST.DATA.STATUS.NEW ) {
                _to_add = __modified_property_data[ _keys[ i ] ];
                _to_add.setGroupData( _group_data );
                _to_add.modified_value_before_prop_use_modification = _to_add.component_input.current_value;
            }
            else {
                _to_add                                             = new PROPERTY.Data( __modified_property_data[ _keys[ i ] ].name, '', _group_data );
                _to_add.modified_value_before_prop_use_modification = __modified_property_data[ _keys[ i ] ].component_input.current_value;
            }
            MANAGER.__instance_property_distributor.setElement( _to_add.uuid, _to_add );
        }
    };
    var _createTemplatesData   = function () {
        for ( var i = 0; i < MANAGER.__instance_element_distributor.list_templates.size_computed; i++ ) {
            _createTemplateData( MANAGER.__instance_element_distributor.list_templates.list_template_computed[ i ] );
        }
    };
    var _createTemplateData    = function ( template ) {
        var _current_key;
        var _current_data;
        var _group_data = new WINDOW.DataGroup( PROPERTY.CONST.DATA.GROUP.INHERITED, template.name );
        __group_datas.push( _group_data );
        var _keys = Object.keys( template.datas );
        var _size = _keys.length;
        for ( var i = 0; i < _size; i++ ) {
            _current_key  = _keys[ i ];
            _current_data = template.datas[ _current_key ];
            if ( !_current_data.data.is_valid ) {
                continue;
            }
            var _existing = MANAGER.__instance_property_distributor.getDataWithName( _current_key );
            
            if ( _existing ) {
                if ( !_existing.isLocalData() ) {
                    continue;
                }
                else {
                    _existing.setGroupData( _group_data );
                    _existing.setInheritedData( _current_data );
                }
            }
            else {
                _current_data.data.setGroupData( _group_data );
                _current_data.data.setInheritedData( _current_data );
                _current_data.data.setValue( "" );
                MANAGER.__instance_property_distributor.setElement( _current_data.data.uuid, _current_data.data );
            }
            
        }
        
    };
    var _computeNavigationHTML = function ( datas ) {
        var _current;
        var _size = __group_datas.length;
        
        var dom_template = document.getElementById( 'data-li-title-templates' );
        var dom_dfe      = document.getElementById( 'data-li-title-foreach-dfe' );
        dom_template.classList.add( 'shinken-hidden' );
        dom_dfe.classList.add( 'shinken-hidden' );
        
        for ( var i = 0; i < _size; i++ ) {
            _current = __group_datas[ i ];
            //self.computeSizeForGroup( _current, datas );
            switch ( _current.type ) {
                case PROPERTY.CONST.DATA.GROUP.LOCALE:
                    _dom_element_navigation.insertBefore( _current.buildHTMLNav(), dom_template );
                    break;
                case PROPERTY.CONST.DATA.GROUP.INHERITED:
                    dom_template.classList.remove( 'shinken-hidden' );
                    _dom_element_navigation.insertBefore( _current.buildHTMLNav(), dom_dfe );
                    break;
                default:
                    dom_dfe.classList.remove( 'shinken-hidden' );
                    _dom_element_navigation.appendChild( _current.buildHTMLNav() );
            }
            _current.initCountersDom();
        }
    };
    self.computeDatasHTML      = function ( all_datas ) {
        var _size = all_datas.length;
        for ( var i = 0; i < _size; i++ ) {
            all_datas[ i ].init();
            _dom_element_content.appendChild( all_datas[ i ].dom_element );
        }
    };
    
    self.addNewData = function () {
        var __group_data = __group_datas[ 0 ];
        var _name        = PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL;
        var _to_add      = new PROPERTY.Data( _name, "", __group_data );
        _to_add.init();
        _to_add.setStatus( PROPERTY.CONST.DATA.STATUS.NEW );
        _dom_element_content.insertBefore( _to_add.dom_element, _dom_element_content.firstChild );
        MANAGER.__instance_property_distributor.setElement( _to_add.uuid, _to_add );
        self.clickOnDataNavigation( __group_data.uuid );
        return _to_add;
    };
    
    
    
    self.getCheckCandidate = function ( template ) {
        var _to_return;
        var _index_template = -1;
        if ( template.uuid === MANAGER.__instance_element_distributor.current_element.uuid ) {
            _to_return = MANAGER.__instance_element_distributor.current_element.checks;
        }
        else {
            _to_return      = template.checks;
            _index_template = MANAGER.__instance_element_distributor.list_templates.getIndexForCompute( template );
        }
        var _current_template;
        for ( var i = _index_template + 1; i < MANAGER.__instance_element_distributor.list_templates.size_computed; i++ ) {
            _current_template = MANAGER.__instance_element_distributor.list_templates.list_template_computed[ i ];
            for ( var j = 0, _size_j = _current_template.checks.length; j < _size_j; j++ ) {
                _to_return.push( _current_template.checks[ j ] );
            }
        }
        return _to_return;
    };
    
    
    return self;
    
})( App.Elements.DataTab || {} );

