'use strict';

SOURCE.SourceProperty           = function ( key ) {
    this.list_dom_element;
    this.previous_value = "";
    this.value          = "";
    this.label          = "";
    this.key            = key;
};
SOURCE.SourceProperty.prototype = {
    updateValue      : function ( to_set ) {
        if ( to_set === this.value ) {
            return;
        }
        switch ( this.key ) {
            case SOURCE.CONST.RANGE.NAME:
                if ( to_set === this.value ) {
                    return;
                }
                this.previous_value = this.value;
                this.value = to_set;
                this.label = SHINKEN.TOOLS.STRING.cleanXss(to_set);
                break;
            case SOURCE.CONST.RANGE.STATE:
            case SOURCE.CONST.RANGE.SOURCE_NAME:
            case SOURCE.CONST.FIELD.STATE:
                if ( to_set === this.value ) {
                    return;
                }
                this.previous_value = this.value;
            case SOURCE.CONST.FIELD.ORDER:
            case SOURCE.CONST.FIELD.ENABLED:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_OK:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR:
            case SOURCE.CONST.FIELD.OUTPUT:
            case SOURCE.CONST.RANGE.DESCRIPTION:
            case SOURCE.CONST.RANGE.IP_RANGE:
            case SOURCE.CONST.RANGE.ENABLED:
                this.value = to_set;
                this.label = to_set;
                break;
            
            case SOURCE.CONST.FIELD.NEXT_IMPORT:
                this.value = to_set;
                if ( this.value === -1 ) {
                    this.label = "";
                }
                else {
                    this.label = DATE_TIME.durationToString( to_set * 1000, true, 1 );
                }
                break;
            case SOURCE.CONST.FIELD.LAST_IMPORT:
                this.value = to_set;
                this.label = DATE_TIME.durationToString( to_set * 1000, true, 1 );
                break;
        }
        this.updateDomElements();
    },
    updateDomElements: function () {
        if ( !this.list_dom_element ) {
            return;
        }
        var _size = this.list_dom_element.length;
        if ( !_size ) {
            console.warn( "[DOM NOT READY] Source Property", this.value );
            return;
        }
        for ( var i = 0; i < _size; i++ ) {
            this.updateDomElement( this.list_dom_element[ i ] );
        }
        
    },
    updateDomElement : function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        switch ( this.key ) {
            case SOURCE.CONST.FIELD.ENABLED:
                dom_element.classList.remove( this.value ? 'is-not-active' : 'is-active' );
                dom_element.classList.add( this.value ? 'is-active' : 'is-not-active' );
                break;
            case SOURCE.CONST.FIELD.STATE:
                DOM.Service.setDataSet( dom_element, 'state', this.value );
                if ( this.label === SOURCE.CONST.STATE.NOT_CONFIGURED ) {
                    dom_element.classList.remove( 'is-configured' );
                    dom_element.classList.add( 'is-not-configured' );
                }
                else {
                    dom_element.classList.remove( 'is-not-configured' );
                    dom_element.classList.add( 'is-configured' );
                }
                
                break;
            case SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING:
                dom_element.innerHTML = this.label;
                dom_element           = this.getParentElement( dom_element );
                if ( this.value === 0 ) {
                    dom_element.classList.remove( 'shinken-element-in-warning' );
                }
                else {
                    dom_element.classList.add( 'shinken-element-in-warning' );
                }
                break;
            
            case SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR:
                dom_element.innerHTML = this.label;
                dom_element           = this.getParentElement( dom_element );
                if ( this.value === 0 ) {
                    dom_element.classList.remove( 'shinken-element-in-error' );
                }
                else {
                    dom_element.classList.add( 'shinken-element-in-error' );
                }
                break;
            
            case SOURCE.CONST.FIELD.ORDER:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_OK:
            case SOURCE.CONST.FIELD.OUTPUT:
            case SOURCE.CONST.FIELD.LAST_IMPORT:
            case SOURCE.CONST.FIELD.NEXT_IMPORT:
            case SOURCE.CONST.RANGE.NAME:
            case SOURCE.CONST.RANGE.IP_RANGE:
            case SOURCE.CONST.RANGE.DESCRIPTION:
                dom_element.innerHTML = this.label;
                break;
            
            case SOURCE.CONST.RANGE.ENABLED:
                dom_element.classList.remove( this.value ? 'conf-disabled' : 'conf-enabled' );
                dom_element.classList.add( this.value ? 'conf-enabled' : 'conf-disabled' );
                break;
            
            //default:
            //    console.warn( "[SourceProperties]", "[setData]", "[IGNORED DATA]", "[" + this.key + "]", value );
        }
        
    },
    getDomSelector   : function ( is_single_display ) {
        switch ( this.key ) {
            case SOURCE.CONST.FIELD.ORDER:
                return '.column-order .shinken-line-number';
            case SOURCE.CONST.FIELD.STATE:
            case SOURCE.CONST.RANGE.ENABLED:
            case SOURCE.CONST.FIELD.ENABLED:
                return ''; //WE TAKE THE PARENT
            case SOURCE.CONST.FIELD.NEXT_IMPORT:
                return '.column-next-import .next-import-content';
            case SOURCE.CONST.FIELD.NB_ELEMENTS_OK:
                return '.column-nb-elements .nb-elements-content .shinken-nb-elements-ok';
            case SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING:
                return '.column-nb-elements .nb-elements-content .shinken-nb-elements-warning';
            case SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR:
                return '.column-nb-elements .nb-elements-content .shinken-nb-elements-error';
            case SOURCE.CONST.FIELD.OUTPUT:
                return is_single_display ? '.shinken-source-summary-output-container' : '.column-output .output-content';
            case SOURCE.CONST.FIELD.LAST_IMPORT:
                return '.column-last-import .last-import-content';
            case SOURCE.CONST.RANGE.NAME:
                return '.line-discovery .discovery-name a';
            case SOURCE.CONST.RANGE.DESCRIPTION:
                return '.line-discovery .discovery-note .content';
            case SOURCE.CONST.RANGE.IP_RANGE:
                return '.line-discovery .discovery-ip_range .content';
        }
        
    },
    getParentElement : function ( dom_element ) {
        switch ( this.key ) {
            case SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING:
            case SOURCE.CONST.FIELD.STATE:
                return dom_element.parentNode.parentNode;
            
            default:
                return dom_element.parentNode;
        }
    },
    loadDomElements  : function ( parent_dom_elements, size, is_single_display ) {
        var _selector = this.getDomSelector( is_single_display );
        if ( !_selector ) {
            this.list_dom_element = parent_dom_elements;
        }
        else if ( size && parent_dom_elements ) {
            this.list_dom_element = [];
            for ( var i = 0; i < size; i++ ) {
                this.list_dom_element[ i ] = parent_dom_elements[ i ].querySelector( _selector );
            }
            if ( this.key === SOURCE.CONST.FIELD.OUTPUT && is_single_display){
                this.list_dom_element.push(parent_dom_elements[0].querySelector( '.shinken-source-summary-output-container-inport-in-progress' ));
            }
        }
        var self = this;
        setTimeout( function () { //NORMALEMENT PAS NECESSAIRE
            if ( !self.list_dom_element ) {
                console.warn( "[reload dom element 2 ]", self.key );
                self.loadDomElements(parent_dom_elements, size, is_single_display);
            }
        }, 1000 );
    }
};