SHINKEN.TOOLS.ENCRYPTION = (function ( self ) {
    "use strict";
    self.default_label;
    self.getDefaultSpanLabel                   = function () {
        var _to_return = DOM.Service.createElement( "span", { class: 'shinken-encrypted-label shinken-between-parathensis' }, self.getDefaultLabel() );
        return _to_return.outerHTML;
    };
    self.getDefaultLabel                       = function () {
        if ( !self.default_label ) {
            self.default_label = _( 'element.password_protected' );
        }
        return self.default_label;
    };
    self.getLabelHidden                        = function () {
        return '**************';
    };
    self.getProtectedKeys                      = function () {
        return protect_fields__substrings_matching_fields;
    };
    self.isDatabaseEncryptionActivated         = function () {
        return protect_fields__activate_interface_encryption;
    };
    self.isProtectedFieldsAreViewableByAdminSi = function () {
        return protect_fields__are_viewable_by_admin_si;
    };
    self.isProtectedFieldsActivated            = function () {
        if ( this.isDatabaseEncryptionActivated() ) {
            return true;
        }
        if ( !MANAGER.__instance_element_distributor.current_user.is_admin && !self.isProtectedFieldsAreViewableByAdminSi() ) {
            return true;
        }
        return false;
    };
    self.isProtectedField                      = function ( field_label ) {
        if ( !self.isDatabaseEncryptionActivated() && MANAGER.__instance_element_distributor.current_user.is_admin ) {
            return false;
        }
        if ( !field_label ) {
            return false;
        }
        var _protected_fields = self.getProtectedKeys();
        var _size             = _protected_fields.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = _protected_fields[ i ];
            if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( field_label, _current ) ) {
                return true;
            }
        }
        return false;
    };
    self.isProtectedProperty                   = function ( field_label ) {
        if ( !self.isDatabaseEncryptionActivated() ) {
            return false;
        }
        switch ( field_label ) {
            case PROPERTY.CONST.NAME.PASSWORD:
                return true;
        }
        return false;
    };
    return self;
})( SHINKEN.TOOLS.ENCRYPTION || {} );
