/**
 * Copyright (C) 2013-2018:
 * This file is part of Shinken Enterprise, all rights reserved.
 **/

var SHINKEN_RETURN_CODE = {};
SHINKEN_RETURN_CODE.DELETE = {};
SHINKEN_RETURN_CODE.DELETE.OK = 'DELETE_OK';
SHINKEN_RETURN_CODE.DELETE.PROTECTED = 'DELETE_PROTECTED';
SHINKEN_RETURN_CODE.DELETE.OWN_USER = 'DELETE_OWN_USER';
SHINKEN_RETURN_CODE.DELETE.UNKNOWN = 'UNKNOWN';

var must_save_in_work_area = false;
var prev_action            = '';

var ACTION_DELETE_WORKING_AREA_ENTRY = 'delete_working_area_entry';
var ACTION_DELETE_ENTRY              = 'delete_entry';
var ACTION_SAVE_WORKING_AREA_ENTRY   = 'save_working_area_entry';
var ACTION_SAVE_ENTRY                = 'save_entry';
var ACTION_SUBMIT_TO_STAGGING        = 'submit_to_stagging';
var ACTION_SAVE_NEW_ELEMENT          = 'create_new_element';
var ACTION_APPLY_DIFFERENCE          = 'apply_difference';
var ACTION_APPLY_WORK_AREA           = 'apply_work_area';
var ACTION_APPLY_DELETE_WORK_AREA    = 'apply_delete_work_area';
var ACTION_REJECT_WORK_AREA          = 'reject_work_area';
var ACTION_UNLOCK_WORK_AREA          = 'unlock_work_area';

function go_next_page ( next_page ) {
    location.assign( next_page );
}

function validate_pending () {
    // with_change, submit_to_stagging
    submit_form( false, false );
}

function is_blank ( str ) {
    return (!str || /^\s*$/.test( str ));
}

function delete_ui_entry ( is_discovery ) {
    var bypass_work_area        = MANAGER.WorkFlowManager.getState();
    var but_we_bypass_work_area = false;
    if ( bypass_work_area === MANAGER.CONST.STATE.WORK_FLOW.STAGING ) {
        but_we_bypass_work_area = true;
    }
    
    // We do not want to be prompt when we will exit the page, as we are ok to save
    
    if ( confirm( _( 'element.sure' ) ) ) {
        disable_page_off_warning();
        if ( is_discovery ) {
            submit_delete_discovery_form();
        }
        else if ( must_save_in_work_area && !but_we_bypass_work_area ) {
            // We do not want to be prompt when we will exit the page, as we are ok to save
            really_delete_working_area_entry();
            MANAGER.__instance_loading.showLoading( _( 'element.delete_in_progress' ) );
        }
        else {
            really_delete_staging_entry();
            MANAGER.__instance_loading.showLoading( _( 'element.delete_in_progress' ) );
        }
    }
}

function fire_element_is_modifie () {
    if ( !MANAGER.__instance_loading.isReady() ) {
        return;
    }
    if ( MANAGER.__instance_element_distributor.current_element.phase === OBJECT.CONST.ELEMENT.PHASE.INIT ) {
        return;
    }
    if ( MANAGER.__instance_element_distributor.current_element.phase === OBJECT.CONST.ELEMENT.PHASE.EDITING ) {
        return;
    }
    MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.EDITING );
    
    is_edit_mode_on = true;
    $( "#element-btn-save" ).removeClass( "hide" );
    $( "#id-shinken-btn-save" ).removeClass( "shinken-disabled" );
    $( "#element-btn-submit-to-stagging" ).removeClass( "hide" );
    $( "#element-btn-unlock-work-area" ).removeClass( "hide" );
    $( "#element-btn-cancel  > a > span" ).html( _( 'element.cancel' ) );
    $( "#empty-separator" ).addClass( "hide" );
    if ( $( "#left-column" ).data( 'type' ) === "hosts" ) {
        $( "#right-column" ).addClass( "working-area" );
        $( ".working-area-banner" ).removeClass( "hidden" );
        $( ".staging-area-banner" ).addClass( "hidden" );
    }
    hide_saving_log();
    // We calculate the size of the left panel.
    $( window ).trigger( 'resize' );
}

function mapping ( prev_action, is_admin, item_type, item_id, has_item_in_staging ) {
    //console.log( "mapping with [" + prev_action + "] [" + is_admin + "] [" + item_type + "] [" + item_id + "] [" + has_item_in_staging + "]" );
    var _previous_url;
    var _get_path;
    switch ( prev_action ) {
        case ACTION_DELETE_WORKING_AREA_ENTRY:
            SHINKEN.HIGHWAY.removeItemIdFromHistory( item_id );
            _previous_url = App.HistoryManager.getUrl( 0 );
            if ( _previous_url ) {
                return "go_next_page('" + _previous_url + "');";
            }
            else if ( is_admin && has_item_in_staging ) {
                return "go_next_page('/elements/working_area/" + item_type + "/" + item_id + "');";
            }
            return "go_next_page('/elements/working_area/" + item_type + "');";
            break;
        case ACTION_DELETE_ENTRY:
            SHINKEN.HIGHWAY.removeItemIdFromHistory( item_id );
            _previous_url = App.HistoryManager.getUrl( 0 );
            if ( SHINKEN.TOOLS && SHINKEN.TOOLS.TEST_AUTO ){
                SHINKEN.HIGHWAY.refreshCurrentPage();
                return;
            }
            if ( _previous_url ) {
                return "go_next_page('" + _previous_url + "');";
            }
            return "go_next_page('/elements/" + item_type + "');";
            break;
        case ACTION_SAVE_WORKING_AREA_ENTRY:
            App.HistoryManager.rollback();
            _get_path = SHINKEN.HIGHWAY.getParams();
            if ( _get_path[ 'tab' ] === 'changes' ) {
                delete _get_path[ 'tab' ];
            }
            if ( _get_path[ 'new' ] ) {
                delete _get_path[ 'new' ];
            }
            return "go_next_page('/elements/working_area/" + item_type + "/" + item_id + SHINKEN.HIGHWAY.buildParamsToUrl( _get_path ) + "');";
        case ACTION_SAVE_NEW_ELEMENT:
        case ACTION_APPLY_DIFFERENCE:
            App.HistoryManager.rollback();
        case ACTION_SAVE_ENTRY:
            _get_path = SHINKEN.HIGHWAY.getParams();
            if ( _get_path[ 'new' ] ) {
                delete _get_path[ 'new' ];
            }
            return "go_next_page('/elements/" + item_type + "/" + item_id + SHINKEN.HIGHWAY.buildParamsToUrl( _get_path ) + "');";
        case ACTION_SUBMIT_TO_STAGGING:
            if ( is_admin ) {
                return "go_next_page('/elements/" + item_type + "/" + item_id + "');";
            }
            return "go_next_page('/elements/working_area/" + item_type + "/" + item_id + "');";
        case ACTION_APPLY_WORK_AREA:
            return "go_next_page('/elements/" + item_type + "/" + item_id + "');";
        case ACTION_APPLY_DELETE_WORK_AREA:
            return "go_next_page('/elements/" + item_type + "');";
        case ACTION_REJECT_WORK_AREA:
            return "go_next_page('/elements/working_area/" + item_type + "/" + item_id + "');";
        case ACTION_UNLOCK_WORK_AREA:
            if ( has_item_in_staging ) {
                return "go_next_page('/elements/" + item_type + "/" + item_id + "');";
            }
            return "go_next_page('/elements/working_area/" + item_type + "');";
        default:
            return "go_next_page('/elements/" + item_type + "');";
        
    }
}

function shinken_toggle_change_diff_state ( key ) {
    if ( shinken_property_changes_list[ key ] ) {
        shinken_property_changes_list[ key ] = false;
        document.getElementById( 'tr-change-' + key ).classList.add( "shinken-is-disabled" );
    }
    else {
        shinken_property_changes_list[ key ] = true;
        document.getElementById( 'tr-change-' + key ).classList.remove( "shinken-is-disabled" );
    }
}

//********************************************  GENERAL     *********************************************************//
function getCurrentObjectFromPropertyMassChange ( masschange_modification ) {
    //TODO A CHANGER
    MANAGER.__instance_property_distributor.indexElementByDisplay();
    var _to_return = getCurrentObjectFromProperty();
    if ( masschange_modification === CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_OVERRIDE && _to_return[ PROPERTY.CONST.NAME.CHECK_COMMAND ] ) {
        _to_return[ PROPERTY.CONST.NAME.CHECK_COMMAND_ARGS ] = _to_return[ PROPERTY.CONST.NAME.CHECK_COMMAND ];
        delete _to_return[ PROPERTY.CONST.NAME.CHECK_COMMAND ];
    }
    return _to_return;
}

function getCurrentObjectFromProperty ( with_change, submit_comment ) {
    var _item      = {};
    _item[ '_id' ] = MANAGER.__instance_element_distributor.current_element.getUUID();
    
    //TODO DOIT ÊTRE MIS DANS LE DISTRIBUTOR MANAGER
    
    var _elements = MANAGER.__instance_property_distributor.getAllElements();
    var _current_name;
    var _current_value;
    
    var _override_values = [];
    for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
        _current       = _elements[ i ];
        _current_value = _current.getDataToSave();
        if ( _current_value ) {
            if ( _current.is_override ) {
                _override_values.push( _current );
            }
            else {
                _item[ _current.getName() ] = _current_value;
            }
        }
    }
    //TODO DOIT ÊTRE MIS DANS LE DISTRIBUTOR MANAGER
    var _size_override   = _override_values.length;
    var _current;
    var _shinken_element = MANAGER.__instance_element_distributor.current_element;
    
    
    if ( !_shinken_element.override && _size_override ) { //PAS D'existant mais on en rajoute
        _shinken_element.override = new OBJECT.ServiceOverrides();
    }
    if ( _shinken_element.override && (_shinken_element.override.size || _size_override) ) { //existant aprés tout la gestion??
        _item[ OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES ] = _shinken_element.override.getDataToSave( _override_values );
        if ( _item[ OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES ] === null ) {
            delete _item[ OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES ];
        }
    }
    if ( _shinken_element.exclude && _shinken_element.exclude.size ) {
        _item[ OBJECT.CONST.ELEMENT.FIELD.SERVICE_EXCLUDES_BY_ID ] = _shinken_element.exclude.getDataToSave();
    }
    if ( submit_comment ) {
        _item[ '__COMMENT__' ] = submit_comment;
    }
    
    //TODO DOIT ÊTRE MIS DANS LE DISTRIBUTOR MANAGER
    if ( with_change ) {
        var _keys = Object.keys( shinken_property_changes_list );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            if ( shinken_property_changes_list[ _current_key ] ) {
                var new_value = $( '#change-input-' + _current_key ).val();
                if ( new_value === "" ) {
                    delete _item[ _current_key ];
                }
                else {
                    if ( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( _current_key ) ) {
                        _item[ _current_key ] = SHINKEN.TOOLS.STRING.b64Encode( 'protected_field_value_from_changes' );
                    }
                    else {
                        _item[ _current_key ] = new_value;
                    }
                }
            }
        }
    }
    return _item;
}

function get_current_object ( with_change, submit_comment ) {
    var res                                                = {};
    res[ 'protect_fields__substrings_matching_fields' ]    = JSON.stringify( SHINKEN.TOOLS.ENCRYPTION.getProtectedKeys() );
    res[ 'protect_fields__activate_interface_encryption' ] = SHINKEN.TOOLS.ENCRYPTION.isDatabaseEncryptionActivated();
    res[ 'protect_fields__are_viewable_by_admin_si' ]      = SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsAreViewableByAdminSi();
    res[ 'item' ]                                          = JSON.stringify( getCurrentObjectFromProperty( with_change, submit_comment ) );
    return res;
}

function submit_form ( with_change, submit_to_stagging, comment_txt, is_discovery ) {
    MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.ON_SAVING );
    
    hide_saving_log();
    disable_page_off_warning();
    // Get defaul params
    if ( typeof (with_change) === 'undefined' ) {
        with_change = false;
    }
    if ( typeof (submit_to_stagging) === 'undefined' ) {
        submit_to_stagging = false;
    }
    if ( typeof (comment_txt) === 'undefined' ) {
        comment_txt = '';
    }
    var f         = document.forms[ 'form-element' ];
    var item_type = f.dataset.type;
    var _id       = MANAGER.__instance_element_distributor.current_element.getUUID();
    var item_dump = get_current_object( with_change, comment_txt );
    
    if ( is_discovery ) {
        delete item_dump[ "protect_fields__activate_interface_encryption" ];
        delete item_dump[ "protect_fields__substrings_matching_fields" ];
        delete item_dump[ "protect_fields__are_viewable_by_admin_si" ];
        $.post( '/sources/' + SOURCE_NAME + '/discovery/save/', item_dump ).success( form_success_network_range ).error( form_errors_network_range );
        return;
    }
    
    var bypass_work_area = MANAGER.WorkFlowManager.getState();
    var params_list      = [];
    var params_string    = "";
    
    if ( bypass_work_area === MANAGER.CONST.STATE.WORK_FLOW.STAGING && MANAGER.__instance_element_distributor.current_user.is_admin ) {
        params_list.push( "bypass_work_area=1" );
    }
    
    if ( item_is_new ) {
        params_list.push( "pending=1" );
    }
    
    if ( with_change ) {
        params_list.push( 'with_change=1' );
    }
    if ( MANAGER.__instance_element_distributor.current_element.is_creation ) {
        params_list.push( 'in_creation=1' );
    }
    
    if ( MANAGER.__instance_element_distributor.current_element.is_creation ||
         MANAGER.__instance_element_distributor.current_element.is_new ) {
        prev_action = ACTION_SAVE_NEW_ELEMENT;
    }
    else if ( with_change ) {
        prev_action = ACTION_APPLY_DIFFERENCE;
    }
    else {
        prev_action = ACTION_SAVE_ENTRY;
    }
    
    
    //console.log( 'Clean Dump data to send' + dump( item_dump ) );
    if ( (!MANAGER.__instance_element_distributor.current_user.is_admin && item_type === "hosts") || bypass_work_area !== MANAGER.CONST.STATE.WORK_FLOW.STAGING && must_save_in_work_area === true ) {
        prev_action = ACTION_SAVE_WORKING_AREA_ENTRY;
        if ( submit_to_stagging ) {
            prev_action = ACTION_SUBMIT_TO_STAGGING;
            MANAGER.__instance_loading.showLoading( _( 'element.submit_to_stagging_in_progress' ) );
            params_list.push( 'submit_to_stagging=1' );
        }
        else {
            MANAGER.__instance_loading.showLoading( _( 'element.save_in_progress' ) );
        }
        if ( params_list.length > 0 ) {
            params_string = '?' + params_list.join( "&" );
        }
        $.post( '/element/q/' + item_type + '/save_in_work_area/' + _id + params_string, item_dump ).success( form_success ).error( form_error );
    }
    else {
        if ( params_list.length > 0 ) {
            params_string = '?' + params_list.join( "&" );
        }
        MANAGER.__instance_loading.showLoading( _( 'element.save_in_progress' ) );
        $.post( '/element/q/' + item_type + '/save/' + _id + params_string, item_dump ).success( form_success ).error( form_error );
    }
}

function disable_page_off_warning () {
    is_edit_mode_on = false;
    $( "#element-btn-cancel > a > span" ).html( _( 'element.back' ) );
    $( "#empty-separator" ).addClass( "hide" );
}

//********************************************  ELEMENT     *********************************************************//
function form_success ( data ) {
    var current_time        = new Date();
    var f                   = document.forms[ 'form-element' ];
    var item_type           = f.dataset[ 'type' ];
    var item_id             = MANAGER.__instance_element_distributor.current_element.getUUID();
    var has_item_in_staging = data[ 'has_item_in_staging' ] === true;
    var has_changes         = data[ 'has_changes' ] === true;
    var has_critical        = data[ 'has_critical' ] === true;
    var has_error           = data[ 'has_error' ] === true;
    var was_reject          = data[ 'was_reject' ] === true;
    var message             = [];
    var msg                 = {};
    
    MANAGER.__instance_loading.removeLoading();
    if ( data.rc === COMMUNICATION.CODE.WARNING ) {
        // Maybe the backend is not happy, but only warn us
        message = data.text + ' ' + _( 'element.object_saved' ) + ' ' + _( 'element.at' ) + ' ' + DATE_TIME.FORMAT.getTime( current_time, DATE_TIME.FORMAT.TIME.HH_MM ) + '.';
        
        if ( has_changes ) {
            message += data[ 'message_has_changes' ];
        }
        
        
        msg = {
            'type'         : has_critical || has_error ? COMMUNICATION.MESSAGE.ERROR : COMMUNICATION.MESSAGE.WARNING,
            'is_persistent': true,
            'title'        : message,
            'log_class'    : 'shinken-saving-log-content'
        };
        MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.SAVING_FAILED );
        sessionStorage.setItem( KEY_SESSION_STORAGE_SAVING_LOG_MSG, JSON.stringify( msg ) );
        setTimeout( mapping( prev_action, MANAGER.__instance_element_distributor.current_user.is_admin, item_type, item_id, has_item_in_staging ) );
    }
    else if ( data.rc !== COMMUNICATION.CODE.SUCCESS ) {
        MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.SAVING_FAILED );
        // Maybe the backend is not happy for something and doesn't want to save data
        
        show_saving_log( data.text, '', 'shinken-saving-log-content', true );
        SHINKEN.DOM.remove_class_for( '.btn', 'disabled' );
    }
    else {
        MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.RELOADING );
        // Ok no error, let's go!
        if ( data.shinken_return_code === SHINKEN_RETURN_CODE.DELETE.OK || was_reject ) {
            message[ 0 ] = data.text;
        }
        else {
            message[ 0 ] = data.text + ' ' + _( 'element.object_saved' ) + ' ' + _( 'element.at' ) + ' ' + DATE_TIME.FORMAT.getTime( current_time, DATE_TIME.FORMAT.TIME.HH_MM ) + '.';
        }
        if ( has_changes ) {
            message += data[ 'message_has_changes' ];
        }
        msg = {
            'type'         : COMMUNICATION.MESSAGE.SUCCESS,
            'is_persistent': has_changes,
            'title'        : message
        };
        sessionStorage.setItem( KEY_SESSION_STORAGE_SAVING_LOG_MSG, JSON.stringify( msg ) );
        setTimeout( mapping( prev_action, MANAGER.__instance_element_distributor.current_user.is_admin, item_type, item_id, has_item_in_staging ) );
    }
}

function form_error ( arg1, arg2, arg3 ) {
    MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.SAVING_FAILED );
    MANAGER.__instance_loading.removeLoading();
    
    SHINKEN.DOM.remove_class_for( '.btn', 'disabled' );
    SHINKEN.DOM.remove_class_for( '#element-btn-save', 'hide' );
    SHINKEN.DOM.remove_class_for( '#element-btn-submit-to-stagging', 'hide' );
    SHINKEN.DOM.set_inner_HTML_for( '#element-btn-cancel > a > span', _( 'element.cancel' ) );
    SHINKEN.DOM.add_class_for( '#empty-separator', 'hide' );
    if ( arg1.status !== COMMUNICATION.CODE.SUCCESS ) {
        var _text_to_display = arg1.status + ' ' + arg1.statusText;
        if ( arg1.status === 0 ) {
            _text_to_display = _( 'element.backend_unreacheable' );
        }
        show_saving_log( _( 'element.error_save' ) + '</br>' + _text_to_display, '', 'alert-error', false );
    }
    $( window ).trigger( 'resize' );
}

function apply_changes () {
    // We do not want to be prompt when we will exit the page, as we are ok to save
    disable_page_off_warning();
    // with_change, submit_to_stagging
    submit_form( true, false );
}

function really_delete_staging_entry () {
    var f                = document.forms[ 'form-element' ];
    var item_type        = $( f ).data( 'type' );
    var item_id          = MANAGER.__instance_element_distributor.current_element.getUUID();
    var bypass_work_area = MANAGER.WorkFlowManager.getState();
    var params_string    = "";
    
    if ( bypass_work_area === MANAGER.CONST.STATE.WORK_FLOW.STAGING && MANAGER.__instance_element_distributor.current_user.is_admin ) {
        params_string = "?bypass_work_area=1";
    }
    var res     = {};
    prev_action = ACTION_DELETE_ENTRY;
    $( '.btn' ).addClass( 'disabled' );
    $.post( '/element/q/' + item_type + '/delete/' + item_id + params_string, res, null, 'json' ).success( form_success ).error( form_error );
}

//********************************************  ELEMENT HOST     *********************************************************//
function submit_to_stagging ( is_with_comment ) {
    // We do not want to be prompt when we will exit the page, as we are ok to save
    disable_page_off_warning();
    //if ( MANAGER.__instance_element_distributor.current_element.is_new ) {
    //    App.HistoryManager.rollback();
    //}
    
    if ( is_with_comment ) {
        var _comment = SHINKEN.TOOLS.STRING.cleanXss(document.getElementById( "comment-to-submit-for-staging-input" ).value);
        // with_change, submit_to_stagging
        submit_form( false, true, _comment );
    }
    else {
        submit_form( false, true );
    }
    
    close_comment_to_submit_to_stagging();
}

function show_comment_to_submit_to_stagging ( element ) {
    var _element  = document.getElementById( "comment-to-submit-for-staging" );
    var _bounding = element.getBoundingClientRect();
    _element.classList.add( "active" );
    _element.style.top  = _bounding.top + 'px';
    _element.style.left = (_bounding.right + 8) + 'px';
    document.getElementById( "comment-to-submit-for-staging-input" ).focus();
}

function close_comment_to_submit_to_stagging ( e ) {
    if ( e ) {
        e.stopPropagation();
    }
    document.getElementById( "comment-to-submit-for-staging" ).classList.remove( "active" );
    document.getElementById( "comment-to-submit-for-staging-input" ).value = "";
}

function apply_work_area ( propose_delete ) {
    // We do not want to be prompt when we will exit the page, as we are ok to save
    disable_page_off_warning();
    
    var f         = document.forms[ 'form-element' ];
    var item_type = $( f ).data( 'type' );
    //var item_id   = f[ '_id' ].value;
    var item_id   = MANAGER.__instance_element_distributor.current_element.getUUID();
    
    if ( propose_delete ) {
        prev_action = ACTION_APPLY_DELETE_WORK_AREA;
    }
    else {
        prev_action = ACTION_APPLY_WORK_AREA;
    }
    $( '.btn' ).addClass( 'disabled' );
    $.post( '/element/q/' + item_type + '/apply_work_area/' + item_id + '?ts=' + Date.now(), {}, null, 'json' )
     .success( form_success )
     .error( form_error );
}

function reject_work_area () {
    // We do not want to be prompt when we will exit the page, as we are ok to save
    disable_page_off_warning();
    
    var item_sumbit = document.forms[ 'form-element' ];
    var item_type   = $( item_sumbit ).data( 'type' );
    var item_id     = MANAGER.__instance_element_distributor.current_element.getUUID();
    var comment     = $( '#comments-reject' ).val();
    
    comment     = SHINKEN.TOOLS.STRING.cleanXss( comment );
    prev_action = ACTION_REJECT_WORK_AREA;
    $( '.btn' ).addClass( 'disabled' );
    $.post( '/element/q/' + item_type + '/reject_submit/' + item_id + '?ts=' + Date.now(), { 'comment': comment }, null, 'json' )
     .success( form_success )
     .error( form_error );
}

function really_delete_working_area_entry () {
    var f         = document.forms[ 'form-element' ];
    var item_type = $( f ).data( 'type' );
    
    var item_id = MANAGER.__instance_element_distributor.current_element.getUUID();
    
    var res     = {};
    prev_action = ACTION_DELETE_WORKING_AREA_ENTRY;
    $( '.btn' ).addClass( 'disabled' );
    $.post( '/elements/delete/working_area/' + item_type + '/' + item_id, res, null, 'json' ).success( form_success ).error( form_error );
}

function unlock_work_area () {
    if ( confirm( _( 'element.sure' ) ) ) {
        // We do not want to be prompt when we will exit the page, as we are ok to save
        disable_page_off_warning();
        // and do the job
        really_unlock_work_area();
    }
}

function really_unlock_work_area () {
    var f         = document.forms[ 'form-element' ];
    var item_type = $( f ).data( 'type' );
    var item_id   = MANAGER.__instance_element_distributor.current_element.getUUID();
    
    var res     = {};
    prev_action = ACTION_UNLOCK_WORK_AREA;
    $( '.btn' ).addClass( 'disabled' );
    $.post( '/element/q/' + item_type + '/unlock_work_area/' + item_id, res, null, 'json' ).success( form_success ).error( form_error );
}

//********************************************  SOURCE RANGE     *********************************************************//
function form_success_network_range ( is_delete ) {
    var current_time = new Date();
    var message      = is_delete ? _( 'element.object_deleted' ) : _( 'element.object_saved' );
    message += ' ' + _( 'element.at' ) + ' ' + DATE_TIME.FORMAT.getTime( current_time, DATE_TIME.FORMAT.TIME.HH_MM ) + '.';
    show_saving_log( message, '', 'alert-success', false );
    setTimeout( "location.assign('/sources/' + SOURCE_NAME + '?tab=tab-network-scan');", 1000 );
}

function form_errors_network_range ( arg1, arg2, arg3 ) {
    show_saving_log( _( 'element.error_save' ) + '</br>' + arg1.responseText, '', 'alert-error', false );
    
}

function submit_delete_discovery_form () {
    var data = { _id: MANAGER.__instance_element_distributor.current_element.getUUID() };
    $.post( '/sources/' + SOURCE_NAME + '/discovery/delete/', data ).success( form_success_network_range( true ) ).error( form_errors_network_range );
}

//********************************************  SOURCE RANGE     *********************************************************//
function _private_getCfgFileTemplateForCurrentElementNbTap ( property ) {
    var _number = 2;
    var _size   = property.length;
    switch ( _size ) {
        case 2:
        case 3:
            _number += 1;
        case 4:
        case 5:
        case 6:
        case 7:
            _number += 1;
        case 8:
        case 9:
        case 10:
        case 11:
            _number += 1;
        case 12:
        case 13:
        case 14:
        case 15:
            _number += 1;
        case 16:
        case 17:
        case 18:
        case 19:
            _number += 1;
        case 20:
        case 21:
        case 22:
        case 23:
            _number += 1;
            break;
    }
    var _to_return = "";
    for ( var i = 0; i < _number; i++ ) {
        _to_return += "\t";
    }
    return _to_return;
}

function getCfgFileTemplateForCurrentElement () {
    var _values = getCurrentObjectFromProperty();
    var _object = MANAGER.__instance_element_distributor.current_element;
    var _type   = SHINKEN.TOOLS.STRING.getSubStringUntil( _object.getHelpType(), 0, 1 );
    
    switch ( _object.getType() ) {
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
        case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
        case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
            _values[ "register" ] = "0";
            break;
        case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            _type                   = 'host';
            _values[ "register" ]   = "0";
            _values[ "is_cluster" ] = "1";
            break;
        case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            _type                   = 'host';
            _values[ "is_cluster" ] = "1";
            break;
    }
    
    
    _values[ "_SE_UUID" ]      = "core-" + _object.getType() + "-" + _object.getUUID();
    _values[ "_SE_UUID_HASH" ] = SHINKEN.TOOLS.MD5.MD5( _values[ "_SE_UUID" ] );
    
    var _to_return = 'define ' + _type + "{\n";
    var _keys      = Object.keys( _values );
    _keys.sort();
    var _current_key;
    var _current_value;
    var _temp_current_value;
    for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
        _current_key   = _keys[ i ];
        _current_value = _values[ _current_key ];
        if ( _current_key === PROPERTY.CONST.NAME.DUPLICATE_FOREACH_NAME ) {
            _current_value = PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL + _current_value;
        }
        if ( _current_value === undefined || _current_value === '' || _current_key === '_id' ) {
            continue;
        }
        if ( typeof _current_value !== 'string' ) {
            _temp_current_value = "";
            if ( _current_value.has_plus ) {
                _temp_current_value += PROPERTY.CONST.STATE_VALUE_PLUS.ON;
            }
            if ( _current_value.links ) {
                if ( _current_key === OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES ) {
                    for ( var j = 0, _size_j = _current_value.links.length; j < _size_j; j++ ) {
                        _temp_current_value += '\t' + _current_key + _private_getCfgFileTemplateForCurrentElementNbTap( _current_key );
                        var _check = _current_value.links[ j ].check_link.name;
                        if ( !_check ) {
                            var _temp_check_object = MANAGER.__instance_element_distributor.getElement( "core-service-" + _current_value.links[ j ].check_link._id );
                            if ( _temp_check_object ) {
                                _check = _temp_check_object.getName();
                            }
                        }
                        _temp_current_value += _check + ',' + _current_value.links[ j ].key + ' ' + MANAGER.__instance_element_distributor.getElementValueOfLink( _current_value.links[ j ].value ) + '\n';
                    }
                }
                else {
                    for ( var j = 0, _size_j = _current_value.links.length; j < _size_j; j++ ) {
                        if ( j ) {
                            _temp_current_value += ',';
                        }
                        _temp_current_value += _current_value.links[ j ].name;
                    }
                }
            }
            else if ( _current_value.node ) {
                _temp_current_value = _current_value.raw_value;
            }
            else if ( _current_value.node ) {
                _temp_current_value = _current_value.raw_value;
            }
            
            _current_value = _temp_current_value;
        }
        if ( _current_key === OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES ) {
            _to_return += _current_value;
        }
        else {
            _to_return += "\t" + _current_key + _private_getCfgFileTemplateForCurrentElementNbTap( _current_key ) + _current_value + "\n";
        }
    }
    _to_return += "}\n";
    console.log(_to_return);
}

function getCfgFormatOverrideForCurrentElement () {
    var _override_values = getCurrentObjectFromProperty()[ OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES ];
    if ( !_override_values ) {
        return _( 'element.no_override_defined' );
    }
    var _size      = _override_values.links.length;
    var _check;
    var _current_link;
    var _to_return = "<span class='shinken-override-cfg-format-property'>" + OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES + SHINKEN.TOOLS.STRING.CONST.NON_BREAK_SPACE + SHINKEN.TOOLS.STRING.CONST.NON_BREAK_SPACE + "</span>";
    _to_return += "<span class='shinken-override-cfg-format-text'>";
    for ( var i = 0; i < _size; i++ ) {
        _current_link = _override_values.links[ i ];
        _check        = _current_link.check_link.name;
        if ( !_check ) {
            var _temp_check_object = MANAGER.__instance_element_distributor.getElement( "core-service-" + _current_link.check_link._id );
            if ( _temp_check_object ) {
                _check = _temp_check_object.getName();
            }
        }
        _to_return += _check + ',' + _current_link.key + ' ' + MANAGER.__instance_element_distributor.getElementValueOfLink( _current_link.value );
        
        if ( i !== _size - 1 ) {
            _to_return += PROPERTY.CONST.OVERRIDE.SEPERATOR.BETWEEN;
        }
    }
    _to_return += "</span>";
    return _to_return;
    
}