# !/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.


try:
    from shinken.synchronizer.business.item_controller.exceptions import UnauthorizedSaveException
    from shinken.synchronizer.front_end.helper_frontend_response import FrontEndSaveResponse
    from shinken.synchronizer.front_end.object.messages import ValidatorMessages, Message, MESSAGE
except ImportError:
    from synchronizer.business.item_controller.exceptions import UnauthorizedSaveException
    from synchronizer.front_end.helper_frontend_response import FrontEndSaveResponse
    from synchronizer.front_end.object.messages import ValidatorMessages, Message, MESSAGE


def return_error_if_unauthorized_save_exception(func):
    def wrapper(*args, **kwargs):
        try:
            return func(*args, **kwargs)
        except UnauthorizedSaveException as e:
            validator_message = ValidatorMessages()
            validator_message.add_message(Message(MESSAGE.STATUS_CRITICAL, e.text))
            response = FrontEndSaveResponse(validator_message, return_code=e.code)
            return response.get_response()
    
    
    return wrapper
