%from ...dao.def_items import ITEM_STATE, PROP_DEFAULT_VALUE, ITEM_TYPE, METADATA, SOURCE_STATE

<div class="cell filter column-type bloc-ok">
    %if in_working_area or h.get_type() != ITEM_TYPE.HOSTS:
        %if METADATA.get_metadata(h, METADATA.SOURCE_STATE) == SOURCE_STATE.CHANGE:
            <span  class="tag difference"> {{app._('element.difference')}} </span>
            <div class="change-tooltip">
                <span class="shinken-hook-pop-up" onclick="MANAGER.EventManager.clickOnHooksPopup(event, this)">
                    <span class="icon-pushpin icon-light "></span>
                </span>
                <table>
                    <tr style='border-bottom: 1px solid';>
                        <th>{{app._('element.import_key')}}</th>
                        <th>{{app._('element.property')}}</th>
                        <th>{{app._('element.validated_value')}}</th>
                        <th>{{app._('element.proposed_value')}}</th>
                        <th>{{app._('element.from')}}</th>
                    </tr>
                %for item_property, raw_change in METADATA.get_metadata(h, METADATA.CHANGES).iteritems():
                    %_old, _new, source_info_prop = raw_change
                    %_old, _new, _is_protected_password = app.helper.diff_to_display(item_property, h.get_type(), _old, _new)
                    %_from = source_info_prop.as_string(user)

                    %# clean null value from old for display
                    %if _old == 'null' or _old == '' or _old == None:
                        %_old = app._('apply.value_empty')
                    %elif _old == PROP_DEFAULT_VALUE:
                        %_old = app._('apply.value_default')
                    %end

                    %if _new == PROP_DEFAULT_VALUE:
                        %_new = app._('apply.value_default')
                    %end

                    %item_property_display_name = app.helper.get_item_property_display_name(h.get_type(), item_property)
                    <tr>
                        <td class='property'>{{item_property}}</td>
                        %if item_property_display_name == app._('element.unknown_import_key'):
                            <td class='property'>
                                <span class="circle" style="display: inline-block;vertical-align: middle;"> <i class="shinkon-question"></i></span><span style="display: inline-block;vertical-align: middle;width: 70%;">{{item_property_display_name}}</span>
                            </td>
                        %else:
                            <td class='property'>{{item_property_display_name}}</td>
                        %end

                        %if _is_protected_password:
                            <td class='shinken-protected-password' colspan="2"> {{!_new }} </td>
                        %else:
                            <td class='current-value'>{{ !_old }}</td>
                            <td class='new-value'>{{ !_new }}</td>
                        %end
                        <td class='from-sources'>
                            <ul>
                                %for _s in _from.split('\n'):
                                     <li>{{_s}}</li>
                                %end
                            </ul>
                        </td>
                    </tr>
                %end
                </table>
            </div>
        %elif METADATA.get_metadata(h, METADATA.SOURCE_STATE) == SOURCE_STATE.NEW:
            <span  class="tag new">{{app._('element.new')}}</span>
        %end
    %end
</div>
